/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.PathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeltaTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeltaTarget> {
    private static final SdkField<List<String>> DELTA_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeltaTables").getter(DeltaTarget.getter(DeltaTarget::deltaTables)).setter(DeltaTarget.setter(Builder::deltaTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeltaTables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(DeltaTarget.getter(DeltaTarget::connectionName)).setter(DeltaTarget.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<Boolean> WRITE_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WriteManifest").getter(DeltaTarget.getter(DeltaTarget::writeManifest)).setter(DeltaTarget.setter(Builder::writeManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteManifest").build()}).build();
    private static final SdkField<Boolean> CREATE_NATIVE_DELTA_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CreateNativeDeltaTable").getter(DeltaTarget.getter(DeltaTarget::createNativeDeltaTable)).setter(DeltaTarget.setter(Builder::createNativeDeltaTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateNativeDeltaTable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELTA_TABLES_FIELD, CONNECTION_NAME_FIELD, WRITE_MANIFEST_FIELD, CREATE_NATIVE_DELTA_TABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeltaTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> deltaTables;
    private final String connectionName;
    private final Boolean writeManifest;
    private final Boolean createNativeDeltaTable;

    private DeltaTarget(BuilderImpl builder) {
        this.deltaTables = builder.deltaTables;
        this.connectionName = builder.connectionName;
        this.writeManifest = builder.writeManifest;
        this.createNativeDeltaTable = builder.createNativeDeltaTable;
    }

    public final boolean hasDeltaTables() {
        return this.deltaTables != null && !(this.deltaTables instanceof SdkAutoConstructList);
    }

    public final List<String> deltaTables() {
        return this.deltaTables;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final Boolean writeManifest() {
        return this.writeManifest;
    }

    public final Boolean createNativeDeltaTable() {
        return this.createNativeDeltaTable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeltaTables() ? this.deltaTables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeManifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.createNativeDeltaTable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeltaTarget)) {
            return false;
        }
        DeltaTarget other = (DeltaTarget)obj;
        return this.hasDeltaTables() == other.hasDeltaTables() && Objects.equals(this.deltaTables(), other.deltaTables()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.writeManifest(), other.writeManifest()) && Objects.equals(this.createNativeDeltaTable(), other.createNativeDeltaTable());
    }

    public final String toString() {
        return ToString.builder((String)"DeltaTarget").add("DeltaTables", this.hasDeltaTables() ? this.deltaTables() : null).add("ConnectionName", (Object)this.connectionName()).add("WriteManifest", (Object)this.writeManifest()).add("CreateNativeDeltaTable", (Object)this.createNativeDeltaTable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeltaTables": {
                return Optional.ofNullable(clazz.cast(this.deltaTables()));
            }
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "WriteManifest": {
                return Optional.ofNullable(clazz.cast(this.writeManifest()));
            }
            case "CreateNativeDeltaTable": {
                return Optional.ofNullable(clazz.cast(this.createNativeDeltaTable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeltaTables", DELTA_TABLES_FIELD);
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("WriteManifest", WRITE_MANIFEST_FIELD);
        map.put("CreateNativeDeltaTable", CREATE_NATIVE_DELTA_TABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeltaTarget, T> g) {
        return obj -> g.apply((DeltaTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> deltaTables = DefaultSdkAutoConstructList.getInstance();
        private String connectionName;
        private Boolean writeManifest;
        private Boolean createNativeDeltaTable;

        private BuilderImpl() {
        }

        private BuilderImpl(DeltaTarget model) {
            this.deltaTables(model.deltaTables);
            this.connectionName(model.connectionName);
            this.writeManifest(model.writeManifest);
            this.createNativeDeltaTable(model.createNativeDeltaTable);
        }

        public final Collection<String> getDeltaTables() {
            if (this.deltaTables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deltaTables;
        }

        public final void setDeltaTables(Collection<String> deltaTables) {
            this.deltaTables = PathListCopier.copy(deltaTables);
        }

        @Override
        public final Builder deltaTables(Collection<String> deltaTables) {
            this.deltaTables = PathListCopier.copy(deltaTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deltaTables(String ... deltaTables) {
            this.deltaTables(Arrays.asList(deltaTables));
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final Boolean getWriteManifest() {
            return this.writeManifest;
        }

        public final void setWriteManifest(Boolean writeManifest) {
            this.writeManifest = writeManifest;
        }

        @Override
        public final Builder writeManifest(Boolean writeManifest) {
            this.writeManifest = writeManifest;
            return this;
        }

        public final Boolean getCreateNativeDeltaTable() {
            return this.createNativeDeltaTable;
        }

        public final void setCreateNativeDeltaTable(Boolean createNativeDeltaTable) {
            this.createNativeDeltaTable = createNativeDeltaTable;
        }

        @Override
        public final Builder createNativeDeltaTable(Boolean createNativeDeltaTable) {
            this.createNativeDeltaTable = createNativeDeltaTable;
            return this;
        }

        public DeltaTarget build() {
            return new DeltaTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeltaTarget> {
        public Builder deltaTables(Collection<String> var1);

        public Builder deltaTables(String ... var1);

        public Builder connectionName(String var1);

        public Builder writeManifest(Boolean var1);

        public Builder createNativeDeltaTable(Boolean var1);
    }
}

