/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCatalogsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetCatalogsRequest> {
    private static final SdkField<String> PARENT_CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentCatalogId").getter(GetCatalogsRequest.getter(GetCatalogsRequest::parentCatalogId)).setter(GetCatalogsRequest.setter(Builder::parentCatalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentCatalogId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCatalogsRequest.getter(GetCatalogsRequest::nextToken)).setter(GetCatalogsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetCatalogsRequest.getter(GetCatalogsRequest::maxResults)).setter(GetCatalogsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Boolean> RECURSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Recursive").getter(GetCatalogsRequest.getter(GetCatalogsRequest::recursive)).setter(GetCatalogsRequest.setter(Builder::recursive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recursive").build()}).build();
    private static final SdkField<Boolean> INCLUDE_ROOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeRoot").getter(GetCatalogsRequest.getter(GetCatalogsRequest::includeRoot)).setter(GetCatalogsRequest.setter(Builder::includeRoot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeRoot").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_CATALOG_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RECURSIVE_FIELD, INCLUDE_ROOT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCatalogsRequest.memberNameToFieldInitializer();
    private final String parentCatalogId;
    private final String nextToken;
    private final Integer maxResults;
    private final Boolean recursive;
    private final Boolean includeRoot;

    private GetCatalogsRequest(BuilderImpl builder) {
        super(builder);
        this.parentCatalogId = builder.parentCatalogId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.recursive = builder.recursive;
        this.includeRoot = builder.includeRoot;
    }

    public final String parentCatalogId() {
        return this.parentCatalogId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Boolean recursive() {
        return this.recursive;
    }

    public final Boolean includeRoot() {
        return this.includeRoot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.parentCatalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.recursive());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeRoot());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCatalogsRequest)) {
            return false;
        }
        GetCatalogsRequest other = (GetCatalogsRequest)((Object)obj);
        return Objects.equals(this.parentCatalogId(), other.parentCatalogId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.recursive(), other.recursive()) && Objects.equals(this.includeRoot(), other.includeRoot());
    }

    public final String toString() {
        return ToString.builder((String)"GetCatalogsRequest").add("ParentCatalogId", (Object)this.parentCatalogId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Recursive", (Object)this.recursive()).add("IncludeRoot", (Object)this.includeRoot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentCatalogId": {
                return Optional.ofNullable(clazz.cast(this.parentCatalogId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Recursive": {
                return Optional.ofNullable(clazz.cast(this.recursive()));
            }
            case "IncludeRoot": {
                return Optional.ofNullable(clazz.cast(this.includeRoot()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ParentCatalogId", PARENT_CATALOG_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Recursive", RECURSIVE_FIELD);
        map.put("IncludeRoot", INCLUDE_ROOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCatalogsRequest, T> g) {
        return obj -> g.apply((GetCatalogsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String parentCatalogId;
        private String nextToken;
        private Integer maxResults;
        private Boolean recursive;
        private Boolean includeRoot;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCatalogsRequest model) {
            super(model);
            this.parentCatalogId(model.parentCatalogId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.recursive(model.recursive);
            this.includeRoot(model.includeRoot);
        }

        public final String getParentCatalogId() {
            return this.parentCatalogId;
        }

        public final void setParentCatalogId(String parentCatalogId) {
            this.parentCatalogId = parentCatalogId;
        }

        @Override
        public final Builder parentCatalogId(String parentCatalogId) {
            this.parentCatalogId = parentCatalogId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getRecursive() {
            return this.recursive;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final Boolean getIncludeRoot() {
            return this.includeRoot;
        }

        public final void setIncludeRoot(Boolean includeRoot) {
            this.includeRoot = includeRoot;
        }

        @Override
        public final Builder includeRoot(Boolean includeRoot) {
            this.includeRoot = includeRoot;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCatalogsRequest build() {
            return new GetCatalogsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCatalogsRequest> {
        public Builder parentCatalogId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder recursive(Boolean var1);

        public Builder includeRoot(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

