/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.SourceControlAuthStrategy;
import software.amazon.awssdk.services.glue.model.SourceControlProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceControlDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceControlDetails> {
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Provider").getter(SourceControlDetails.getter(SourceControlDetails::providerAsString)).setter(SourceControlDetails.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Repository").getter(SourceControlDetails.getter(SourceControlDetails::repository)).setter(SourceControlDetails.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Repository").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(SourceControlDetails.getter(SourceControlDetails::owner)).setter(SourceControlDetails.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Branch").getter(SourceControlDetails.getter(SourceControlDetails::branch)).setter(SourceControlDetails.setter(Builder::branch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()}).build();
    private static final SdkField<String> FOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Folder").getter(SourceControlDetails.getter(SourceControlDetails::folder)).setter(SourceControlDetails.setter(Builder::folder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folder").build()}).build();
    private static final SdkField<String> LAST_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastCommitId").getter(SourceControlDetails.getter(SourceControlDetails::lastCommitId)).setter(SourceControlDetails.setter(Builder::lastCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCommitId").build()}).build();
    private static final SdkField<String> AUTH_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthStrategy").getter(SourceControlDetails.getter(SourceControlDetails::authStrategyAsString)).setter(SourceControlDetails.setter(Builder::authStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthStrategy").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthToken").getter(SourceControlDetails.getter(SourceControlDetails::authToken)).setter(SourceControlDetails.setter(Builder::authToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_FIELD, REPOSITORY_FIELD, OWNER_FIELD, BRANCH_FIELD, FOLDER_FIELD, LAST_COMMIT_ID_FIELD, AUTH_STRATEGY_FIELD, AUTH_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceControlDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String provider;
    private final String repository;
    private final String owner;
    private final String branch;
    private final String folder;
    private final String lastCommitId;
    private final String authStrategy;
    private final String authToken;

    private SourceControlDetails(BuilderImpl builder) {
        this.provider = builder.provider;
        this.repository = builder.repository;
        this.owner = builder.owner;
        this.branch = builder.branch;
        this.folder = builder.folder;
        this.lastCommitId = builder.lastCommitId;
        this.authStrategy = builder.authStrategy;
        this.authToken = builder.authToken;
    }

    public final SourceControlProvider provider() {
        return SourceControlProvider.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    public final String repository() {
        return this.repository;
    }

    public final String owner() {
        return this.owner;
    }

    public final String branch() {
        return this.branch;
    }

    public final String folder() {
        return this.folder;
    }

    public final String lastCommitId() {
        return this.lastCommitId;
    }

    public final SourceControlAuthStrategy authStrategy() {
        return SourceControlAuthStrategy.fromValue(this.authStrategy);
    }

    public final String authStrategyAsString() {
        return this.authStrategy;
    }

    public final String authToken() {
        return this.authToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.folder());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceControlDetails)) {
            return false;
        }
        SourceControlDetails other = (SourceControlDetails)obj;
        return Objects.equals(this.providerAsString(), other.providerAsString()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.branch(), other.branch()) && Objects.equals(this.folder(), other.folder()) && Objects.equals(this.lastCommitId(), other.lastCommitId()) && Objects.equals(this.authStrategyAsString(), other.authStrategyAsString()) && Objects.equals(this.authToken(), other.authToken());
    }

    public final String toString() {
        return ToString.builder((String)"SourceControlDetails").add("Provider", (Object)this.providerAsString()).add("Repository", (Object)this.repository()).add("Owner", (Object)this.owner()).add("Branch", (Object)this.branch()).add("Folder", (Object)this.folder()).add("LastCommitId", (Object)this.lastCommitId()).add("AuthStrategy", (Object)this.authStrategyAsString()).add("AuthToken", (Object)this.authToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
            case "Repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "Folder": {
                return Optional.ofNullable(clazz.cast(this.folder()));
            }
            case "LastCommitId": {
                return Optional.ofNullable(clazz.cast(this.lastCommitId()));
            }
            case "AuthStrategy": {
                return Optional.ofNullable(clazz.cast(this.authStrategyAsString()));
            }
            case "AuthToken": {
                return Optional.ofNullable(clazz.cast(this.authToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Provider", PROVIDER_FIELD);
        map.put("Repository", REPOSITORY_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("Branch", BRANCH_FIELD);
        map.put("Folder", FOLDER_FIELD);
        map.put("LastCommitId", LAST_COMMIT_ID_FIELD);
        map.put("AuthStrategy", AUTH_STRATEGY_FIELD);
        map.put("AuthToken", AUTH_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceControlDetails, T> g) {
        return obj -> g.apply((SourceControlDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String provider;
        private String repository;
        private String owner;
        private String branch;
        private String folder;
        private String lastCommitId;
        private String authStrategy;
        private String authToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceControlDetails model) {
            this.provider(model.provider);
            this.repository(model.repository);
            this.owner(model.owner);
            this.branch(model.branch);
            this.folder(model.folder);
            this.lastCommitId(model.lastCommitId);
            this.authStrategy(model.authStrategy);
            this.authToken(model.authToken);
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(SourceControlProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getBranch() {
            return this.branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getFolder() {
            return this.folder;
        }

        public final void setFolder(String folder) {
            this.folder = folder;
        }

        @Override
        public final Builder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public final String getLastCommitId() {
            return this.lastCommitId;
        }

        public final void setLastCommitId(String lastCommitId) {
            this.lastCommitId = lastCommitId;
        }

        @Override
        public final Builder lastCommitId(String lastCommitId) {
            this.lastCommitId = lastCommitId;
            return this;
        }

        public final String getAuthStrategy() {
            return this.authStrategy;
        }

        public final void setAuthStrategy(String authStrategy) {
            this.authStrategy = authStrategy;
        }

        @Override
        public final Builder authStrategy(String authStrategy) {
            this.authStrategy = authStrategy;
            return this;
        }

        @Override
        public final Builder authStrategy(SourceControlAuthStrategy authStrategy) {
            this.authStrategy(authStrategy == null ? null : authStrategy.toString());
            return this;
        }

        public final String getAuthToken() {
            return this.authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public SourceControlDetails build() {
            return new SourceControlDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceControlDetails> {
        public Builder provider(String var1);

        public Builder provider(SourceControlProvider var1);

        public Builder repository(String var1);

        public Builder owner(String var1);

        public Builder branch(String var1);

        public Builder folder(String var1);

        public Builder lastCommitId(String var1);

        public Builder authStrategy(String var1);

        public Builder authStrategy(SourceControlAuthStrategy var1);

        public Builder authToken(String var1);
    }
}

