/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StatisticEvaluationLevel {
    DATASET("Dataset"),
    COLUMN("Column"),
    MULTICOLUMN("Multicolumn"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StatisticEvaluationLevel> VALUE_MAP;
    private final String value;

    private StatisticEvaluationLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatisticEvaluationLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatisticEvaluationLevel> knownValues() {
        EnumSet<StatisticEvaluationLevel> knownValues = EnumSet.allOf(StatisticEvaluationLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StatisticEvaluationLevel.class, StatisticEvaluationLevel::toString);
    }
}

