/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccountAccessType {
    CURRENT_ACCOUNT("CURRENT_ACCOUNT"),
    ORGANIZATION("ORGANIZATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccountAccessType> VALUE_MAP;
    private final String value;

    private AccountAccessType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountAccessType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccountAccessType> knownValues() {
        EnumSet<AccountAccessType> knownValues = EnumSet.allOf(AccountAccessType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccountAccessType.class, AccountAccessType::toString);
    }
}

