/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BandwidthUnits {
    G_HZ("GHz"),
    M_HZ("MHz"),
    K_HZ("kHz"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BandwidthUnits(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BandwidthUnits fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BandwidthUnits.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BandwidthUnits> knownValues() {
        return Stream.of(BandwidthUnits.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

