/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FrequencyUnits {
    G_HZ("GHz"),
    M_HZ("MHz"),
    K_HZ("kHz"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FrequencyUnits(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FrequencyUnits fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FrequencyUnits.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FrequencyUnits> knownValues() {
        return Stream.of(FrequencyUnits.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

