/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationClient;
import software.amazon.awssdk.services.groundstation.model.ListSatellitesRequest;
import software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse;
import software.amazon.awssdk.services.groundstation.model.SatelliteListItem;

public class ListSatellitesIterable
implements SdkIterable<ListSatellitesResponse> {
    private final GroundStationClient client;
    private final ListSatellitesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSatellitesIterable(GroundStationClient client, ListSatellitesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSatellitesResponseFetcher();
    }

    public Iterator<ListSatellitesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SatelliteListItem> satellites() {
        Function<ListSatellitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.satellites() != null) {
                return response.satellites().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSatellitesResponseFetcher
    implements SyncPageFetcher<ListSatellitesResponse> {
        private ListSatellitesResponseFetcher() {
        }

        public boolean hasNextPage(ListSatellitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSatellitesResponse nextPage(ListSatellitesResponse previousPage) {
            if (previousPage == null) {
                return ListSatellitesIterable.this.client.listSatellites(ListSatellitesIterable.this.firstRequest);
            }
            return ListSatellitesIterable.this.client.listSatellites((ListSatellitesRequest)((Object)ListSatellitesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

