/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<ListFindingsResponse.Builder, ListFindingsResponse> {
    private static final SdkField<List<String>> FINDING_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListFindingsResponse::findingIds))
            .setter(setter(Builder::findingIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFindingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> findingIds;

    private final String nextToken;

    private ListFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findingIds = builder.findingIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the FindingIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFindingIds() {
        return findingIds != null && !(findingIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the findings you are listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindingIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the findings you are listing.
     */
    public List<String> findingIds() {
        return findingIds;
    }

    /**
     * <p>
     * Pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @return Pagination parameter to be used on the next list operation to retrieve more items.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(findingIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsResponse)) {
            return false;
        }
        ListFindingsResponse other = (ListFindingsResponse) obj;
        return Objects.equals(findingIds(), other.findingIds()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFindingsResponse").add("FindingIds", findingIds()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingIds":
            return Optional.ofNullable(clazz.cast(findingIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsResponse, T> g) {
        return obj -> g.apply((ListFindingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFindingsResponse> {
        /**
         * <p>
         * The IDs of the findings you are listing.
         * </p>
         * 
         * @param findingIds
         *        The IDs of the findings you are listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(Collection<String> findingIds);

        /**
         * <p>
         * The IDs of the findings you are listing.
         * </p>
         * 
         * @param findingIds
         *        The IDs of the findings you are listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(String... findingIds);

        /**
         * <p>
         * Pagination parameter to be used on the next list operation to retrieve more items.
         * </p>
         * 
         * @param nextToken
         *        Pagination parameter to be used on the next list operation to retrieve more items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private List<String> findingIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsResponse model) {
            super(model);
            findingIds(model.findingIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getFindingIds() {
            return findingIds;
        }

        @Override
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIds(String... findingIds) {
            findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFindingsResponse build() {
            return new ListFindingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
