/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.TagMapCopier;
import software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat;
import software.amazon.awssdk.services.guardduty.model.ThreatIntelSetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetThreatIntelSetResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, GetThreatIntelSetResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetThreatIntelSetResponse.getter(GetThreatIntelSetResponse::name)).setter(GetThreatIntelSetResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetThreatIntelSetResponse.getter(GetThreatIntelSetResponse::formatAsString)).setter(GetThreatIntelSetResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetThreatIntelSetResponse.getter(GetThreatIntelSetResponse::location)).setter(GetThreatIntelSetResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetThreatIntelSetResponse.getter(GetThreatIntelSetResponse::statusAsString)).setter(GetThreatIntelSetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetThreatIntelSetResponse.getter(GetThreatIntelSetResponse::tags)).setter(GetThreatIntelSetResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FORMAT_FIELD, LOCATION_FIELD, STATUS_FIELD, TAGS_FIELD));
    private final String name;
    private final String format;
    private final String location;
    private final String status;
    private final Map<String, String> tags;

    private GetThreatIntelSetResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.format = builder.format;
        this.location = builder.location;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public String name() {
        return this.name;
    }

    public ThreatIntelSetFormat format() {
        return ThreatIntelSetFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public String location() {
        return this.location;
    }

    public ThreatIntelSetStatus status() {
        return ThreatIntelSetStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetThreatIntelSetResponse)) {
            return false;
        }
        GetThreatIntelSetResponse other = (GetThreatIntelSetResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetThreatIntelSetResponse").add("Name", (Object)this.name()).add("Format", (Object)this.formatAsString()).add("Location", (Object)this.location()).add("Status", (Object)this.statusAsString()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetThreatIntelSetResponse, T> g) {
        return obj -> g.apply((GetThreatIntelSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private String name;
        private String format;
        private String location;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetThreatIntelSetResponse model) {
            super(model);
            this.name(model.name);
            this.format(model.format);
            this.location(model.location);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFormatAsString() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ThreatIntelSetFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ThreatIntelSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public GetThreatIntelSetResponse build() {
            return new GetThreatIntelSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetThreatIntelSetResponse> {
        public Builder name(String var1);

        public Builder format(String var1);

        public Builder format(ThreatIntelSetFormat var1);

        public Builder location(String var1);

        public Builder status(String var1);

        public Builder status(ThreatIntelSetStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

