/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the reason the scan was triggered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TriggerDetails implements SdkPojo, Serializable, ToCopyableBuilder<TriggerDetails.Builder, TriggerDetails> {
    private static final SdkField<String> GUARD_DUTY_FINDING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GuardDutyFindingId").getter(getter(TriggerDetails::guardDutyFindingId))
            .setter(setter(Builder::guardDutyFindingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardDutyFindingId").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TriggerDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARD_DUTY_FINDING_ID_FIELD,
            DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String guardDutyFindingId;

    private final String description;

    private TriggerDetails(BuilderImpl builder) {
        this.guardDutyFindingId = builder.guardDutyFindingId;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ID of the GuardDuty finding that triggered the BirdDog scan.
     * </p>
     * 
     * @return The ID of the GuardDuty finding that triggered the BirdDog scan.
     */
    public final String guardDutyFindingId() {
        return guardDutyFindingId;
    }

    /**
     * <p>
     * The description of the scan trigger.
     * </p>
     * 
     * @return The description of the scan trigger.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guardDutyFindingId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerDetails)) {
            return false;
        }
        TriggerDetails other = (TriggerDetails) obj;
        return Objects.equals(guardDutyFindingId(), other.guardDutyFindingId())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TriggerDetails").add("GuardDutyFindingId", guardDutyFindingId())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GuardDutyFindingId":
            return Optional.ofNullable(clazz.cast(guardDutyFindingId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TriggerDetails, T> g) {
        return obj -> g.apply((TriggerDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TriggerDetails> {
        /**
         * <p>
         * The ID of the GuardDuty finding that triggered the BirdDog scan.
         * </p>
         * 
         * @param guardDutyFindingId
         *        The ID of the GuardDuty finding that triggered the BirdDog scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardDutyFindingId(String guardDutyFindingId);

        /**
         * <p>
         * The description of the scan trigger.
         * </p>
         * 
         * @param description
         *        The description of the scan trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String guardDutyFindingId;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerDetails model) {
            guardDutyFindingId(model.guardDutyFindingId);
            description(model.description);
        }

        public final String getGuardDutyFindingId() {
            return guardDutyFindingId;
        }

        public final void setGuardDutyFindingId(String guardDutyFindingId) {
            this.guardDutyFindingId = guardDutyFindingId;
        }

        @Override
        public final Builder guardDutyFindingId(String guardDutyFindingId) {
            this.guardDutyFindingId = guardDutyFindingId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public TriggerDetails build() {
            return new TriggerDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
