/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDetectorRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdateDetectorRequest.Builder, UpdateDetectorRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(UpdateDetectorRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enable").getter(getter(UpdateDetectorRequest::enable)).setter(setter(Builder::enable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enable").build()).build();

    private static final SdkField<String> FINDING_PUBLISHING_FREQUENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FindingPublishingFrequency")
            .getter(getter(UpdateDetectorRequest::findingPublishingFrequencyAsString))
            .setter(setter(Builder::findingPublishingFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingPublishingFrequency").build())
            .build();

    private static final SdkField<DataSourceConfigurations> DATA_SOURCES_FIELD = SdkField
            .<DataSourceConfigurations> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(UpdateDetectorRequest::dataSources)).setter(setter(Builder::dataSources))
            .constructor(DataSourceConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            ENABLE_FIELD, FINDING_PUBLISHING_FREQUENCY_FIELD, DATA_SOURCES_FIELD));

    private final String detectorId;

    private final Boolean enable;

    private final String findingPublishingFrequency;

    private final DataSourceConfigurations dataSources;

    private UpdateDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.enable = builder.enable;
        this.findingPublishingFrequency = builder.findingPublishingFrequency;
        this.dataSources = builder.dataSources;
    }

    /**
     * <p>
     * The unique ID of the detector to update.
     * </p>
     * 
     * @return The unique ID of the detector to update.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * Specifies whether the detector is enabled or not enabled.
     * </p>
     * 
     * @return Specifies whether the detector is enabled or not enabled.
     */
    public final Boolean enable() {
        return enable;
    }

    /**
     * <p>
     * An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.
     * @see FindingPublishingFrequency
     */
    public final FindingPublishingFrequency findingPublishingFrequency() {
        return FindingPublishingFrequency.fromValue(findingPublishingFrequency);
    }

    /**
     * <p>
     * An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.
     * @see FindingPublishingFrequency
     */
    public final String findingPublishingFrequencyAsString() {
        return findingPublishingFrequency;
    }

    /**
     * <p>
     * Describes which data sources will be updated.
     * </p>
     * 
     * @return Describes which data sources will be updated.
     */
    public final DataSourceConfigurations dataSources() {
        return dataSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(enable());
        hashCode = 31 * hashCode + Objects.hashCode(findingPublishingFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDetectorRequest)) {
            return false;
        }
        UpdateDetectorRequest other = (UpdateDetectorRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(enable(), other.enable())
                && Objects.equals(findingPublishingFrequencyAsString(), other.findingPublishingFrequencyAsString())
                && Objects.equals(dataSources(), other.dataSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDetectorRequest").add("DetectorId", detectorId()).add("Enable", enable())
                .add("FindingPublishingFrequency", findingPublishingFrequencyAsString()).add("DataSources", dataSources())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "Enable":
            return Optional.ofNullable(clazz.cast(enable()));
        case "FindingPublishingFrequency":
            return Optional.ofNullable(clazz.cast(findingPublishingFrequencyAsString()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDetectorRequest, T> g) {
        return obj -> g.apply((UpdateDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDetectorRequest> {
        /**
         * <p>
         * The unique ID of the detector to update.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the detector to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * Specifies whether the detector is enabled or not enabled.
         * </p>
         * 
         * @param enable
         *        Specifies whether the detector is enabled or not enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enable(Boolean enable);

        /**
         * <p>
         * An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.
         * </p>
         * 
         * @param findingPublishingFrequency
         *        An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(String findingPublishingFrequency);

        /**
         * <p>
         * An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.
         * </p>
         * 
         * @param findingPublishingFrequency
         *        An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency);

        /**
         * <p>
         * Describes which data sources will be updated.
         * </p>
         * 
         * @param dataSources
         *        Describes which data sources will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSourceConfigurations dataSources);

        /**
         * <p>
         * Describes which data sources will be updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfigurations.Builder}
         * avoiding the need to create one manually via {@link DataSourceConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSources(DataSourceConfigurations)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link DataSourceConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(DataSourceConfigurations)
         */
        default Builder dataSources(Consumer<DataSourceConfigurations.Builder> dataSources) {
            return dataSources(DataSourceConfigurations.builder().applyMutation(dataSources).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private Boolean enable;

        private String findingPublishingFrequency;

        private DataSourceConfigurations dataSources;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDetectorRequest model) {
            super(model);
            detectorId(model.detectorId);
            enable(model.enable);
            findingPublishingFrequency(model.findingPublishingFrequency);
            dataSources(model.dataSources);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final Boolean getEnable() {
            return enable;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final String getFindingPublishingFrequency() {
            return findingPublishingFrequency;
        }

        public final void setFindingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
        }

        @Override
        public final Builder findingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
            return this;
        }

        @Override
        public final Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency) {
            this.findingPublishingFrequency(findingPublishingFrequency == null ? null : findingPublishingFrequency.toString());
            return this;
        }

        public final DataSourceConfigurations.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        public final void setDataSources(DataSourceConfigurations.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        public final Builder dataSources(DataSourceConfigurations dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDetectorRequest build() {
            return new UpdateDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
