/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a condition that when matched will be added to the response of the operation. Irrespective of using any
 * filter criteria, an administrator account can view the scan entries for all of its member accounts. However, each
 * member account can view the scan entries only for their own account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterCriterion implements SdkPojo, Serializable, ToCopyableBuilder<FilterCriterion.Builder, FilterCriterion> {
    private static final SdkField<String> CRITERION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CriterionKey").getter(getter(FilterCriterion::criterionKeyAsString))
            .setter(setter(Builder::criterionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criterionKey").build()).build();

    private static final SdkField<FilterCondition> FILTER_CONDITION_FIELD = SdkField
            .<FilterCondition> builder(MarshallingType.SDK_POJO).memberName("FilterCondition")
            .getter(getter(FilterCriterion::filterCondition)).setter(setter(Builder::filterCondition))
            .constructor(FilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITERION_KEY_FIELD,
            FILTER_CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String criterionKey;

    private final FilterCondition filterCondition;

    private FilterCriterion(BuilderImpl builder) {
        this.criterionKey = builder.criterionKey;
        this.filterCondition = builder.filterCondition;
    }

    /**
     * <p>
     * An enum value representing possible scan properties to match with given scan entries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #criterionKey} will
     * return {@link CriterionKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #criterionKeyAsString}.
     * </p>
     * 
     * @return An enum value representing possible scan properties to match with given scan entries.
     * @see CriterionKey
     */
    public final CriterionKey criterionKey() {
        return CriterionKey.fromValue(criterionKey);
    }

    /**
     * <p>
     * An enum value representing possible scan properties to match with given scan entries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #criterionKey} will
     * return {@link CriterionKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #criterionKeyAsString}.
     * </p>
     * 
     * @return An enum value representing possible scan properties to match with given scan entries.
     * @see CriterionKey
     */
    public final String criterionKeyAsString() {
        return criterionKey;
    }

    /**
     * <p>
     * Contains information about the condition.
     * </p>
     * 
     * @return Contains information about the condition.
     */
    public final FilterCondition filterCondition() {
        return filterCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(criterionKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterCriterion)) {
            return false;
        }
        FilterCriterion other = (FilterCriterion) obj;
        return Objects.equals(criterionKeyAsString(), other.criterionKeyAsString())
                && Objects.equals(filterCondition(), other.filterCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterCriterion").add("CriterionKey", criterionKeyAsString())
                .add("FilterCondition", filterCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CriterionKey":
            return Optional.ofNullable(clazz.cast(criterionKeyAsString()));
        case "FilterCondition":
            return Optional.ofNullable(clazz.cast(filterCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterCriterion, T> g) {
        return obj -> g.apply((FilterCriterion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterCriterion> {
        /**
         * <p>
         * An enum value representing possible scan properties to match with given scan entries.
         * </p>
         * 
         * @param criterionKey
         *        An enum value representing possible scan properties to match with given scan entries.
         * @see CriterionKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CriterionKey
         */
        Builder criterionKey(String criterionKey);

        /**
         * <p>
         * An enum value representing possible scan properties to match with given scan entries.
         * </p>
         * 
         * @param criterionKey
         *        An enum value representing possible scan properties to match with given scan entries.
         * @see CriterionKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CriterionKey
         */
        Builder criterionKey(CriterionKey criterionKey);

        /**
         * <p>
         * Contains information about the condition.
         * </p>
         * 
         * @param filterCondition
         *        Contains information about the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCondition(FilterCondition filterCondition);

        /**
         * <p>
         * Contains information about the condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCondition.Builder} avoiding the
         * need to create one manually via {@link FilterCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #filterCondition(FilterCondition)}.
         * 
         * @param filterCondition
         *        a consumer that will call methods on {@link FilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCondition(FilterCondition)
         */
        default Builder filterCondition(Consumer<FilterCondition.Builder> filterCondition) {
            return filterCondition(FilterCondition.builder().applyMutation(filterCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String criterionKey;

        private FilterCondition filterCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterCriterion model) {
            criterionKey(model.criterionKey);
            filterCondition(model.filterCondition);
        }

        public final String getCriterionKey() {
            return criterionKey;
        }

        public final void setCriterionKey(String criterionKey) {
            this.criterionKey = criterionKey;
        }

        @Override
        public final Builder criterionKey(String criterionKey) {
            this.criterionKey = criterionKey;
            return this;
        }

        @Override
        public final Builder criterionKey(CriterionKey criterionKey) {
            this.criterionKey(criterionKey == null ? null : criterionKey.toString());
            return this;
        }

        public final FilterCondition.Builder getFilterCondition() {
            return filterCondition != null ? filterCondition.toBuilder() : null;
        }

        public final void setFilterCondition(FilterCondition.BuilderImpl filterCondition) {
            this.filterCondition = filterCondition != null ? filterCondition.build() : null;
        }

        @Override
        public final Builder filterCondition(FilterCondition filterCondition) {
            this.filterCondition = filterCondition;
            return this;
        }

        @Override
        public FilterCriterion build() {
            return new FilterCriterion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
