/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.health.model.ConcurrentModificationException;
import software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationResponse;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationResponse;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse;
import software.amazon.awssdk.services.health.model.DescribeEntityAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEntityAggregatesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationResponse;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsRequest;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsResponse;
import software.amazon.awssdk.services.health.model.DescribeEventTypesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventTypesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationResponse;
import software.amazon.awssdk.services.health.model.DescribeEventsRequest;
import software.amazon.awssdk.services.health.model.DescribeEventsResponse;
import software.amazon.awssdk.services.health.model.DescribeHealthServiceStatusForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeHealthServiceStatusForOrganizationResponse;
import software.amazon.awssdk.services.health.model.DisableHealthServiceAccessForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DisableHealthServiceAccessForOrganizationResponse;
import software.amazon.awssdk.services.health.model.EnableHealthServiceAccessForOrganizationRequest;
import software.amazon.awssdk.services.health.model.EnableHealthServiceAccessForOrganizationResponse;
import software.amazon.awssdk.services.health.model.HealthException;
import software.amazon.awssdk.services.health.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.health.model.UnsupportedLocaleException;
import software.amazon.awssdk.services.health.paginators.DescribeAffectedAccountsForOrganizationIterable;
import software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesForOrganizationIterable;
import software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesIterable;
import software.amazon.awssdk.services.health.paginators.DescribeEventAggregatesIterable;
import software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable;
import software.amazon.awssdk.services.health.paginators.DescribeEventsForOrganizationIterable;
import software.amazon.awssdk.services.health.paginators.DescribeEventsIterable;

/**
 * Service client for accessing AWSHealth. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Health</fullname>
 * <p>
 * The AWS Health API provides programmatic access to the AWS Health information that is presented in the <a
 * href="https://phd.aws.amazon.com/phd/home#/">AWS Personal Health Dashboard</a>. You can get information about events
 * that affect your AWS resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DescribeEvents</a>: Summary information about events.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeEventDetails</a>: Detailed information about one or more events.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeAffectedEntities</a>: Information about AWS resources that are affected by one or more events.
 * </p>
 * </li>
 * </ul>
 * <p>
 * In addition, these operations provide information about event types and summary counts of events or affected
 * entities:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DescribeEventTypes</a>: Information about the kinds of events that AWS Health tracks.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeEventAggregates</a>: A count of the number of events that meet specified criteria.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeEntityAggregates</a>: A count of the number of affected entities that meet specified criteria.
 * </p>
 * </li>
 * </ul>
 * <p>
 * AWS Health integrates with AWS Organizations to provide a centralized view of AWS Health events across all accounts
 * in your organization.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DescribeEventsForOrganization</a>: Summary information about events across the organization.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeAffectedAccountsForOrganization</a>: List of accounts in your organization impacted by an event.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeEventDetailsForOrganization</a>: Detailed information about events in your organization.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeAffectedEntitiesForOrganization</a>: Information about AWS resources in your organization that are
 * affected by events.
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can use the following operations to enable or disable AWS Health from working with AWS Organizations.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>EnableHealthServiceAccessForOrganization</a>: Enables AWS Health to work with AWS Organizations.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DisableHealthServiceAccessForOrganization</a>: Disables AWS Health from working with AWS Organizations.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeHealthServiceStatusForOrganization</a>: Status information about enabling or disabling AWS Health from
 * working with AWS Organizations.
 * </p>
 * </li>
 * </ul>
 * <p>
 * The Health API requires a Business or Enterprise support plan from <a
 * href="http://aws.amazon.com/premiumsupport/">AWS Support</a>. Calling the Health API from an account that does not
 * have a Business or Enterprise support plan causes a <code>SubscriptionRequiredException</code>.
 * </p>
 * <p>
 * For authentication of requests, AWS Health uses the <a
 * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
 * Process</a>.
 * </p>
 * <p>
 * See the <a href="https://docs.aws.amazon.com/health/latest/ug/what-is-aws-health.html">AWS Health User Guide</a> for
 * information about how to use the API.
 * </p>
 * <p>
 * <b>Service Endpoint</b>
 * </p>
 * <p>
 * The HTTP endpoint for the AWS Health API is:
 * </p>
 * <ul>
 * <li>
 * <p>
 * https://health.us-east-1.amazonaws.com
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public interface HealthClient extends SdkClient {
    String SERVICE_NAME = "health";

    /**
     * Create a {@link HealthClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static HealthClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link HealthClient}.
     */
    static HealthClientBuilder builder() {
        return new DefaultHealthClientBuilder();
    }

    /**
     * <p>
     * Returns a list of accounts in the organization from AWS Organizations that are affected by the provided event.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable AWS Health to work with AWS Organizations. To do this,
     * call the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     *
     * @param describeAffectedAccountsForOrganizationRequest
     * @return Result of the DescribeAffectedAccountsForOrganization operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedAccountsForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedAccountsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedAccountsForOrganizationResponse describeAffectedAccountsForOrganization(
            DescribeAffectedAccountsForOrganizationRequest describeAffectedAccountsForOrganizationRequest)
            throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of accounts in the organization from AWS Organizations that are affected by the provided event.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable AWS Health to work with AWS Organizations. To do this,
     * call the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAffectedAccountsForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAffectedAccountsForOrganizationRequest#builder()}
     * </p>
     *
     * @param describeAffectedAccountsForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeAffectedAccountsForOrganizationRequest.Builder} to create a request.
     * @return Result of the DescribeAffectedAccountsForOrganization operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedAccountsForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedAccountsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedAccountsForOrganizationResponse describeAffectedAccountsForOrganization(
            Consumer<DescribeAffectedAccountsForOrganizationRequest.Builder> describeAffectedAccountsForOrganizationRequest)
            throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        return describeAffectedAccountsForOrganization(DescribeAffectedAccountsForOrganizationRequest.builder()
                .applyMutation(describeAffectedAccountsForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns a list of accounts in the organization from AWS Organizations that are affected by the provided event.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable AWS Health to work with AWS Organizations. To do this,
     * call the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAffectedAccountsForOrganization(software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedAccountsForOrganizationIterable responses = client.describeAffectedAccountsForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeAffectedAccountsForOrganizationIterable responses = client
     *             .describeAffectedAccountsForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedAccountsForOrganizationIterable responses = client.describeAffectedAccountsForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAffectedAccountsForOrganization(software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAffectedAccountsForOrganizationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedAccountsForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedAccountsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedAccountsForOrganizationIterable describeAffectedAccountsForOrganizationPaginator(
            DescribeAffectedAccountsForOrganizationRequest describeAffectedAccountsForOrganizationRequest)
            throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of accounts in the organization from AWS Organizations that are affected by the provided event.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable AWS Health to work with AWS Organizations. To do this,
     * call the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAffectedAccountsForOrganization(software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedAccountsForOrganizationIterable responses = client.describeAffectedAccountsForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeAffectedAccountsForOrganizationIterable responses = client
     *             .describeAffectedAccountsForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedAccountsForOrganizationIterable responses = client.describeAffectedAccountsForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAffectedAccountsForOrganization(software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAffectedAccountsForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAffectedAccountsForOrganizationRequest#builder()}
     * </p>
     *
     * @param describeAffectedAccountsForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeAffectedAccountsForOrganizationRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedAccountsForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedAccountsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedAccountsForOrganizationIterable describeAffectedAccountsForOrganizationPaginator(
            Consumer<DescribeAffectedAccountsForOrganizationRequest.Builder> describeAffectedAccountsForOrganizationRequest)
            throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        return describeAffectedAccountsForOrganizationPaginator(DescribeAffectedAccountsForOrganizationRequest.builder()
                .applyMutation(describeAffectedAccountsForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns a list of entities that have been affected by the specified events, based on the specified filter
     * criteria. Entities can refer to individual customer resources, groups of customer resources, or any other
     * construct, depending on the AWS service. Events that have impact beyond that of the affected entities, or where
     * the extent of impact is unknown, include at least one entity indicating this.
     * </p>
     * <p>
     * At least one event ARN is required. Results are sorted by the <code>lastUpdatedTime</code> of the entity,
     * starting with the most recent.
     * </p>
     *
     * @param describeAffectedEntitiesRequest
     * @return Result of the DescribeAffectedEntities operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedEntitiesResponse describeAffectedEntities(
            DescribeAffectedEntitiesRequest describeAffectedEntitiesRequest) throws InvalidPaginationTokenException,
            UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of entities that have been affected by the specified events, based on the specified filter
     * criteria. Entities can refer to individual customer resources, groups of customer resources, or any other
     * construct, depending on the AWS service. Events that have impact beyond that of the affected entities, or where
     * the extent of impact is unknown, include at least one entity indicating this.
     * </p>
     * <p>
     * At least one event ARN is required. Results are sorted by the <code>lastUpdatedTime</code> of the entity,
     * starting with the most recent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAffectedEntitiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAffectedEntitiesRequest#builder()}
     * </p>
     *
     * @param describeAffectedEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAffectedEntitiesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAffectedEntities operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedEntitiesResponse describeAffectedEntities(
            Consumer<DescribeAffectedEntitiesRequest.Builder> describeAffectedEntitiesRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        return describeAffectedEntities(DescribeAffectedEntitiesRequest.builder().applyMutation(describeAffectedEntitiesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of entities that have been affected by the specified events, based on the specified filter
     * criteria. Entities can refer to individual customer resources, groups of customer resources, or any other
     * construct, depending on the AWS service. Events that have impact beyond that of the affected entities, or where
     * the extent of impact is unknown, include at least one entity indicating this.
     * </p>
     * <p>
     * At least one event ARN is required. Results are sorted by the <code>lastUpdatedTime</code> of the entity,
     * starting with the most recent.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAffectedEntities(software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesIterable responses = client.describeAffectedEntitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesIterable responses = client
     *             .describeAffectedEntitiesPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesIterable responses = client.describeAffectedEntitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAffectedEntities(software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAffectedEntitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedEntitiesIterable describeAffectedEntitiesPaginator(
            DescribeAffectedEntitiesRequest describeAffectedEntitiesRequest) throws InvalidPaginationTokenException,
            UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of entities that have been affected by the specified events, based on the specified filter
     * criteria. Entities can refer to individual customer resources, groups of customer resources, or any other
     * construct, depending on the AWS service. Events that have impact beyond that of the affected entities, or where
     * the extent of impact is unknown, include at least one entity indicating this.
     * </p>
     * <p>
     * At least one event ARN is required. Results are sorted by the <code>lastUpdatedTime</code> of the entity,
     * starting with the most recent.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAffectedEntities(software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesIterable responses = client.describeAffectedEntitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesIterable responses = client
     *             .describeAffectedEntitiesPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesIterable responses = client.describeAffectedEntitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAffectedEntities(software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAffectedEntitiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAffectedEntitiesRequest#builder()}
     * </p>
     *
     * @param describeAffectedEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAffectedEntitiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedEntitiesIterable describeAffectedEntitiesPaginator(
            Consumer<DescribeAffectedEntitiesRequest.Builder> describeAffectedEntitiesRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        return describeAffectedEntitiesPaginator(DescribeAffectedEntitiesRequest.builder()
                .applyMutation(describeAffectedEntitiesRequest).build());
    }

    /**
     * <p>
     * Returns a list of entities that have been affected by one or more events for one or more accounts in your
     * organization in AWS Organizations, based on the filter criteria. Entities can refer to individual customer
     * resources, groups of customer resources, or any other construct, depending on the AWS service.
     * </p>
     * <p>
     * At least one event ARN and account ID are required. Results are sorted by the <code>lastUpdatedTime</code> of the
     * entity, starting with the most recent.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable AWS Health to work with AWS Organizations. To do this,
     * call the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     *
     * @param describeAffectedEntitiesForOrganizationRequest
     * @return Result of the DescribeAffectedEntitiesForOrganization operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedEntitiesForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntitiesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedEntitiesForOrganizationResponse describeAffectedEntitiesForOrganization(
            DescribeAffectedEntitiesForOrganizationRequest describeAffectedEntitiesForOrganizationRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of entities that have been affected by one or more events for one or more accounts in your
     * organization in AWS Organizations, based on the filter criteria. Entities can refer to individual customer
     * resources, groups of customer resources, or any other construct, depending on the AWS service.
     * </p>
     * <p>
     * At least one event ARN and account ID are required. Results are sorted by the <code>lastUpdatedTime</code> of the
     * entity, starting with the most recent.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable AWS Health to work with AWS Organizations. To do this,
     * call the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAffectedEntitiesForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAffectedEntitiesForOrganizationRequest#builder()}
     * </p>
     *
     * @param describeAffectedEntitiesForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeAffectedEntitiesForOrganizationRequest.Builder} to create a request.
     * @return Result of the DescribeAffectedEntitiesForOrganization operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedEntitiesForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntitiesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedEntitiesForOrganizationResponse describeAffectedEntitiesForOrganization(
            Consumer<DescribeAffectedEntitiesForOrganizationRequest.Builder> describeAffectedEntitiesForOrganizationRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        return describeAffectedEntitiesForOrganization(DescribeAffectedEntitiesForOrganizationRequest.builder()
                .applyMutation(describeAffectedEntitiesForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns a list of entities that have been affected by one or more events for one or more accounts in your
     * organization in AWS Organizations, based on the filter criteria. Entities can refer to individual customer
     * resources, groups of customer resources, or any other construct, depending on the AWS service.
     * </p>
     * <p>
     * At least one event ARN and account ID are required. Results are sorted by the <code>lastUpdatedTime</code> of the
     * entity, starting with the most recent.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable AWS Health to work with AWS Organizations. To do this,
     * call the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAffectedEntitiesForOrganization(software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesForOrganizationIterable responses = client.describeAffectedEntitiesForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesForOrganizationIterable responses = client
     *             .describeAffectedEntitiesForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesForOrganizationIterable responses = client.describeAffectedEntitiesForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAffectedEntitiesForOrganization(software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAffectedEntitiesForOrganizationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedEntitiesForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntitiesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedEntitiesForOrganizationIterable describeAffectedEntitiesForOrganizationPaginator(
            DescribeAffectedEntitiesForOrganizationRequest describeAffectedEntitiesForOrganizationRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of entities that have been affected by one or more events for one or more accounts in your
     * organization in AWS Organizations, based on the filter criteria. Entities can refer to individual customer
     * resources, groups of customer resources, or any other construct, depending on the AWS service.
     * </p>
     * <p>
     * At least one event ARN and account ID are required. Results are sorted by the <code>lastUpdatedTime</code> of the
     * entity, starting with the most recent.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable AWS Health to work with AWS Organizations. To do this,
     * call the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAffectedEntitiesForOrganization(software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesForOrganizationIterable responses = client.describeAffectedEntitiesForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesForOrganizationIterable responses = client
     *             .describeAffectedEntitiesForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesForOrganizationIterable responses = client.describeAffectedEntitiesForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAffectedEntitiesForOrganization(software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAffectedEntitiesForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAffectedEntitiesForOrganizationRequest#builder()}
     * </p>
     *
     * @param describeAffectedEntitiesForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeAffectedEntitiesForOrganizationRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeAffectedEntitiesForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeAffectedEntitiesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAffectedEntitiesForOrganizationIterable describeAffectedEntitiesForOrganizationPaginator(
            Consumer<DescribeAffectedEntitiesForOrganizationRequest.Builder> describeAffectedEntitiesForOrganizationRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        return describeAffectedEntitiesForOrganizationPaginator(DescribeAffectedEntitiesForOrganizationRequest.builder()
                .applyMutation(describeAffectedEntitiesForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns the number of entities that are affected by each of the specified events. If no events are specified, the
     * counts of all affected entities are returned.
     * </p>
     *
     * @return Result of the DescribeEntityAggregates operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEntityAggregates
     * @see #describeEntityAggregates(DescribeEntityAggregatesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEntityAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntityAggregatesResponse describeEntityAggregates() throws AwsServiceException, SdkClientException,
            HealthException {
        return describeEntityAggregates(DescribeEntityAggregatesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the number of entities that are affected by each of the specified events. If no events are specified, the
     * counts of all affected entities are returned.
     * </p>
     *
     * @param describeEntityAggregatesRequest
     * @return Result of the DescribeEntityAggregates operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEntityAggregates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEntityAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntityAggregatesResponse describeEntityAggregates(
            DescribeEntityAggregatesRequest describeEntityAggregatesRequest) throws AwsServiceException, SdkClientException,
            HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of entities that are affected by each of the specified events. If no events are specified, the
     * counts of all affected entities are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntityAggregatesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEntityAggregatesRequest#builder()}
     * </p>
     *
     * @param describeEntityAggregatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEntityAggregatesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEntityAggregates operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEntityAggregates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEntityAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntityAggregatesResponse describeEntityAggregates(
            Consumer<DescribeEntityAggregatesRequest.Builder> describeEntityAggregatesRequest) throws AwsServiceException,
            SdkClientException, HealthException {
        return describeEntityAggregates(DescribeEntityAggregatesRequest.builder().applyMutation(describeEntityAggregatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns the number of events of each event type (issue, scheduled change, and account notification). If no filter
     * is specified, the counts of all events in each category are returned.
     * </p>
     *
     * @param describeEventAggregatesRequest
     * @return Result of the DescribeEventAggregates operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventAggregates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventAggregates" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventAggregatesResponse describeEventAggregates(DescribeEventAggregatesRequest describeEventAggregatesRequest)
            throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of events of each event type (issue, scheduled change, and account notification). If no filter
     * is specified, the counts of all events in each category are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventAggregatesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventAggregatesRequest#builder()}
     * </p>
     *
     * @param describeEventAggregatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventAggregatesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEventAggregates operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventAggregates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventAggregates" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventAggregatesResponse describeEventAggregates(
            Consumer<DescribeEventAggregatesRequest.Builder> describeEventAggregatesRequest)
            throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        return describeEventAggregates(DescribeEventAggregatesRequest.builder().applyMutation(describeEventAggregatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns the number of events of each event type (issue, scheduled change, and account notification). If no filter
     * is specified, the counts of all events in each category are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventAggregates(software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventAggregatesIterable responses = client.describeEventAggregatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeEventAggregatesIterable responses = client
     *             .describeEventAggregatesPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventAggregatesIterable responses = client.describeEventAggregatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventAggregates(software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventAggregatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventAggregates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventAggregates" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventAggregatesIterable describeEventAggregatesPaginator(
            DescribeEventAggregatesRequest describeEventAggregatesRequest) throws InvalidPaginationTokenException,
            AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of events of each event type (issue, scheduled change, and account notification). If no filter
     * is specified, the counts of all events in each category are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventAggregates(software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventAggregatesIterable responses = client.describeEventAggregatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeEventAggregatesIterable responses = client
     *             .describeEventAggregatesPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventAggregatesIterable responses = client.describeEventAggregatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventAggregates(software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventAggregatesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventAggregatesRequest#builder()}
     * </p>
     *
     * @param describeEventAggregatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventAggregatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventAggregates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventAggregates" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventAggregatesIterable describeEventAggregatesPaginator(
            Consumer<DescribeEventAggregatesRequest.Builder> describeEventAggregatesRequest)
            throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        return describeEventAggregatesPaginator(DescribeEventAggregatesRequest.builder()
                .applyMutation(describeEventAggregatesRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about one or more specified events. Information includes standard event data
     * (region, service, and so on, as returned by <a>DescribeEvents</a>), a detailed event description, and possible
     * additional metadata that depends upon the nature of the event. Affected entities are not included; to retrieve
     * those, use the <a>DescribeAffectedEntities</a> operation.
     * </p>
     * <p>
     * If a specified event cannot be retrieved, an error message is returned for that event.
     * </p>
     *
     * @param describeEventDetailsRequest
     * @return Result of the DescribeEventDetails operation returned by the service.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetails" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventDetailsResponse describeEventDetails(DescribeEventDetailsRequest describeEventDetailsRequest)
            throws UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about one or more specified events. Information includes standard event data
     * (region, service, and so on, as returned by <a>DescribeEvents</a>), a detailed event description, and possible
     * additional metadata that depends upon the nature of the event. Affected entities are not included; to retrieve
     * those, use the <a>DescribeAffectedEntities</a> operation.
     * </p>
     * <p>
     * If a specified event cannot be retrieved, an error message is returned for that event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventDetailsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEventDetailsRequest#builder()}
     * </p>
     *
     * @param describeEventDetailsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventDetailsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEventDetails operation returned by the service.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetails" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventDetailsResponse describeEventDetails(
            Consumer<DescribeEventDetailsRequest.Builder> describeEventDetailsRequest) throws UnsupportedLocaleException,
            AwsServiceException, SdkClientException, HealthException {
        return describeEventDetails(DescribeEventDetailsRequest.builder().applyMutation(describeEventDetailsRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about one or more specified events for one or more accounts in your organization.
     * Information includes standard event data (Region, service, and so on, as returned by
     * <a>DescribeEventsForOrganization</a>, a detailed event description, and possible additional metadata that depends
     * upon the nature of the event. Affected entities are not included; to retrieve those, use the
     * <a>DescribeAffectedEntitiesForOrganization</a> operation.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable AWS Health to work with AWS Organizations. To do this,
     * call the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     *
     * @param describeEventDetailsForOrganizationRequest
     * @return Result of the DescribeEventDetailsForOrganization operation returned by the service.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventDetailsForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetailsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventDetailsForOrganizationResponse describeEventDetailsForOrganization(
            DescribeEventDetailsForOrganizationRequest describeEventDetailsForOrganizationRequest)
            throws UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about one or more specified events for one or more accounts in your organization.
     * Information includes standard event data (Region, service, and so on, as returned by
     * <a>DescribeEventsForOrganization</a>, a detailed event description, and possible additional metadata that depends
     * upon the nature of the event. Affected entities are not included; to retrieve those, use the
     * <a>DescribeAffectedEntitiesForOrganization</a> operation.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable AWS Health to work with AWS Organizations. To do this,
     * call the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventDetailsForOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEventDetailsForOrganizationRequest#builder()}
     * </p>
     *
     * @param describeEventDetailsForOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventDetailsForOrganizationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEventDetailsForOrganization operation returned by the service.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventDetailsForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetailsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventDetailsForOrganizationResponse describeEventDetailsForOrganization(
            Consumer<DescribeEventDetailsForOrganizationRequest.Builder> describeEventDetailsForOrganizationRequest)
            throws UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        return describeEventDetailsForOrganization(DescribeEventDetailsForOrganizationRequest.builder()
                .applyMutation(describeEventDetailsForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns the event types that meet the specified filter criteria. If no filter criteria are specified, all event
     * types are returned, in no particular order.
     * </p>
     *
     * @return Result of the DescribeEventTypes operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventTypes
     * @see #describeEventTypes(DescribeEventTypesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventTypesResponse describeEventTypes() throws InvalidPaginationTokenException, UnsupportedLocaleException,
            AwsServiceException, SdkClientException, HealthException {
        return describeEventTypes(DescribeEventTypesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the event types that meet the specified filter criteria. If no filter criteria are specified, all event
     * types are returned, in no particular order.
     * </p>
     *
     * @param describeEventTypesRequest
     * @return Result of the DescribeEventTypes operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventTypesResponse describeEventTypes(DescribeEventTypesRequest describeEventTypesRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the event types that meet the specified filter criteria. If no filter criteria are specified, all event
     * types are returned, in no particular order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventTypesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEventTypesRequest#builder()}
     * </p>
     *
     * @param describeEventTypesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventTypesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEventTypes operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventTypesResponse describeEventTypes(Consumer<DescribeEventTypesRequest.Builder> describeEventTypesRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        return describeEventTypes(DescribeEventTypesRequest.builder().applyMutation(describeEventTypesRequest).build());
    }

    /**
     * <p>
     * Returns the event types that meet the specified filter criteria. If no filter criteria are specified, all event
     * types are returned, in no particular order.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventTypes(software.amazon.awssdk.services.health.model.DescribeEventTypesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable responses = client.describeEventTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable responses = client
     *             .describeEventTypesPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeEventTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable responses = client.describeEventTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventTypes(software.amazon.awssdk.services.health.model.DescribeEventTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventTypes
     * @see #describeEventTypesPaginator(DescribeEventTypesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventTypesIterable describeEventTypesPaginator() throws InvalidPaginationTokenException,
            UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        return describeEventTypesPaginator(DescribeEventTypesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the event types that meet the specified filter criteria. If no filter criteria are specified, all event
     * types are returned, in no particular order.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventTypes(software.amazon.awssdk.services.health.model.DescribeEventTypesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable responses = client.describeEventTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable responses = client
     *             .describeEventTypesPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeEventTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable responses = client.describeEventTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventTypes(software.amazon.awssdk.services.health.model.DescribeEventTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventTypesIterable describeEventTypesPaginator(DescribeEventTypesRequest describeEventTypesRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the event types that meet the specified filter criteria. If no filter criteria are specified, all event
     * types are returned, in no particular order.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventTypes(software.amazon.awssdk.services.health.model.DescribeEventTypesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable responses = client.describeEventTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable responses = client
     *             .describeEventTypesPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeEventTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable responses = client.describeEventTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventTypes(software.amazon.awssdk.services.health.model.DescribeEventTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventTypesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEventTypesRequest#builder()}
     * </p>
     *
     * @param describeEventTypesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventTypesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventTypesIterable describeEventTypesPaginator(
            Consumer<DescribeEventTypesRequest.Builder> describeEventTypesRequest) throws InvalidPaginationTokenException,
            UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        return describeEventTypesPaginator(DescribeEventTypesRequest.builder().applyMutation(describeEventTypesRequest).build());
    }

    /**
     * <p>
     * Returns information about events that meet the specified filter criteria. Events are returned in a summary form
     * and do not include the detailed description, any additional metadata that depends on the event type, or any
     * affected resources. To retrieve that information, use the <a>DescribeEventDetails</a> and
     * <a>DescribeAffectedEntities</a> operations.
     * </p>
     * <p>
     * If no filter criteria are specified, all events are returned. Results are sorted by <code>lastModifiedTime</code>
     * , starting with the most recent.
     * </p>
     *
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEvents
     * @see #describeEvents(DescribeEventsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents() throws InvalidPaginationTokenException, UnsupportedLocaleException,
            AwsServiceException, SdkClientException, HealthException {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about events that meet the specified filter criteria. Events are returned in a summary form
     * and do not include the detailed description, any additional metadata that depends on the event type, or any
     * affected resources. To retrieve that information, use the <a>DescribeEventDetails</a> and
     * <a>DescribeAffectedEntities</a> operations.
     * </p>
     * <p>
     * If no filter criteria are specified, all events are returned. Results are sorted by <code>lastModifiedTime</code>
     * , starting with the most recent.
     * </p>
     *
     * @param describeEventsRequest
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about events that meet the specified filter criteria. Events are returned in a summary form
     * and do not include the detailed description, any additional metadata that depends on the event type, or any
     * affected resources. To retrieve that information, use the <a>DescribeEventDetails</a> and
     * <a>DescribeAffectedEntities</a> operations.
     * </p>
     * <p>
     * If no filter criteria are specified, all events are returned. Results are sorted by <code>lastModifiedTime</code>
     * , starting with the most recent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsRequest.Builder} to create a request.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about events that meet the specified filter criteria. Events are returned in a summary form
     * and do not include the detailed description, any additional metadata that depends on the event type, or any
     * affected resources. To retrieve that information, use the <a>DescribeEventDetails</a> and
     * <a>DescribeAffectedEntities</a> operations.
     * </p>
     * <p>
     * If no filter criteria are specified, all events are returned. Results are sorted by <code>lastModifiedTime</code>
     * , starting with the most recent.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.health.model.DescribeEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.health.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEvents
     * @see #describeEventsPaginator(DescribeEventsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator() throws InvalidPaginationTokenException, UnsupportedLocaleException,
            AwsServiceException, SdkClientException, HealthException {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about events that meet the specified filter criteria. Events are returned in a summary form
     * and do not include the detailed description, any additional metadata that depends on the event type, or any
     * affected resources. To retrieve that information, use the <a>DescribeEventDetails</a> and
     * <a>DescribeAffectedEntities</a> operations.
     * </p>
     * <p>
     * If no filter criteria are specified, all events are returned. Results are sorted by <code>lastModifiedTime</code>
     * , starting with the most recent.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.health.model.DescribeEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.health.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about events that meet the specified filter criteria. Events are returned in a summary form
     * and do not include the detailed description, any additional metadata that depends on the event type, or any
     * affected resources. To retrieve that information, use the <a>DescribeEventDetails</a> and
     * <a>DescribeAffectedEntities</a> operations.
     * </p>
     * <p>
     * If no filter criteria are specified, all events are returned. Results are sorted by <code>lastModifiedTime</code>
     * , starting with the most recent.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.health.model.DescribeEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.health.model.DescribeEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about events across your organization in AWS Organizations, meeting the specified filter
     * criteria. Events are returned in a summary form and do not include the accounts impacted, detailed description,
     * any additional metadata that depends on the event type, or any affected resources. To retrieve that information,
     * use the <a>DescribeAffectedAccountsForOrganization</a>, <a>DescribeEventDetailsForOrganization</a>, and
     * <a>DescribeAffectedEntitiesForOrganization</a> operations.
     * </p>
     * <p>
     * If no filter criteria are specified, all events across your organization are returned. Results are sorted by
     * <code>lastModifiedTime</code>, starting with the most recent.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable Health to work with AWS Organizations. To do this, call
     * the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     *
     * @param describeEventsForOrganizationRequest
     * @return Result of the DescribeEventsForOrganization operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventsForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsForOrganizationResponse describeEventsForOrganization(
            DescribeEventsForOrganizationRequest describeEventsForOrganizationRequest) throws InvalidPaginationTokenException,
            UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about events across your organization in AWS Organizations, meeting the specified filter
     * criteria. Events are returned in a summary form and do not include the accounts impacted, detailed description,
     * any additional metadata that depends on the event type, or any affected resources. To retrieve that information,
     * use the <a>DescribeAffectedAccountsForOrganization</a>, <a>DescribeEventDetailsForOrganization</a>, and
     * <a>DescribeAffectedEntitiesForOrganization</a> operations.
     * </p>
     * <p>
     * If no filter criteria are specified, all events across your organization are returned. Results are sorted by
     * <code>lastModifiedTime</code>, starting with the most recent.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable Health to work with AWS Organizations. To do this, call
     * the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsForOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEventsForOrganizationRequest#builder()}
     * </p>
     *
     * @param describeEventsForOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsForOrganizationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEventsForOrganization operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventsForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsForOrganizationResponse describeEventsForOrganization(
            Consumer<DescribeEventsForOrganizationRequest.Builder> describeEventsForOrganizationRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        return describeEventsForOrganization(DescribeEventsForOrganizationRequest.builder()
                .applyMutation(describeEventsForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns information about events across your organization in AWS Organizations, meeting the specified filter
     * criteria. Events are returned in a summary form and do not include the accounts impacted, detailed description,
     * any additional metadata that depends on the event type, or any affected resources. To retrieve that information,
     * use the <a>DescribeAffectedAccountsForOrganization</a>, <a>DescribeEventDetailsForOrganization</a>, and
     * <a>DescribeAffectedEntitiesForOrganization</a> operations.
     * </p>
     * <p>
     * If no filter criteria are specified, all events across your organization are returned. Results are sorted by
     * <code>lastModifiedTime</code>, starting with the most recent.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable Health to work with AWS Organizations. To do this, call
     * the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventsForOrganization(software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventsForOrganizationIterable responses = client.describeEventsForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeEventsForOrganizationIterable responses = client
     *             .describeEventsForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventsForOrganizationIterable responses = client.describeEventsForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventsForOrganization(software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventsForOrganizationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventsForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsForOrganizationIterable describeEventsForOrganizationPaginator(
            DescribeEventsForOrganizationRequest describeEventsForOrganizationRequest) throws InvalidPaginationTokenException,
            UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about events across your organization in AWS Organizations, meeting the specified filter
     * criteria. Events are returned in a summary form and do not include the accounts impacted, detailed description,
     * any additional metadata that depends on the event type, or any affected resources. To retrieve that information,
     * use the <a>DescribeAffectedAccountsForOrganization</a>, <a>DescribeEventDetailsForOrganization</a>, and
     * <a>DescribeAffectedEntitiesForOrganization</a> operations.
     * </p>
     * <p>
     * If no filter criteria are specified, all events across your organization are returned. Results are sorted by
     * <code>lastModifiedTime</code>, starting with the most recent.
     * </p>
     * <p>
     * Before you can call this operation, you must first enable Health to work with AWS Organizations. To do this, call
     * the <a>EnableHealthServiceAccessForOrganization</a> operation from your organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventsForOrganization(software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventsForOrganizationIterable responses = client.describeEventsForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.health.paginators.DescribeEventsForOrganizationIterable responses = client
     *             .describeEventsForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.health.paginators.DescribeEventsForOrganizationIterable responses = client.describeEventsForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventsForOrganization(software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsForOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEventsForOrganizationRequest#builder()}
     * </p>
     *
     * @param describeEventsForOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsForOrganizationRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The specified pagination token (<code>nextToken</code>) is not valid.
     * @throws UnsupportedLocaleException
     *         The specified locale is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeEventsForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsForOrganizationIterable describeEventsForOrganizationPaginator(
            Consumer<DescribeEventsForOrganizationRequest.Builder> describeEventsForOrganizationRequest)
            throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException,
            HealthException {
        return describeEventsForOrganizationPaginator(DescribeEventsForOrganizationRequest.builder()
                .applyMutation(describeEventsForOrganizationRequest).build());
    }

    /**
     * <p>
     * This operation provides status information on enabling or disabling AWS Health to work with your organization. To
     * call this operation, you must sign in as an IAM user, assume an IAM role, or sign in as the root user (not
     * recommended) in the organization's master account.
     * </p>
     *
     * @param describeHealthServiceStatusForOrganizationRequest
     * @return Result of the DescribeHealthServiceStatusForOrganization operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeHealthServiceStatusForOrganization
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeHealthServiceStatusForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHealthServiceStatusForOrganizationResponse describeHealthServiceStatusForOrganization(
            DescribeHealthServiceStatusForOrganizationRequest describeHealthServiceStatusForOrganizationRequest)
            throws AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation provides status information on enabling or disabling AWS Health to work with your organization. To
     * call this operation, you must sign in as an IAM user, assume an IAM role, or sign in as the root user (not
     * recommended) in the organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeHealthServiceStatusForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeHealthServiceStatusForOrganizationRequest#builder()}
     * </p>
     *
     * @param describeHealthServiceStatusForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeHealthServiceStatusForOrganizationRequest.Builder} to create a request.
     * @return Result of the DescribeHealthServiceStatusForOrganization operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DescribeHealthServiceStatusForOrganization
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeHealthServiceStatusForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHealthServiceStatusForOrganizationResponse describeHealthServiceStatusForOrganization(
            Consumer<DescribeHealthServiceStatusForOrganizationRequest.Builder> describeHealthServiceStatusForOrganizationRequest)
            throws AwsServiceException, SdkClientException, HealthException {
        return describeHealthServiceStatusForOrganization(DescribeHealthServiceStatusForOrganizationRequest.builder()
                .applyMutation(describeHealthServiceStatusForOrganizationRequest).build());
    }

    /**
     * <p>
     * Calling this operation disables Health from working with AWS Organizations. This does not remove the Service
     * Linked Role (SLR) from the the master account in your organization. Use the IAM console, API, or AWS CLI to
     * remove the SLR if desired. To call this operation, you must sign in as an IAM user, assume an IAM role, or sign
     * in as the root user (not recommended) in the organization's master account.
     * </p>
     *
     * @param disableHealthServiceAccessForOrganizationRequest
     * @return Result of the DisableHealthServiceAccessForOrganization operation returned by the service.
     * @throws ConcurrentModificationException
     *         <a>EnableHealthServiceAccessForOrganization</a> is already in progress. Wait for the action to complete
     *         before trying again. To get the current status, use the <a>DescribeHealthServiceStatusForOrganization</a>
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DisableHealthServiceAccessForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DisableHealthServiceAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableHealthServiceAccessForOrganizationResponse disableHealthServiceAccessForOrganization(
            DisableHealthServiceAccessForOrganizationRequest disableHealthServiceAccessForOrganizationRequest)
            throws ConcurrentModificationException, AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Calling this operation disables Health from working with AWS Organizations. This does not remove the Service
     * Linked Role (SLR) from the the master account in your organization. Use the IAM console, API, or AWS CLI to
     * remove the SLR if desired. To call this operation, you must sign in as an IAM user, assume an IAM role, or sign
     * in as the root user (not recommended) in the organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisableHealthServiceAccessForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link DisableHealthServiceAccessForOrganizationRequest#builder()}
     * </p>
     *
     * @param disableHealthServiceAccessForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisableHealthServiceAccessForOrganizationRequest.Builder} to create a request.
     * @return Result of the DisableHealthServiceAccessForOrganization operation returned by the service.
     * @throws ConcurrentModificationException
     *         <a>EnableHealthServiceAccessForOrganization</a> is already in progress. Wait for the action to complete
     *         before trying again. To get the current status, use the <a>DescribeHealthServiceStatusForOrganization</a>
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.DisableHealthServiceAccessForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DisableHealthServiceAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableHealthServiceAccessForOrganizationResponse disableHealthServiceAccessForOrganization(
            Consumer<DisableHealthServiceAccessForOrganizationRequest.Builder> disableHealthServiceAccessForOrganizationRequest)
            throws ConcurrentModificationException, AwsServiceException, SdkClientException, HealthException {
        return disableHealthServiceAccessForOrganization(DisableHealthServiceAccessForOrganizationRequest.builder()
                .applyMutation(disableHealthServiceAccessForOrganizationRequest).build());
    }

    /**
     * <p>
     * Calling this operation enables AWS Health to work with AWS Organizations. This applies a Service Linked Role
     * (SLR) to the master account in the organization. To learn more about the steps in this process, visit enabling
     * service access for AWS Health in AWS Organizations. To call this operation, you must sign in as an IAM user,
     * assume an IAM role, or sign in as the root user (not recommended) in the organization's master account.
     * </p>
     *
     * @param enableHealthServiceAccessForOrganizationRequest
     * @return Result of the EnableHealthServiceAccessForOrganization operation returned by the service.
     * @throws ConcurrentModificationException
     *         <a>EnableHealthServiceAccessForOrganization</a> is already in progress. Wait for the action to complete
     *         before trying again. To get the current status, use the <a>DescribeHealthServiceStatusForOrganization</a>
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.EnableHealthServiceAccessForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EnableHealthServiceAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableHealthServiceAccessForOrganizationResponse enableHealthServiceAccessForOrganization(
            EnableHealthServiceAccessForOrganizationRequest enableHealthServiceAccessForOrganizationRequest)
            throws ConcurrentModificationException, AwsServiceException, SdkClientException, HealthException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Calling this operation enables AWS Health to work with AWS Organizations. This applies a Service Linked Role
     * (SLR) to the master account in the organization. To learn more about the steps in this process, visit enabling
     * service access for AWS Health in AWS Organizations. To call this operation, you must sign in as an IAM user,
     * assume an IAM role, or sign in as the root user (not recommended) in the organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link EnableHealthServiceAccessForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link EnableHealthServiceAccessForOrganizationRequest#builder()}
     * </p>
     *
     * @param enableHealthServiceAccessForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link EnableHealthServiceAccessForOrganizationRequest.Builder} to create a request.
     * @return Result of the EnableHealthServiceAccessForOrganization operation returned by the service.
     * @throws ConcurrentModificationException
     *         <a>EnableHealthServiceAccessForOrganization</a> is already in progress. Wait for the action to complete
     *         before trying again. To get the current status, use the <a>DescribeHealthServiceStatusForOrganization</a>
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws HealthException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample HealthClient.EnableHealthServiceAccessForOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/EnableHealthServiceAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableHealthServiceAccessForOrganizationResponse enableHealthServiceAccessForOrganization(
            Consumer<EnableHealthServiceAccessForOrganizationRequest.Builder> enableHealthServiceAccessForOrganizationRequest)
            throws ConcurrentModificationException, AwsServiceException, SdkClientException, HealthException {
        return enableHealthServiceAccessForOrganization(EnableHealthServiceAccessForOrganizationRequest.builder()
                .applyMutation(enableHealthServiceAccessForOrganizationRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("health");
    }
}
