/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAffectedAccountsForOrganizationResponse extends HealthResponse
        implements
        ToCopyableBuilder<DescribeAffectedAccountsForOrganizationResponse.Builder, DescribeAffectedAccountsForOrganizationResponse> {
    private static final SdkField<List<String>> AFFECTED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAffectedAccountsForOrganizationResponse::affectedAccounts))
            .setter(setter(Builder::affectedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("affectedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAffectedAccountsForOrganizationResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFECTED_ACCOUNTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> affectedAccounts;

    private final String nextToken;

    private DescribeAffectedAccountsForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.affectedAccounts = builder.affectedAccounts;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AffectedAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAffectedAccounts() {
        return affectedAccounts != null && !(affectedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON set of elements of the affected accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAffectedAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A JSON set of elements of the affected accounts.
     */
    public List<String> affectedAccounts() {
        return affectedAccounts;
    }

    /**
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next batch of results, reissue the search request
     * and include the returned token. When all results have been returned, the response does not contain a pagination
     * token value.
     * </p>
     * 
     * @return If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
     *         results, reissue the search request and include the returned token. When all results have been returned,
     *         the response does not contain a pagination token value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(affectedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAffectedAccountsForOrganizationResponse)) {
            return false;
        }
        DescribeAffectedAccountsForOrganizationResponse other = (DescribeAffectedAccountsForOrganizationResponse) obj;
        return Objects.equals(affectedAccounts(), other.affectedAccounts()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAffectedAccountsForOrganizationResponse").add("AffectedAccounts", affectedAccounts())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "affectedAccounts":
            return Optional.ofNullable(clazz.cast(affectedAccounts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAffectedAccountsForOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeAffectedAccountsForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAffectedAccountsForOrganizationResponse> {
        /**
         * <p>
         * A JSON set of elements of the affected accounts.
         * </p>
         * 
         * @param affectedAccounts
         *        A JSON set of elements of the affected accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedAccounts(Collection<String> affectedAccounts);

        /**
         * <p>
         * A JSON set of elements of the affected accounts.
         * </p>
         * 
         * @param affectedAccounts
         *        A JSON set of elements of the affected accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedAccounts(String... affectedAccounts);

        /**
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private List<String> affectedAccounts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAffectedAccountsForOrganizationResponse model) {
            super(model);
            affectedAccounts(model.affectedAccounts);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAffectedAccounts() {
            return affectedAccounts;
        }

        @Override
        public final Builder affectedAccounts(Collection<String> affectedAccounts) {
            this.affectedAccounts = _affectedAccountsListCopier.copy(affectedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder affectedAccounts(String... affectedAccounts) {
            affectedAccounts(Arrays.asList(affectedAccounts));
            return this;
        }

        public final void setAffectedAccounts(Collection<String> affectedAccounts) {
            this.affectedAccounts = _affectedAccountsListCopier.copy(affectedAccounts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAffectedAccountsForOrganizationResponse build() {
            return new DescribeAffectedAccountsForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
