/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAffectedEntitiesForOrganizationRequest extends HealthRequest implements
        ToCopyableBuilder<DescribeAffectedEntitiesForOrganizationRequest.Builder, DescribeAffectedEntitiesForOrganizationRequest> {
    private static final SdkField<List<EventAccountFilter>> ORGANIZATION_ENTITY_FILTERS_FIELD = SdkField
            .<List<EventAccountFilter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAffectedEntitiesForOrganizationRequest::organizationEntityFilters))
            .setter(setter(Builder::organizationEntityFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationEntityFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventAccountFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventAccountFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAffectedEntitiesForOrganizationRequest::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAffectedEntitiesForOrganizationRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeAffectedEntitiesForOrganizationRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_ENTITY_FILTERS_FIELD, LOCALE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<EventAccountFilter> organizationEntityFilters;

    private final String locale;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeAffectedEntitiesForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.organizationEntityFilters = builder.organizationEntityFilters;
        this.locale = builder.locale;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the OrganizationEntityFilters property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasOrganizationEntityFilters() {
        return organizationEntityFilters != null && !(organizationEntityFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrganizationEntityFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
     */
    public List<EventAccountFilter> organizationEntityFilters() {
        return organizationEntityFilters;
    }

    /**
     * <p>
     * The locale (language) to return information in. English (en) is the default and the only supported value at this
     * time.
     * </p>
     * 
     * @return The locale (language) to return information in. English (en) is the default and the only supported value
     *         at this time.
     */
    public String locale() {
        return locale;
    }

    /**
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next batch of results, reissue the search request
     * and include the returned token. When all results have been returned, the response does not contain a pagination
     * token value.
     * </p>
     * 
     * @return If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
     *         results, reissue the search request and include the returned token. When all results have been returned,
     *         the response does not contain a pagination token value.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return in one batch, between 10 and 100, inclusive.
     * </p>
     * 
     * @return The maximum number of items to return in one batch, between 10 and 100, inclusive.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationEntityFilters());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAffectedEntitiesForOrganizationRequest)) {
            return false;
        }
        DescribeAffectedEntitiesForOrganizationRequest other = (DescribeAffectedEntitiesForOrganizationRequest) obj;
        return Objects.equals(organizationEntityFilters(), other.organizationEntityFilters())
                && Objects.equals(locale(), other.locale()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAffectedEntitiesForOrganizationRequest")
                .add("OrganizationEntityFilters", organizationEntityFilters()).add("Locale", locale())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "organizationEntityFilters":
            return Optional.ofNullable(clazz.cast(organizationEntityFilters()));
        case "locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAffectedEntitiesForOrganizationRequest, T> g) {
        return obj -> g.apply((DescribeAffectedEntitiesForOrganizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAffectedEntitiesForOrganizationRequest> {
        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
         * </p>
         * 
         * @param organizationEntityFilters
         *        A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationEntityFilters(Collection<EventAccountFilter> organizationEntityFilters);

        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
         * </p>
         * 
         * @param organizationEntityFilters
         *        A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationEntityFilters(EventAccountFilter... organizationEntityFilters);

        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventAccountFilter>.Builder} avoiding the
         * need to create one manually via {@link List<EventAccountFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventAccountFilter>.Builder#build()} is called immediately
         * and its result is passed to {@link #organizationEntityFilters(List<EventAccountFilter>)}.
         * 
         * @param organizationEntityFilters
         *        a consumer that will call methods on {@link List<EventAccountFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationEntityFilters(List<EventAccountFilter>)
         */
        Builder organizationEntityFilters(Consumer<EventAccountFilter.Builder>... organizationEntityFilters);

        /**
         * <p>
         * The locale (language) to return information in. English (en) is the default and the only supported value at
         * this time.
         * </p>
         * 
         * @param locale
         *        The locale (language) to return information in. English (en) is the default and the only supported
         *        value at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return in one batch, between 10 and 100, inclusive.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return in one batch, between 10 and 100, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HealthRequest.BuilderImpl implements Builder {
        private List<EventAccountFilter> organizationEntityFilters = DefaultSdkAutoConstructList.getInstance();

        private String locale;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAffectedEntitiesForOrganizationRequest model) {
            super(model);
            organizationEntityFilters(model.organizationEntityFilters);
            locale(model.locale);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<EventAccountFilter.Builder> getOrganizationEntityFilters() {
            return organizationEntityFilters != null ? organizationEntityFilters.stream().map(EventAccountFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationEntityFilters(Collection<EventAccountFilter> organizationEntityFilters) {
            this.organizationEntityFilters = OrganizationEntityFiltersListCopier.copy(organizationEntityFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityFilters(EventAccountFilter... organizationEntityFilters) {
            organizationEntityFilters(Arrays.asList(organizationEntityFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityFilters(Consumer<EventAccountFilter.Builder>... organizationEntityFilters) {
            organizationEntityFilters(Stream.of(organizationEntityFilters)
                    .map(c -> EventAccountFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationEntityFilters(Collection<EventAccountFilter.BuilderImpl> organizationEntityFilters) {
            this.organizationEntityFilters = OrganizationEntityFiltersListCopier.copyFromBuilder(organizationEntityFilters);
        }

        public final String getLocale() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAffectedEntitiesForOrganizationRequest build() {
            return new DescribeAffectedEntitiesForOrganizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
