/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of events of each issue type. Returned by the <a>DescribeEventAggregates</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventAggregate implements SdkPojo, Serializable, ToCopyableBuilder<EventAggregate.Builder, EventAggregate> {
    private static final SdkField<String> AGGREGATE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventAggregate::aggregateValue)).setter(setter(Builder::aggregateValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateValue").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EventAggregate::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATE_VALUE_FIELD,
            COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String aggregateValue;

    private final Integer count;

    private EventAggregate(BuilderImpl builder) {
        this.aggregateValue = builder.aggregateValue;
        this.count = builder.count;
    }

    /**
     * <p>
     * The issue type for the associated count.
     * </p>
     * 
     * @return The issue type for the associated count.
     */
    public String aggregateValue() {
        return aggregateValue;
    }

    /**
     * <p>
     * The number of events of the associated issue type.
     * </p>
     * 
     * @return The number of events of the associated issue type.
     */
    public Integer count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregateValue());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventAggregate)) {
            return false;
        }
        EventAggregate other = (EventAggregate) obj;
        return Objects.equals(aggregateValue(), other.aggregateValue()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventAggregate").add("AggregateValue", aggregateValue()).add("Count", count()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregateValue":
            return Optional.ofNullable(clazz.cast(aggregateValue()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventAggregate, T> g) {
        return obj -> g.apply((EventAggregate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventAggregate> {
        /**
         * <p>
         * The issue type for the associated count.
         * </p>
         * 
         * @param aggregateValue
         *        The issue type for the associated count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateValue(String aggregateValue);

        /**
         * <p>
         * The number of events of the associated issue type.
         * </p>
         * 
         * @param count
         *        The number of events of the associated issue type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);
    }

    static final class BuilderImpl implements Builder {
        private String aggregateValue;

        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(EventAggregate model) {
            aggregateValue(model.aggregateValue);
            count(model.count);
        }

        public final String getAggregateValue() {
            return aggregateValue;
        }

        @Override
        public final Builder aggregateValue(String aggregateValue) {
            this.aggregateValue = aggregateValue;
            return this;
        }

        public final void setAggregateValue(String aggregateValue) {
            this.aggregateValue = aggregateValue;
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public EventAggregate build() {
            return new EventAggregate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
