/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EventArnsListCopier;
import software.amazon.awssdk.services.health.model.HealthRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEntityAggregatesRequest
extends HealthRequest
implements ToCopyableBuilder<Builder, DescribeEntityAggregatesRequest> {
    private static final SdkField<List<String>> EVENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventArns").getter(DescribeEntityAggregatesRequest.getter(DescribeEntityAggregatesRequest::eventArns)).setter(DescribeEntityAggregatesRequest.setter(Builder::eventArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARNS_FIELD));
    private final List<String> eventArns;

    private DescribeEntityAggregatesRequest(BuilderImpl builder) {
        super(builder);
        this.eventArns = builder.eventArns;
    }

    public boolean hasEventArns() {
        return this.eventArns != null && !(this.eventArns instanceof SdkAutoConstructList);
    }

    public List<String> eventArns() {
        return this.eventArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventArns() ? this.eventArns() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityAggregatesRequest)) {
            return false;
        }
        DescribeEntityAggregatesRequest other = (DescribeEntityAggregatesRequest)((Object)obj);
        return this.hasEventArns() == other.hasEventArns() && Objects.equals(this.eventArns(), other.eventArns());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEntityAggregatesRequest").add("EventArns", this.hasEventArns() ? this.eventArns() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArns": {
                return Optional.ofNullable(clazz.cast(this.eventArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityAggregatesRequest, T> g) {
        return obj -> g.apply((DescribeEntityAggregatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthRequest.BuilderImpl
    implements Builder {
        private List<String> eventArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityAggregatesRequest model) {
            super(model);
            this.eventArns(model.eventArns);
        }

        public final Collection<String> getEventArns() {
            if (this.eventArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventArns;
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = EventArnsListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = EventArnsListCopier.copy(eventArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEntityAggregatesRequest build() {
            return new DescribeEntityAggregatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HealthRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEntityAggregatesRequest> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

