/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.DateTimeRange;
import software.amazon.awssdk.services.health.model.EntityStatusCode;
import software.amazon.awssdk.services.health.model._dateTimeRangeListCopier;
import software.amazon.awssdk.services.health.model._entityArnListCopier;
import software.amazon.awssdk.services.health.model._entityStatusCodeListCopier;
import software.amazon.awssdk.services.health.model._entityValueListCopier;
import software.amazon.awssdk.services.health.model._eventArnListCopier;
import software.amazon.awssdk.services.health.model._tagFilterCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityFilter> {
    private static final SdkField<List<String>> EVENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventArns").getter(EntityFilter.getter(EntityFilter::eventArns)).setter(EntityFilter.setter(Builder::eventArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENTITY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entityArns").getter(EntityFilter.getter(EntityFilter::entityArns)).setter(EntityFilter.setter(Builder::entityArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENTITY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entityValues").getter(EntityFilter.getter(EntityFilter::entityValues)).setter(EntityFilter.setter(Builder::entityValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DateTimeRange>> LAST_UPDATED_TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lastUpdatedTimes").getter(EntityFilter.getter(EntityFilter::lastUpdatedTimes)).setter(EntityFilter.setter(Builder::lastUpdatedTimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DateTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, String>>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(EntityFilter.getter(EntityFilter::tags)).setter(EntityFilter.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATUS_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusCodes").getter(EntityFilter.getter(EntityFilter::statusCodesAsStrings)).setter(EntityFilter.setter(Builder::statusCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARNS_FIELD, ENTITY_ARNS_FIELD, ENTITY_VALUES_FIELD, LAST_UPDATED_TIMES_FIELD, TAGS_FIELD, STATUS_CODES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> eventArns;
    private final List<String> entityArns;
    private final List<String> entityValues;
    private final List<DateTimeRange> lastUpdatedTimes;
    private final List<Map<String, String>> tags;
    private final List<String> statusCodes;

    private EntityFilter(BuilderImpl builder) {
        this.eventArns = builder.eventArns;
        this.entityArns = builder.entityArns;
        this.entityValues = builder.entityValues;
        this.lastUpdatedTimes = builder.lastUpdatedTimes;
        this.tags = builder.tags;
        this.statusCodes = builder.statusCodes;
    }

    public final boolean hasEventArns() {
        return this.eventArns != null && !(this.eventArns instanceof SdkAutoConstructList);
    }

    public final List<String> eventArns() {
        return this.eventArns;
    }

    public final boolean hasEntityArns() {
        return this.entityArns != null && !(this.entityArns instanceof SdkAutoConstructList);
    }

    public final List<String> entityArns() {
        return this.entityArns;
    }

    public final boolean hasEntityValues() {
        return this.entityValues != null && !(this.entityValues instanceof SdkAutoConstructList);
    }

    public final List<String> entityValues() {
        return this.entityValues;
    }

    public final boolean hasLastUpdatedTimes() {
        return this.lastUpdatedTimes != null && !(this.lastUpdatedTimes instanceof SdkAutoConstructList);
    }

    public final List<DateTimeRange> lastUpdatedTimes() {
        return this.lastUpdatedTimes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Map<String, String>> tags() {
        return this.tags;
    }

    public final List<EntityStatusCode> statusCodes() {
        return _entityStatusCodeListCopier.copyStringToEnum(this.statusCodes);
    }

    public final boolean hasStatusCodes() {
        return this.statusCodes != null && !(this.statusCodes instanceof SdkAutoConstructList);
    }

    public final List<String> statusCodesAsStrings() {
        return this.statusCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventArns() ? this.eventArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityArns() ? this.entityArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityValues() ? this.entityValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastUpdatedTimes() ? this.lastUpdatedTimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusCodes() ? this.statusCodesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityFilter)) {
            return false;
        }
        EntityFilter other = (EntityFilter)obj;
        return this.hasEventArns() == other.hasEventArns() && Objects.equals(this.eventArns(), other.eventArns()) && this.hasEntityArns() == other.hasEntityArns() && Objects.equals(this.entityArns(), other.entityArns()) && this.hasEntityValues() == other.hasEntityValues() && Objects.equals(this.entityValues(), other.entityValues()) && this.hasLastUpdatedTimes() == other.hasLastUpdatedTimes() && Objects.equals(this.lastUpdatedTimes(), other.lastUpdatedTimes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasStatusCodes() == other.hasStatusCodes() && Objects.equals(this.statusCodesAsStrings(), other.statusCodesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"EntityFilter").add("EventArns", this.hasEventArns() ? this.eventArns() : null).add("EntityArns", this.hasEntityArns() ? this.entityArns() : null).add("EntityValues", this.hasEntityValues() ? this.entityValues() : null).add("LastUpdatedTimes", this.hasLastUpdatedTimes() ? this.lastUpdatedTimes() : null).add("Tags", this.hasTags() ? this.tags() : null).add("StatusCodes", this.hasStatusCodes() ? this.statusCodesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArns": {
                return Optional.ofNullable(clazz.cast(this.eventArns()));
            }
            case "entityArns": {
                return Optional.ofNullable(clazz.cast(this.entityArns()));
            }
            case "entityValues": {
                return Optional.ofNullable(clazz.cast(this.entityValues()));
            }
            case "lastUpdatedTimes": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimes()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "statusCodes": {
                return Optional.ofNullable(clazz.cast(this.statusCodesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityFilter, T> g) {
        return obj -> g.apply((EntityFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> entityArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> entityValues = DefaultSdkAutoConstructList.getInstance();
        private List<DateTimeRange> lastUpdatedTimes = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, String>> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> statusCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityFilter model) {
            this.eventArns(model.eventArns);
            this.entityArns(model.entityArns);
            this.entityValues(model.entityValues);
            this.lastUpdatedTimes(model.lastUpdatedTimes);
            this.tags(model.tags);
            this.statusCodesWithStrings(model.statusCodes);
        }

        public final Collection<String> getEventArns() {
            if (this.eventArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventArns;
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        public final Collection<String> getEntityArns() {
            if (this.entityArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entityArns;
        }

        @Override
        public final Builder entityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityArns(String ... entityArns) {
            this.entityArns(Arrays.asList(entityArns));
            return this;
        }

        public final void setEntityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
        }

        public final Collection<String> getEntityValues() {
            if (this.entityValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entityValues;
        }

        @Override
        public final Builder entityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityValues(String ... entityValues) {
            this.entityValues(Arrays.asList(entityValues));
            return this;
        }

        public final void setEntityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
        }

        public final Collection<DateTimeRange.Builder> getLastUpdatedTimes() {
            if (this.lastUpdatedTimes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lastUpdatedTimes != null ? (Collection)this.lastUpdatedTimes.stream().map(DateTimeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copy(lastUpdatedTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(DateTimeRange ... lastUpdatedTimes) {
            this.lastUpdatedTimes(Arrays.asList(lastUpdatedTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(Consumer<DateTimeRange.Builder> ... lastUpdatedTimes) {
            this.lastUpdatedTimes(Stream.of(lastUpdatedTimes).map(c -> (DateTimeRange)((DateTimeRange.Builder)DateTimeRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLastUpdatedTimes(Collection<DateTimeRange.BuilderImpl> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copyFromBuilder(lastUpdatedTimes);
        }

        public final Collection<? extends Map<String, String>> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<? extends Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Map<String, String> ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<? extends Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
        }

        public final Collection<String> getStatusCodes() {
            if (this.statusCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusCodes;
        }

        @Override
        public final Builder statusCodesWithStrings(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusCodesWithStrings(String ... statusCodes) {
            this.statusCodesWithStrings(Arrays.asList(statusCodes));
            return this;
        }

        @Override
        public final Builder statusCodes(Collection<EntityStatusCode> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copyEnumToString(statusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusCodes(EntityStatusCode ... statusCodes) {
            this.statusCodes(Arrays.asList(statusCodes));
            return this;
        }

        public final void setStatusCodes(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
        }

        public EntityFilter build() {
            return new EntityFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityFilter> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder entityArns(Collection<String> var1);

        public Builder entityArns(String ... var1);

        public Builder entityValues(Collection<String> var1);

        public Builder entityValues(String ... var1);

        public Builder lastUpdatedTimes(Collection<DateTimeRange> var1);

        public Builder lastUpdatedTimes(DateTimeRange ... var1);

        public Builder lastUpdatedTimes(Consumer<DateTimeRange.Builder> ... var1);

        public Builder tags(Collection<? extends Map<String, String>> var1);

        public Builder tags(Map<String, String> ... var1);

        public Builder statusCodesWithStrings(Collection<String> var1);

        public Builder statusCodesWithStrings(String ... var1);

        public Builder statusCodes(Collection<EntityStatusCode> var1);

        public Builder statusCodes(EntityStatusCode ... var1);
    }
}

