/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.honeycode.model.Format;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataItem> {
    private static final SdkField<String> OVERRIDE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overrideFormat").getter(DataItem.getter(DataItem::overrideFormatAsString)).setter(DataItem.setter(Builder::overrideFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideFormat").build()}).build();
    private static final SdkField<String> RAW_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rawValue").getter(DataItem.getter(DataItem::rawValue)).setter(DataItem.setter(Builder::rawValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawValue").build()}).build();
    private static final SdkField<String> FORMATTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formattedValue").getter(DataItem.getter(DataItem::formattedValue)).setter(DataItem.setter(Builder::formattedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formattedValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDE_FORMAT_FIELD, RAW_VALUE_FIELD, FORMATTED_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String overrideFormat;
    private final String rawValue;
    private final String formattedValue;

    private DataItem(BuilderImpl builder) {
        this.overrideFormat = builder.overrideFormat;
        this.rawValue = builder.rawValue;
        this.formattedValue = builder.formattedValue;
    }

    public final Format overrideFormat() {
        return Format.fromValue(this.overrideFormat);
    }

    public final String overrideFormatAsString() {
        return this.overrideFormat;
    }

    public final String rawValue() {
        return this.rawValue;
    }

    public final String formattedValue() {
        return this.formattedValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.formattedValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataItem)) {
            return false;
        }
        DataItem other = (DataItem)obj;
        return Objects.equals(this.overrideFormatAsString(), other.overrideFormatAsString()) && Objects.equals(this.rawValue(), other.rawValue()) && Objects.equals(this.formattedValue(), other.formattedValue());
    }

    public final String toString() {
        return ToString.builder((String)"DataItem").add("OverrideFormat", (Object)this.overrideFormatAsString()).add("RawValue", (Object)this.rawValue()).add("FormattedValue", (Object)this.formattedValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "overrideFormat": {
                return Optional.ofNullable(clazz.cast(this.overrideFormatAsString()));
            }
            case "rawValue": {
                return Optional.ofNullable(clazz.cast(this.rawValue()));
            }
            case "formattedValue": {
                return Optional.ofNullable(clazz.cast(this.formattedValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataItem, T> g) {
        return obj -> g.apply((DataItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String overrideFormat;
        private String rawValue;
        private String formattedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DataItem model) {
            this.overrideFormat(model.overrideFormat);
            this.rawValue(model.rawValue);
            this.formattedValue(model.formattedValue);
        }

        public final String getOverrideFormat() {
            return this.overrideFormat;
        }

        public final void setOverrideFormat(String overrideFormat) {
            this.overrideFormat = overrideFormat;
        }

        @Override
        @Transient
        public final Builder overrideFormat(String overrideFormat) {
            this.overrideFormat = overrideFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder overrideFormat(Format overrideFormat) {
            this.overrideFormat(overrideFormat == null ? null : overrideFormat.toString());
            return this;
        }

        public final String getRawValue() {
            return this.rawValue;
        }

        public final void setRawValue(String rawValue) {
            this.rawValue = rawValue;
        }

        @Override
        @Transient
        public final Builder rawValue(String rawValue) {
            this.rawValue = rawValue;
            return this;
        }

        public final String getFormattedValue() {
            return this.formattedValue;
        }

        public final void setFormattedValue(String formattedValue) {
            this.formattedValue = formattedValue;
        }

        @Override
        @Transient
        public final Builder formattedValue(String formattedValue) {
            this.formattedValue = formattedValue;
            return this;
        }

        public DataItem build() {
            return new DataItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataItem> {
        public Builder overrideFormat(String var1);

        public Builder overrideFormat(Format var1);

        public Builder rawValue(String var1);

        public Builder formattedValue(String var1);
    }
}

