/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.honeycode.model.ImportColumnMapCopier;
import software.amazon.awssdk.services.honeycode.model.SourceDataColumnProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationOptions> {
    private static final SdkField<Map<String, SourceDataColumnProperties>> COLUMN_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("columnMap").getter(DestinationOptions.getter(DestinationOptions::columnMap)).setter(DestinationOptions.setter(Builder::columnMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceDataColumnProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, SourceDataColumnProperties> columnMap;

    private DestinationOptions(BuilderImpl builder) {
        this.columnMap = builder.columnMap;
    }

    public final boolean hasColumnMap() {
        return this.columnMap != null && !(this.columnMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, SourceDataColumnProperties> columnMap() {
        return this.columnMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnMap() ? this.columnMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationOptions)) {
            return false;
        }
        DestinationOptions other = (DestinationOptions)obj;
        return this.hasColumnMap() == other.hasColumnMap() && Objects.equals(this.columnMap(), other.columnMap());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationOptions").add("ColumnMap", this.hasColumnMap() ? this.columnMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columnMap": {
                return Optional.ofNullable(clazz.cast(this.columnMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationOptions, T> g) {
        return obj -> g.apply((DestinationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, SourceDataColumnProperties> columnMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationOptions model) {
            this.columnMap(model.columnMap);
        }

        public final Map<String, SourceDataColumnProperties.Builder> getColumnMap() {
            Map<String, SourceDataColumnProperties.Builder> result = ImportColumnMapCopier.copyToBuilder(this.columnMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setColumnMap(Map<String, SourceDataColumnProperties.BuilderImpl> columnMap) {
            this.columnMap = ImportColumnMapCopier.copyFromBuilder(columnMap);
        }

        @Override
        @Transient
        public final Builder columnMap(Map<String, SourceDataColumnProperties> columnMap) {
            this.columnMap = ImportColumnMapCopier.copy(columnMap);
            return this;
        }

        public DestinationOptions build() {
            return new DestinationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationOptions> {
        public Builder columnMap(Map<String, SourceDataColumnProperties> var1);
    }
}

