/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.HoneycodeRequest;
import software.amazon.awssdk.services.honeycode.model.RowIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTableRowsRequest
extends HoneycodeRequest
implements ToCopyableBuilder<Builder, ListTableRowsRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workbookId").getter(ListTableRowsRequest.getter(ListTableRowsRequest::workbookId)).setter(ListTableRowsRequest.setter(Builder::workbookId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableId").getter(ListTableRowsRequest.getter(ListTableRowsRequest::tableId)).setter(ListTableRowsRequest.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()}).build();
    private static final SdkField<List<String>> ROW_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rowIds").getter(ListTableRowsRequest.getter(ListTableRowsRequest::rowIds)).setter(ListTableRowsRequest.setter(Builder::rowIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTableRowsRequest.getter(ListTableRowsRequest::maxResults)).setter(ListTableRowsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTableRowsRequest.getter(ListTableRowsRequest::nextToken)).setter(ListTableRowsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD, TABLE_ID_FIELD, ROW_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String workbookId;
    private final String tableId;
    private final List<String> rowIds;
    private final Integer maxResults;
    private final String nextToken;

    private ListTableRowsRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.tableId = builder.tableId;
        this.rowIds = builder.rowIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String workbookId() {
        return this.workbookId;
    }

    public final String tableId() {
        return this.tableId;
    }

    public final boolean hasRowIds() {
        return this.rowIds != null && !(this.rowIds instanceof SdkAutoConstructList);
    }

    public final List<String> rowIds() {
        return this.rowIds;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowIds() ? this.rowIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableRowsRequest)) {
            return false;
        }
        ListTableRowsRequest other = (ListTableRowsRequest)((Object)obj);
        return Objects.equals(this.workbookId(), other.workbookId()) && Objects.equals(this.tableId(), other.tableId()) && this.hasRowIds() == other.hasRowIds() && Objects.equals(this.rowIds(), other.rowIds()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTableRowsRequest").add("WorkbookId", (Object)this.workbookId()).add("TableId", (Object)this.tableId()).add("RowIds", this.hasRowIds() ? this.rowIds() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workbookId": {
                return Optional.ofNullable(clazz.cast(this.workbookId()));
            }
            case "tableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "rowIds": {
                return Optional.ofNullable(clazz.cast(this.rowIds()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTableRowsRequest, T> g) {
        return obj -> g.apply((ListTableRowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeRequest.BuilderImpl
    implements Builder {
        private String workbookId;
        private String tableId;
        private List<String> rowIds = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableRowsRequest model) {
            super(model);
            this.workbookId(model.workbookId);
            this.tableId(model.tableId);
            this.rowIds(model.rowIds);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getWorkbookId() {
            return this.workbookId;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        @Override
        @Transient
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final String getTableId() {
            return this.tableId;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        @Override
        @Transient
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final Collection<String> getRowIds() {
            if (this.rowIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rowIds;
        }

        public final void setRowIds(Collection<String> rowIds) {
            this.rowIds = RowIdListCopier.copy(rowIds);
        }

        @Override
        @Transient
        public final Builder rowIds(Collection<String> rowIds) {
            this.rowIds = RowIdListCopier.copy(rowIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rowIds(String ... rowIds) {
            this.rowIds(Arrays.asList(rowIds));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTableRowsRequest build() {
            return new ListTableRowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTableRowsRequest> {
        public Builder workbookId(String var1);

        public Builder tableId(String var1);

        public Builder rowIds(Collection<String> var1);

        public Builder rowIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

