/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.identitystore.model.ExternalId;
import software.amazon.awssdk.services.identitystore.model.UniqueAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlternateIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlternateIdentifier> {
    private static final SdkField<ExternalId> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExternalId").getter(AlternateIdentifier.getter(AlternateIdentifier::externalId)).setter(AlternateIdentifier.setter(Builder::externalId)).constructor(ExternalId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()}).build();
    private static final SdkField<UniqueAttribute> UNIQUE_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UniqueAttribute").getter(AlternateIdentifier.getter(AlternateIdentifier::uniqueAttribute)).setter(AlternateIdentifier.setter(Builder::uniqueAttribute)).constructor(UniqueAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueAttribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_ID_FIELD, UNIQUE_ATTRIBUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlternateIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ExternalId externalId;
    private final UniqueAttribute uniqueAttribute;
    private final Type type;

    private AlternateIdentifier(BuilderImpl builder) {
        this.externalId = builder.externalId;
        this.uniqueAttribute = builder.uniqueAttribute;
        this.type = builder.type;
    }

    public final ExternalId externalId() {
        return this.externalId;
    }

    public final UniqueAttribute uniqueAttribute() {
        return this.uniqueAttribute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueAttribute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlternateIdentifier)) {
            return false;
        }
        AlternateIdentifier other = (AlternateIdentifier)obj;
        return Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.uniqueAttribute(), other.uniqueAttribute());
    }

    public final String toString() {
        return ToString.builder((String)"AlternateIdentifier").add("ExternalId", (Object)this.externalId()).add("UniqueAttribute", (Object)this.uniqueAttribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "UniqueAttribute": {
                return Optional.ofNullable(clazz.cast(this.uniqueAttribute()));
            }
        }
        return Optional.empty();
    }

    public static AlternateIdentifier fromExternalId(ExternalId externalId) {
        return (AlternateIdentifier)AlternateIdentifier.builder().externalId(externalId).build();
    }

    public static AlternateIdentifier fromExternalId(Consumer<ExternalId.Builder> externalId) {
        ExternalId.Builder builder = ExternalId.builder();
        externalId.accept(builder);
        return AlternateIdentifier.fromExternalId((ExternalId)builder.build());
    }

    public static AlternateIdentifier fromUniqueAttribute(UniqueAttribute uniqueAttribute) {
        return (AlternateIdentifier)AlternateIdentifier.builder().uniqueAttribute(uniqueAttribute).build();
    }

    public static AlternateIdentifier fromUniqueAttribute(Consumer<UniqueAttribute.Builder> uniqueAttribute) {
        UniqueAttribute.Builder builder = UniqueAttribute.builder();
        uniqueAttribute.accept(builder);
        return AlternateIdentifier.fromUniqueAttribute((UniqueAttribute)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExternalId", EXTERNAL_ID_FIELD);
        map.put("UniqueAttribute", UNIQUE_ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlternateIdentifier, T> g) {
        return obj -> g.apply((AlternateIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EXTERNAL_ID,
        UNIQUE_ATTRIBUTE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ExternalId externalId;
        private UniqueAttribute uniqueAttribute;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AlternateIdentifier model) {
            this.externalId(model.externalId);
            this.uniqueAttribute(model.uniqueAttribute);
        }

        public final ExternalId.Builder getExternalId() {
            return this.externalId != null ? this.externalId.toBuilder() : null;
        }

        public final void setExternalId(ExternalId.BuilderImpl externalId) {
            ExternalId oldValue = this.externalId;
            this.externalId = externalId != null ? externalId.build() : null;
            this.handleUnionValueChange(Type.EXTERNAL_ID, oldValue, this.externalId);
        }

        @Override
        public final Builder externalId(ExternalId externalId) {
            ExternalId oldValue = this.externalId;
            this.externalId = externalId;
            this.handleUnionValueChange(Type.EXTERNAL_ID, oldValue, this.externalId);
            return this;
        }

        public final UniqueAttribute.Builder getUniqueAttribute() {
            return this.uniqueAttribute != null ? this.uniqueAttribute.toBuilder() : null;
        }

        public final void setUniqueAttribute(UniqueAttribute.BuilderImpl uniqueAttribute) {
            UniqueAttribute oldValue = this.uniqueAttribute;
            this.uniqueAttribute = uniqueAttribute != null ? uniqueAttribute.build() : null;
            this.handleUnionValueChange(Type.UNIQUE_ATTRIBUTE, oldValue, this.uniqueAttribute);
        }

        @Override
        public final Builder uniqueAttribute(UniqueAttribute uniqueAttribute) {
            UniqueAttribute oldValue = this.uniqueAttribute;
            this.uniqueAttribute = uniqueAttribute;
            this.handleUnionValueChange(Type.UNIQUE_ATTRIBUTE, oldValue, this.uniqueAttribute);
            return this;
        }

        public AlternateIdentifier build() {
            return new AlternateIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlternateIdentifier> {
        public Builder externalId(ExternalId var1);

        default public Builder externalId(Consumer<ExternalId.Builder> externalId) {
            return this.externalId((ExternalId)((ExternalId.Builder)ExternalId.builder().applyMutation(externalId)).build());
        }

        public Builder uniqueAttribute(UniqueAttribute var1);

        default public Builder uniqueAttribute(Consumer<UniqueAttribute.Builder> uniqueAttribute) {
            return this.uniqueAttribute((UniqueAttribute)((UniqueAttribute.Builder)UniqueAttribute.builder().applyMutation(uniqueAttribute)).build());
        }
    }
}

