/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.services.inspector.model.StopAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopAssessmentRunRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, StopAssessmentRunRequest> {
    private static final SdkField<String> ASSESSMENT_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentRunArn").getter(StopAssessmentRunRequest.getter(StopAssessmentRunRequest::assessmentRunArn)).setter(StopAssessmentRunRequest.setter(Builder::assessmentRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArn").build()}).build();
    private static final SdkField<String> STOP_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stopAction").getter(StopAssessmentRunRequest.getter(StopAssessmentRunRequest::stopActionAsString)).setter(StopAssessmentRunRequest.setter(Builder::stopAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARN_FIELD, STOP_ACTION_FIELD));
    private final String assessmentRunArn;
    private final String stopAction;

    private StopAssessmentRunRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArn = builder.assessmentRunArn;
        this.stopAction = builder.stopAction;
    }

    public final String assessmentRunArn() {
        return this.assessmentRunArn;
    }

    public final StopAction stopAction() {
        return StopAction.fromValue(this.stopAction);
    }

    public final String stopActionAsString() {
        return this.stopAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopActionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopAssessmentRunRequest)) {
            return false;
        }
        StopAssessmentRunRequest other = (StopAssessmentRunRequest)((Object)obj);
        return Objects.equals(this.assessmentRunArn(), other.assessmentRunArn()) && Objects.equals(this.stopActionAsString(), other.stopActionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StopAssessmentRunRequest").add("AssessmentRunArn", (Object)this.assessmentRunArn()).add("StopAction", (Object)this.stopActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentRunArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentRunArn()));
            }
            case "stopAction": {
                return Optional.ofNullable(clazz.cast(this.stopActionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopAssessmentRunRequest, T> g) {
        return obj -> g.apply((StopAssessmentRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private String assessmentRunArn;
        private String stopAction;

        private BuilderImpl() {
        }

        private BuilderImpl(StopAssessmentRunRequest model) {
            super(model);
            this.assessmentRunArn(model.assessmentRunArn);
            this.stopAction(model.stopAction);
        }

        public final String getAssessmentRunArn() {
            return this.assessmentRunArn;
        }

        public final void setAssessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
        }

        @Override
        @Transient
        public final Builder assessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
            return this;
        }

        public final String getStopAction() {
            return this.stopAction;
        }

        public final void setStopAction(String stopAction) {
            this.stopAction = stopAction;
        }

        @Override
        @Transient
        public final Builder stopAction(String stopAction) {
            this.stopAction = stopAction;
            return this;
        }

        @Override
        @Transient
        public final Builder stopAction(StopAction stopAction) {
            this.stopAction(stopAction == null ? null : stopAction.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopAssessmentRunRequest build() {
            return new StopAssessmentRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopAssessmentRunRequest> {
        public Builder assessmentRunArn(String var1);

        public Builder stopAction(String var1);

        public Builder stopAction(StopAction var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

