/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse;

public class GetExclusionsPreviewPublisher
implements SdkPublisher<GetExclusionsPreviewResponse> {
    private final InspectorAsyncClient client;
    private final GetExclusionsPreviewRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetExclusionsPreviewPublisher(InspectorAsyncClient client, GetExclusionsPreviewRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetExclusionsPreviewPublisher(InspectorAsyncClient client, GetExclusionsPreviewRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetExclusionsPreviewResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetExclusionsPreviewResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetExclusionsPreviewResponseFetcher
    implements AsyncPageFetcher<GetExclusionsPreviewResponse> {
        private GetExclusionsPreviewResponseFetcher() {
        }

        public boolean hasNextPage(GetExclusionsPreviewResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetExclusionsPreviewResponse> nextPage(GetExclusionsPreviewResponse previousPage) {
            if (previousPage == null) {
                return GetExclusionsPreviewPublisher.this.client.getExclusionsPreview(GetExclusionsPreviewPublisher.this.firstRequest);
            }
            return GetExclusionsPreviewPublisher.this.client.getExclusionsPreview((GetExclusionsPreviewRequest)((Object)GetExclusionsPreviewPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

