/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsRequest;
import software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsResponse;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateRequest;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateResponse;
import software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewRequest;
import software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewResponse;
import software.amazon.awssdk.services.inspector.model.CreateResourceGroupRequest;
import software.amazon.awssdk.services.inspector.model.CreateResourceGroupResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesResponse;
import software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleRequest;
import software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleResponse;
import software.amazon.awssdk.services.inspector.model.DescribeExclusionsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeExclusionsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeFindingsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeFindingsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesRequest;
import software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesResponse;
import software.amazon.awssdk.services.inspector.model.GetAssessmentReportRequest;
import software.amazon.awssdk.services.inspector.model.GetAssessmentReportResponse;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse;
import software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataRequest;
import software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse;
import software.amazon.awssdk.services.inspector.model.ListExclusionsRequest;
import software.amazon.awssdk.services.inspector.model.ListExclusionsResponse;
import software.amazon.awssdk.services.inspector.model.ListFindingsRequest;
import software.amazon.awssdk.services.inspector.model.ListFindingsResponse;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse;
import software.amazon.awssdk.services.inspector.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.inspector.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse;
import software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleRequest;
import software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleResponse;
import software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsRequest;
import software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsResponse;
import software.amazon.awssdk.services.inspector.model.SetTagsForResourceRequest;
import software.amazon.awssdk.services.inspector.model.SetTagsForResourceResponse;
import software.amazon.awssdk.services.inspector.model.StartAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.StartAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.StopAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.StopAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.SubscribeToEventRequest;
import software.amazon.awssdk.services.inspector.model.SubscribeToEventResponse;
import software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventRequest;
import software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventResponse;
import software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewPublisher;
import software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsPublisher;
import software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsPublisher;
import software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsPublisher;
import software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesPublisher;
import software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsPublisher;
import software.amazon.awssdk.services.inspector.paginators.ListExclusionsPublisher;
import software.amazon.awssdk.services.inspector.paginators.ListFindingsPublisher;
import software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesPublisher;
import software.amazon.awssdk.services.inspector.paginators.PreviewAgentsPublisher;

/**
 * Service client for accessing Amazon Inspector asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon Inspector</fullname>
 * <p>
 * Amazon Inspector enables you to analyze the behavior of your AWS resources and to identify potential security issues.
 * For more information, see <a
 * href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_introduction.html"> Amazon Inspector User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface InspectorAsyncClient extends AwsClient {
    String SERVICE_NAME = "inspector";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "inspector";

    /**
     * <p>
     * Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     * </p>
     *
     * @param addAttributesToFindingsRequest
     * @return A Java Future containing the result of the AddAttributesToFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.AddAttributesToFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/AddAttributesToFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddAttributesToFindingsResponse> addAttributesToFindings(
            AddAttributesToFindingsRequest addAttributesToFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddAttributesToFindingsRequest.Builder} avoiding
     * the need to create one manually via {@link AddAttributesToFindingsRequest#builder()}
     * </p>
     *
     * @param addAttributesToFindingsRequest
     *        A {@link Consumer} that will call methods on {@link AddAttributesToFindingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddAttributesToFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.AddAttributesToFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/AddAttributesToFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddAttributesToFindingsResponse> addAttributesToFindings(
            Consumer<AddAttributesToFindingsRequest.Builder> addAttributesToFindingsRequest) {
        return addAttributesToFindings(AddAttributesToFindingsRequest.builder().applyMutation(addAttributesToFindingsRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new assessment target using the ARN of the resource group that is generated by
     * <a>CreateResourceGroup</a>. If resourceGroupArn is not specified, all EC2 instances in the current AWS account
     * and region are included in the assessment target. If the <a
     * href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked role</a> isn’t
     * already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access
     * to AWS Services needed to perform security assessments. You can create up to 50 assessment targets per AWS
     * account. You can run up to 500 concurrent agents per AWS account. For more information, see <a
     * href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html"> Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     *
     * @param createAssessmentTargetRequest
     * @return A Java Future containing the result of the CreateAssessmentTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>InvalidCrossAccountRoleException Amazon Inspector cannot assume the cross-account role that it needs
     *         to list your EC2 instances during the assessment run.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.CreateAssessmentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssessmentTargetResponse> createAssessmentTarget(
            CreateAssessmentTargetRequest createAssessmentTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new assessment target using the ARN of the resource group that is generated by
     * <a>CreateResourceGroup</a>. If resourceGroupArn is not specified, all EC2 instances in the current AWS account
     * and region are included in the assessment target. If the <a
     * href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked role</a> isn’t
     * already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access
     * to AWS Services needed to perform security assessments. You can create up to 50 assessment targets per AWS
     * account. You can run up to 500 concurrent agents per AWS account. For more information, see <a
     * href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html"> Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssessmentTargetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAssessmentTargetRequest#builder()}
     * </p>
     *
     * @param createAssessmentTargetRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssessmentTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAssessmentTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>InvalidCrossAccountRoleException Amazon Inspector cannot assume the cross-account role that it needs
     *         to list your EC2 instances during the assessment run.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.CreateAssessmentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssessmentTargetResponse> createAssessmentTarget(
            Consumer<CreateAssessmentTargetRequest.Builder> createAssessmentTargetRequest) {
        return createAssessmentTarget(CreateAssessmentTargetRequest.builder().applyMutation(createAssessmentTargetRequest)
                .build());
    }

    /**
     * <p>
     * Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.
     * If the <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked
     * role</a> isn’t already registered, this action also creates and registers a service-linked role to grant Amazon
     * Inspector access to AWS Services needed to perform security assessments.
     * </p>
     *
     * @param createAssessmentTemplateRequest
     * @return A Java Future containing the result of the CreateAssessmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.CreateAssessmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssessmentTemplateResponse> createAssessmentTemplate(
            CreateAssessmentTemplateRequest createAssessmentTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.
     * If the <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked
     * role</a> isn’t already registered, this action also creates and registers a service-linked role to grant Amazon
     * Inspector access to AWS Services needed to perform security assessments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssessmentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAssessmentTemplateRequest#builder()}
     * </p>
     *
     * @param createAssessmentTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssessmentTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAssessmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.CreateAssessmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssessmentTemplateResponse> createAssessmentTemplate(
            Consumer<CreateAssessmentTemplateRequest.Builder> createAssessmentTemplateRequest) {
        return createAssessmentTemplate(CreateAssessmentTemplateRequest.builder().applyMutation(createAssessmentTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Starts the generation of an exclusions preview for the specified assessment template. The exclusions preview
     * lists the potential exclusions (ExclusionPreview) that Inspector can detect before it runs the assessment.
     * </p>
     *
     * @param createExclusionsPreviewRequest
     * @return A Java Future containing the result of the CreateExclusionsPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>PreviewGenerationInProgressException The request is rejected. The specified assessment template is
     *         currently generating an exclusions preview.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.CreateExclusionsPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateExclusionsPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateExclusionsPreviewResponse> createExclusionsPreview(
            CreateExclusionsPreviewRequest createExclusionsPreviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the generation of an exclusions preview for the specified assessment template. The exclusions preview
     * lists the potential exclusions (ExclusionPreview) that Inspector can detect before it runs the assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExclusionsPreviewRequest.Builder} avoiding
     * the need to create one manually via {@link CreateExclusionsPreviewRequest#builder()}
     * </p>
     *
     * @param createExclusionsPreviewRequest
     *        A {@link Consumer} that will call methods on {@link CreateExclusionsPreviewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateExclusionsPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>PreviewGenerationInProgressException The request is rejected. The specified assessment template is
     *         currently generating an exclusions preview.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.CreateExclusionsPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateExclusionsPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateExclusionsPreviewResponse> createExclusionsPreview(
            Consumer<CreateExclusionsPreviewRequest.Builder> createExclusionsPreviewRequest) {
        return createExclusionsPreview(CreateExclusionsPreviewRequest.builder().applyMutation(createExclusionsPreviewRequest)
                .build());
    }

    /**
     * <p>
     * Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2
     * instances to be included in an Amazon Inspector assessment target. The created resource group is then used to
     * create an Amazon Inspector assessment target. For more information, see <a>CreateAssessmentTarget</a>.
     * </p>
     *
     * @param createResourceGroupRequest
     * @return A Java Future containing the result of the CreateResourceGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.CreateResourceGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateResourceGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateResourceGroupResponse> createResourceGroup(
            CreateResourceGroupRequest createResourceGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2
     * instances to be included in an Amazon Inspector assessment target. The created resource group is then used to
     * create an Amazon Inspector assessment target. For more information, see <a>CreateAssessmentTarget</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceGroupRequest#builder()}
     * </p>
     *
     * @param createResourceGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateResourceGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.CreateResourceGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateResourceGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateResourceGroupResponse> createResourceGroup(
            Consumer<CreateResourceGroupRequest.Builder> createResourceGroupRequest) {
        return createResourceGroup(CreateResourceGroupRequest.builder().applyMutation(createResourceGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the assessment run that is specified by the ARN of the assessment run.
     * </p>
     *
     * @param deleteAssessmentRunRequest
     * @return A Java Future containing the result of the DeleteAssessmentRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AssessmentRunInProgressException You cannot perform a specified action if an assessment run is
     *         currently in progress.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DeleteAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentRunResponse> deleteAssessmentRun(
            DeleteAssessmentRunRequest deleteAssessmentRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the assessment run that is specified by the ARN of the assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentRunRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAssessmentRunRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentRunRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssessmentRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAssessmentRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AssessmentRunInProgressException You cannot perform a specified action if an assessment run is
     *         currently in progress.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DeleteAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentRunResponse> deleteAssessmentRun(
            Consumer<DeleteAssessmentRunRequest.Builder> deleteAssessmentRunRequest) {
        return deleteAssessmentRun(DeleteAssessmentRunRequest.builder().applyMutation(deleteAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Deletes the assessment target that is specified by the ARN of the assessment target.
     * </p>
     *
     * @param deleteAssessmentTargetRequest
     * @return A Java Future containing the result of the DeleteAssessmentTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AssessmentRunInProgressException You cannot perform a specified action if an assessment run is
     *         currently in progress.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DeleteAssessmentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentTargetResponse> deleteAssessmentTarget(
            DeleteAssessmentTargetRequest deleteAssessmentTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the assessment target that is specified by the ARN of the assessment target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentTargetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAssessmentTargetRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentTargetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssessmentTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAssessmentTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AssessmentRunInProgressException You cannot perform a specified action if an assessment run is
     *         currently in progress.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DeleteAssessmentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentTargetResponse> deleteAssessmentTarget(
            Consumer<DeleteAssessmentTargetRequest.Builder> deleteAssessmentTargetRequest) {
        return deleteAssessmentTarget(DeleteAssessmentTargetRequest.builder().applyMutation(deleteAssessmentTargetRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the assessment template that is specified by the ARN of the assessment template.
     * </p>
     *
     * @param deleteAssessmentTemplateRequest
     * @return A Java Future containing the result of the DeleteAssessmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AssessmentRunInProgressException You cannot perform a specified action if an assessment run is
     *         currently in progress.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DeleteAssessmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentTemplateResponse> deleteAssessmentTemplate(
            DeleteAssessmentTemplateRequest deleteAssessmentTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the assessment template that is specified by the ARN of the assessment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAssessmentTemplateRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssessmentTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAssessmentTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AssessmentRunInProgressException You cannot perform a specified action if an assessment run is
     *         currently in progress.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DeleteAssessmentTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssessmentTemplateResponse> deleteAssessmentTemplate(
            Consumer<DeleteAssessmentTemplateRequest.Builder> deleteAssessmentTemplateRequest) {
        return deleteAssessmentTemplate(DeleteAssessmentTemplateRequest.builder().applyMutation(deleteAssessmentTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Describes the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     *
     * @param describeAssessmentRunsRequest
     * @return A Java Future containing the result of the DescribeAssessmentRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssessmentRunsResponse> describeAssessmentRuns(
            DescribeAssessmentRunsRequest describeAssessmentRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssessmentRunsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param describeAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssessmentRunsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAssessmentRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssessmentRunsResponse> describeAssessmentRuns(
            Consumer<DescribeAssessmentRunsRequest.Builder> describeAssessmentRunsRequest) {
        return describeAssessmentRuns(DescribeAssessmentRunsRequest.builder().applyMutation(describeAssessmentRunsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the assessment targets that are specified by the ARNs of the assessment targets.
     * </p>
     *
     * @param describeAssessmentTargetsRequest
     * @return A Java Future containing the result of the DescribeAssessmentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeAssessmentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssessmentTargetsResponse> describeAssessmentTargets(
            DescribeAssessmentTargetsRequest describeAssessmentTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the assessment targets that are specified by the ARNs of the assessment targets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssessmentTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAssessmentTargetsRequest#builder()}
     * </p>
     *
     * @param describeAssessmentTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssessmentTargetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAssessmentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeAssessmentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssessmentTargetsResponse> describeAssessmentTargets(
            Consumer<DescribeAssessmentTargetsRequest.Builder> describeAssessmentTargetsRequest) {
        return describeAssessmentTargets(DescribeAssessmentTargetsRequest.builder()
                .applyMutation(describeAssessmentTargetsRequest).build());
    }

    /**
     * <p>
     * Describes the assessment templates that are specified by the ARNs of the assessment templates.
     * </p>
     *
     * @param describeAssessmentTemplatesRequest
     * @return A Java Future containing the result of the DescribeAssessmentTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeAssessmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssessmentTemplatesResponse> describeAssessmentTemplates(
            DescribeAssessmentTemplatesRequest describeAssessmentTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the assessment templates that are specified by the ARNs of the assessment templates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssessmentTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssessmentTemplatesRequest#builder()}
     * </p>
     *
     * @param describeAssessmentTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssessmentTemplatesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeAssessmentTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeAssessmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssessmentTemplatesResponse> describeAssessmentTemplates(
            Consumer<DescribeAssessmentTemplatesRequest.Builder> describeAssessmentTemplatesRequest) {
        return describeAssessmentTemplates(DescribeAssessmentTemplatesRequest.builder()
                .applyMutation(describeAssessmentTemplatesRequest).build());
    }

    /**
     * <p>
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     * </p>
     *
     * @param describeCrossAccountAccessRoleRequest
     * @return A Java Future containing the result of the DescribeCrossAccountAccessRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeCrossAccountAccessRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeCrossAccountAccessRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCrossAccountAccessRoleResponse> describeCrossAccountAccessRole(
            DescribeCrossAccountAccessRoleRequest describeCrossAccountAccessRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCrossAccountAccessRoleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCrossAccountAccessRoleRequest#builder()}
     * </p>
     *
     * @param describeCrossAccountAccessRoleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCrossAccountAccessRoleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeCrossAccountAccessRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeCrossAccountAccessRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeCrossAccountAccessRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCrossAccountAccessRoleResponse> describeCrossAccountAccessRole(
            Consumer<DescribeCrossAccountAccessRoleRequest.Builder> describeCrossAccountAccessRoleRequest) {
        return describeCrossAccountAccessRole(DescribeCrossAccountAccessRoleRequest.builder()
                .applyMutation(describeCrossAccountAccessRoleRequest).build());
    }

    /**
     * <p>
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeCrossAccountAccessRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeCrossAccountAccessRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeCrossAccountAccessRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCrossAccountAccessRoleResponse> describeCrossAccountAccessRole() {
        return describeCrossAccountAccessRole(DescribeCrossAccountAccessRoleRequest.builder().build());
    }

    /**
     * <p>
     * Describes the exclusions that are specified by the exclusions' ARNs.
     * </p>
     *
     * @param describeExclusionsRequest
     * @return A Java Future containing the result of the DescribeExclusions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeExclusions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeExclusions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeExclusionsResponse> describeExclusions(DescribeExclusionsRequest describeExclusionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the exclusions that are specified by the exclusions' ARNs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExclusionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExclusionsRequest#builder()}
     * </p>
     *
     * @param describeExclusionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExclusionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeExclusions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeExclusions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeExclusions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeExclusionsResponse> describeExclusions(
            Consumer<DescribeExclusionsRequest.Builder> describeExclusionsRequest) {
        return describeExclusions(DescribeExclusionsRequest.builder().applyMutation(describeExclusionsRequest).build());
    }

    /**
     * <p>
     * Describes the findings that are specified by the ARNs of the findings.
     * </p>
     *
     * @param describeFindingsRequest
     * @return A Java Future containing the result of the DescribeFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFindingsResponse> describeFindings(DescribeFindingsRequest describeFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the findings that are specified by the ARNs of the findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFindingsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFindingsRequest#builder()}
     * </p>
     *
     * @param describeFindingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFindingsResponse> describeFindings(
            Consumer<DescribeFindingsRequest.Builder> describeFindingsRequest) {
        return describeFindings(DescribeFindingsRequest.builder().applyMutation(describeFindingsRequest).build());
    }

    /**
     * <p>
     * Describes the resource groups that are specified by the ARNs of the resource groups.
     * </p>
     *
     * @param describeResourceGroupsRequest
     * @return A Java Future containing the result of the DescribeResourceGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeResourceGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeResourceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourceGroupsResponse> describeResourceGroups(
            DescribeResourceGroupsRequest describeResourceGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the resource groups that are specified by the ARNs of the resource groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourceGroupsRequest#builder()}
     * </p>
     *
     * @param describeResourceGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResourceGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeResourceGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeResourceGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeResourceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourceGroupsResponse> describeResourceGroups(
            Consumer<DescribeResourceGroupsRequest.Builder> describeResourceGroupsRequest) {
        return describeResourceGroups(DescribeResourceGroupsRequest.builder().applyMutation(describeResourceGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the rules packages that are specified by the ARNs of the rules packages.
     * </p>
     *
     * @param describeRulesPackagesRequest
     * @return A Java Future containing the result of the DescribeRulesPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeRulesPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeRulesPackages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRulesPackagesResponse> describeRulesPackages(
            DescribeRulesPackagesRequest describeRulesPackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the rules packages that are specified by the ARNs of the rules packages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRulesPackagesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRulesPackagesRequest#builder()}
     * </p>
     *
     * @param describeRulesPackagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRulesPackagesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRulesPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.DescribeRulesPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeRulesPackages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRulesPackagesResponse> describeRulesPackages(
            Consumer<DescribeRulesPackagesRequest.Builder> describeRulesPackagesRequest) {
        return describeRulesPackages(DescribeRulesPackagesRequest.builder().applyMutation(describeRulesPackagesRequest).build());
    }

    /**
     * <p>
     * Produces an assessment report that includes detailed and comprehensive results of a specified assessment run.
     * </p>
     *
     * @param getAssessmentReportRequest
     * @return A Java Future containing the result of the GetAssessmentReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>AssessmentRunInProgressException You cannot perform a specified action if an assessment run is
     *         currently in progress.</li>
     *         <li>UnsupportedFeatureException Used by the <a>GetAssessmentReport</a> API. The request was rejected
     *         because you tried to generate a report for an assessment run that existed before reporting was supported
     *         in Amazon Inspector. You can only generate reports for assessment runs that took place or will take place
     *         after generating reports in Amazon Inspector became available.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.GetAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetAssessmentReport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAssessmentReportResponse> getAssessmentReport(
            GetAssessmentReportRequest getAssessmentReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Produces an assessment report that includes detailed and comprehensive results of a specified assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssessmentReportRequest.Builder} avoiding the
     * need to create one manually via {@link GetAssessmentReportRequest#builder()}
     * </p>
     *
     * @param getAssessmentReportRequest
     *        A {@link Consumer} that will call methods on {@link GetAssessmentReportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAssessmentReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>AssessmentRunInProgressException You cannot perform a specified action if an assessment run is
     *         currently in progress.</li>
     *         <li>UnsupportedFeatureException Used by the <a>GetAssessmentReport</a> API. The request was rejected
     *         because you tried to generate a report for an assessment run that existed before reporting was supported
     *         in Amazon Inspector. You can only generate reports for assessment runs that took place or will take place
     *         after generating reports in Amazon Inspector became available.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.GetAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetAssessmentReport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAssessmentReportResponse> getAssessmentReport(
            Consumer<GetAssessmentReportRequest.Builder> getAssessmentReportRequest) {
        return getAssessmentReport(GetAssessmentReportRequest.builder().applyMutation(getAssessmentReportRequest).build());
    }

    /**
     * <p>
     * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can
     * obtain the preview token by running the CreateExclusionsPreview API.
     * </p>
     *
     * @param getExclusionsPreviewRequest
     * @return A Java Future containing the result of the GetExclusionsPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.GetExclusionsPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetExclusionsPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetExclusionsPreviewResponse> getExclusionsPreview(
            GetExclusionsPreviewRequest getExclusionsPreviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can
     * obtain the preview token by running the CreateExclusionsPreview API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExclusionsPreviewRequest.Builder} avoiding the
     * need to create one manually via {@link GetExclusionsPreviewRequest#builder()}
     * </p>
     *
     * @param getExclusionsPreviewRequest
     *        A {@link Consumer} that will call methods on {@link GetExclusionsPreviewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetExclusionsPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.GetExclusionsPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetExclusionsPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetExclusionsPreviewResponse> getExclusionsPreview(
            Consumer<GetExclusionsPreviewRequest.Builder> getExclusionsPreviewRequest) {
        return getExclusionsPreview(GetExclusionsPreviewRequest.builder().applyMutation(getExclusionsPreviewRequest).build());
    }

    /**
     * <p>
     * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can
     * obtain the preview token by running the CreateExclusionsPreview API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getExclusionsPreview(software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewPublisher publisher = client.getExclusionsPreviewPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewPublisher publisher = client.getExclusionsPreviewPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExclusionsPreview(software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest)}
     * operation.</b>
     * </p>
     *
     * @param getExclusionsPreviewRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.GetExclusionsPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetExclusionsPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExclusionsPreviewPublisher getExclusionsPreviewPaginator(GetExclusionsPreviewRequest getExclusionsPreviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can
     * obtain the preview token by running the CreateExclusionsPreview API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getExclusionsPreview(software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewPublisher publisher = client.getExclusionsPreviewPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewPublisher publisher = client.getExclusionsPreviewPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExclusionsPreview(software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExclusionsPreviewRequest.Builder} avoiding the
     * need to create one manually via {@link GetExclusionsPreviewRequest#builder()}
     * </p>
     *
     * @param getExclusionsPreviewRequest
     *        A {@link Consumer} that will call methods on {@link GetExclusionsPreviewRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.GetExclusionsPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetExclusionsPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExclusionsPreviewPublisher getExclusionsPreviewPaginator(
            Consumer<GetExclusionsPreviewRequest.Builder> getExclusionsPreviewRequest) {
        return getExclusionsPreviewPaginator(GetExclusionsPreviewRequest.builder().applyMutation(getExclusionsPreviewRequest)
                .build());
    }

    /**
     * <p>
     * Information about the data that is collected for the specified assessment run.
     * </p>
     *
     * @param getTelemetryMetadataRequest
     * @return A Java Future containing the result of the GetTelemetryMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.GetTelemetryMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetTelemetryMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTelemetryMetadataResponse> getTelemetryMetadata(
            GetTelemetryMetadataRequest getTelemetryMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about the data that is collected for the specified assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTelemetryMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetTelemetryMetadataRequest#builder()}
     * </p>
     *
     * @param getTelemetryMetadataRequest
     *        A {@link Consumer} that will call methods on {@link GetTelemetryMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTelemetryMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.GetTelemetryMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetTelemetryMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTelemetryMetadataResponse> getTelemetryMetadata(
            Consumer<GetTelemetryMetadataRequest.Builder> getTelemetryMetadataRequest) {
        return getTelemetryMetadata(GetTelemetryMetadataRequest.builder().applyMutation(getTelemetryMetadataRequest).build());
    }

    /**
     * <p>
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     *
     * @param listAssessmentRunAgentsRequest
     * @return A Java Future containing the result of the ListAssessmentRunAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentRunAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunAgents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentRunAgentsResponse> listAssessmentRunAgents(
            ListAssessmentRunAgentsRequest listAssessmentRunAgentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentRunAgentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentRunAgentsRequest#builder()}
     * </p>
     *
     * @param listAssessmentRunAgentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentRunAgentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssessmentRunAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentRunAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunAgents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentRunAgentsResponse> listAssessmentRunAgents(
            Consumer<ListAssessmentRunAgentsRequest.Builder> listAssessmentRunAgentsRequest) {
        return listAssessmentRunAgents(ListAssessmentRunAgentsRequest.builder().applyMutation(listAssessmentRunAgentsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentRunAgents(software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsPublisher publisher = client.listAssessmentRunAgentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsPublisher publisher = client.listAssessmentRunAgentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentRunAgents(software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentRunAgentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentRunAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunAgents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentRunAgentsPublisher listAssessmentRunAgentsPaginator(
            ListAssessmentRunAgentsRequest listAssessmentRunAgentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentRunAgents(software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsPublisher publisher = client.listAssessmentRunAgentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsPublisher publisher = client.listAssessmentRunAgentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentRunAgents(software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentRunAgentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentRunAgentsRequest#builder()}
     * </p>
     *
     * @param listAssessmentRunAgentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentRunAgentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentRunAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunAgents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentRunAgentsPublisher listAssessmentRunAgentsPaginator(
            Consumer<ListAssessmentRunAgentsRequest.Builder> listAssessmentRunAgentsRequest) {
        return listAssessmentRunAgentsPaginator(ListAssessmentRunAgentsRequest.builder()
                .applyMutation(listAssessmentRunAgentsRequest).build());
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     *
     * @param listAssessmentRunsRequest
     * @return A Java Future containing the result of the ListAssessmentRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssessmentRunsResponse> listAssessmentRuns(ListAssessmentRunsRequest listAssessmentRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentRunsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param listAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentRunsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssessmentRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssessmentRunsResponse> listAssessmentRuns(
            Consumer<ListAssessmentRunsRequest.Builder> listAssessmentRunsRequest) {
        return listAssessmentRuns(ListAssessmentRunsRequest.builder().applyMutation(listAssessmentRunsRequest).build());
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     *
     * @return A Java Future containing the result of the ListAssessmentRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssessmentRunsResponse> listAssessmentRuns() {
        return listAssessmentRuns(ListAssessmentRunsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsPublisher publisher = client.listAssessmentRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsPublisher publisher = client.listAssessmentRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentRunsPublisher listAssessmentRunsPaginator() {
        return listAssessmentRunsPaginator(ListAssessmentRunsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsPublisher publisher = client.listAssessmentRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsPublisher publisher = client.listAssessmentRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentRunsPublisher listAssessmentRunsPaginator(ListAssessmentRunsRequest listAssessmentRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsPublisher publisher = client.listAssessmentRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsPublisher publisher = client.listAssessmentRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentRunsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param listAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentRunsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentRunsPublisher listAssessmentRunsPaginator(
            Consumer<ListAssessmentRunsRequest.Builder> listAssessmentRunsRequest) {
        return listAssessmentRunsPaginator(ListAssessmentRunsRequest.builder().applyMutation(listAssessmentRunsRequest).build());
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     *
     * @param listAssessmentTargetsRequest
     * @return A Java Future containing the result of the ListAssessmentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentTargetsResponse> listAssessmentTargets(
            ListAssessmentTargetsRequest listAssessmentTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentTargetsRequest#builder()}
     * </p>
     *
     * @param listAssessmentTargetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentTargetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssessmentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentTargetsResponse> listAssessmentTargets(
            Consumer<ListAssessmentTargetsRequest.Builder> listAssessmentTargetsRequest) {
        return listAssessmentTargets(ListAssessmentTargetsRequest.builder().applyMutation(listAssessmentTargetsRequest).build());
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListAssessmentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentTargetsResponse> listAssessmentTargets() {
        return listAssessmentTargets(ListAssessmentTargetsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsPublisher publisher = client.listAssessmentTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsPublisher publisher = client.listAssessmentTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTargetsPublisher listAssessmentTargetsPaginator() {
        return listAssessmentTargetsPaginator(ListAssessmentTargetsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsPublisher publisher = client.listAssessmentTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsPublisher publisher = client.listAssessmentTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTargetsPublisher listAssessmentTargetsPaginator(
            ListAssessmentTargetsRequest listAssessmentTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsPublisher publisher = client.listAssessmentTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsPublisher publisher = client.listAssessmentTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentTargetsRequest#builder()}
     * </p>
     *
     * @param listAssessmentTargetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentTargetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTargetsPublisher listAssessmentTargetsPaginator(
            Consumer<ListAssessmentTargetsRequest.Builder> listAssessmentTargetsRequest) {
        return listAssessmentTargetsPaginator(ListAssessmentTargetsRequest.builder().applyMutation(listAssessmentTargetsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     *
     * @param listAssessmentTemplatesRequest
     * @return A Java Future containing the result of the ListAssessmentTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentTemplatesResponse> listAssessmentTemplates(
            ListAssessmentTemplatesRequest listAssessmentTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentTemplatesRequest#builder()}
     * </p>
     *
     * @param listAssessmentTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentTemplatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssessmentTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentTemplatesResponse> listAssessmentTemplates(
            Consumer<ListAssessmentTemplatesRequest.Builder> listAssessmentTemplatesRequest) {
        return listAssessmentTemplates(ListAssessmentTemplatesRequest.builder().applyMutation(listAssessmentTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     *
     * @return A Java Future containing the result of the ListAssessmentTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssessmentTemplatesResponse> listAssessmentTemplates() {
        return listAssessmentTemplates(ListAssessmentTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesPublisher publisher = client.listAssessmentTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesPublisher publisher = client.listAssessmentTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTemplatesPublisher listAssessmentTemplatesPaginator() {
        return listAssessmentTemplatesPaginator(ListAssessmentTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesPublisher publisher = client.listAssessmentTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesPublisher publisher = client.listAssessmentTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTemplatesPublisher listAssessmentTemplatesPaginator(
            ListAssessmentTemplatesRequest listAssessmentTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesPublisher publisher = client.listAssessmentTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesPublisher publisher = client.listAssessmentTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentTemplatesRequest#builder()}
     * </p>
     *
     * @param listAssessmentTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListAssessmentTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTemplatesPublisher listAssessmentTemplatesPaginator(
            Consumer<ListAssessmentTemplatesRequest.Builder> listAssessmentTemplatesRequest) {
        return listAssessmentTemplatesPaginator(ListAssessmentTemplatesRequest.builder()
                .applyMutation(listAssessmentTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     *
     * @param listEventSubscriptionsRequest
     * @return A Java Future containing the result of the ListEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventSubscriptionsResponse> listEventSubscriptions(
            ListEventSubscriptionsRequest listEventSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventSubscriptionsResponse> listEventSubscriptions(
            Consumer<ListEventSubscriptionsRequest.Builder> listEventSubscriptionsRequest) {
        return listEventSubscriptions(ListEventSubscriptionsRequest.builder().applyMutation(listEventSubscriptionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventSubscriptionsResponse> listEventSubscriptions() {
        return listEventSubscriptions(ListEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsPublisher publisher = client.listEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsPublisher publisher = client.listEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSubscriptionsPublisher listEventSubscriptionsPaginator() {
        return listEventSubscriptionsPaginator(ListEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsPublisher publisher = client.listEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsPublisher publisher = client.listEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSubscriptionsPublisher listEventSubscriptionsPaginator(
            ListEventSubscriptionsRequest listEventSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsPublisher publisher = client.listEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsPublisher publisher = client.listEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSubscriptionsPublisher listEventSubscriptionsPaginator(
            Consumer<ListEventSubscriptionsRequest.Builder> listEventSubscriptionsRequest) {
        return listEventSubscriptionsPaginator(ListEventSubscriptionsRequest.builder()
                .applyMutation(listEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * List exclusions that are generated by the assessment run.
     * </p>
     *
     * @param listExclusionsRequest
     * @return A Java Future containing the result of the ListExclusions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListExclusions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListExclusions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExclusionsResponse> listExclusions(ListExclusionsRequest listExclusionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List exclusions that are generated by the assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExclusionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExclusionsRequest#builder()}
     * </p>
     *
     * @param listExclusionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExclusionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListExclusions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListExclusions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListExclusions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExclusionsResponse> listExclusions(Consumer<ListExclusionsRequest.Builder> listExclusionsRequest) {
        return listExclusions(ListExclusionsRequest.builder().applyMutation(listExclusionsRequest).build());
    }

    /**
     * <p>
     * List exclusions that are generated by the assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExclusions(software.amazon.awssdk.services.inspector.model.ListExclusionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListExclusionsPublisher publisher = client.listExclusionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListExclusionsPublisher publisher = client.listExclusionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListExclusionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListExclusionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExclusions(software.amazon.awssdk.services.inspector.model.ListExclusionsRequest)} operation.</b>
     * </p>
     *
     * @param listExclusionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListExclusions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListExclusions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExclusionsPublisher listExclusionsPaginator(ListExclusionsRequest listExclusionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List exclusions that are generated by the assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExclusions(software.amazon.awssdk.services.inspector.model.ListExclusionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListExclusionsPublisher publisher = client.listExclusionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListExclusionsPublisher publisher = client.listExclusionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListExclusionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListExclusionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExclusions(software.amazon.awssdk.services.inspector.model.ListExclusionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExclusionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExclusionsRequest#builder()}
     * </p>
     *
     * @param listExclusionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExclusionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListExclusions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListExclusions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExclusionsPublisher listExclusionsPaginator(Consumer<ListExclusionsRequest.Builder> listExclusionsRequest) {
        return listExclusionsPaginator(ListExclusionsRequest.builder().applyMutation(listExclusionsRequest).build());
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     *
     * @param listFindingsRequest
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFindingsResponse> listFindings(Consumer<ListFindingsRequest.Builder> listFindingsRequest) {
        return listFindings(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     *
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFindingsResponse> listFindings() {
        return listFindings(ListFindingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsPublisher listFindingsPaginator() {
        return listFindingsPaginator(ListFindingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listFindingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsPublisher listFindingsPaginator(ListFindingsRequest listFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsPublisher listFindingsPaginator(Consumer<ListFindingsRequest.Builder> listFindingsRequest) {
        return listFindingsPaginator(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     *
     * @param listRulesPackagesRequest
     * @return A Java Future containing the result of the ListRulesPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListRulesPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRulesPackagesResponse> listRulesPackages(ListRulesPackagesRequest listRulesPackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesPackagesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRulesPackagesRequest#builder()}
     * </p>
     *
     * @param listRulesPackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListRulesPackagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRulesPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListRulesPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRulesPackagesResponse> listRulesPackages(
            Consumer<ListRulesPackagesRequest.Builder> listRulesPackagesRequest) {
        return listRulesPackages(ListRulesPackagesRequest.builder().applyMutation(listRulesPackagesRequest).build());
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     *
     * @return A Java Future containing the result of the ListRulesPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListRulesPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRulesPackagesResponse> listRulesPackages() {
        return listRulesPackages(ListRulesPackagesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesPublisher publisher = client.listRulesPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesPublisher publisher = client.listRulesPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListRulesPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRulesPackagesPublisher listRulesPackagesPaginator() {
        return listRulesPackagesPaginator(ListRulesPackagesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesPublisher publisher = client.listRulesPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesPublisher publisher = client.listRulesPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRulesPackagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListRulesPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRulesPackagesPublisher listRulesPackagesPaginator(ListRulesPackagesRequest listRulesPackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesPublisher publisher = client.listRulesPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesPublisher publisher = client.listRulesPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesPackagesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRulesPackagesRequest#builder()}
     * </p>
     *
     * @param listRulesPackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListRulesPackagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListRulesPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRulesPackagesPublisher listRulesPackagesPaginator(
            Consumer<ListRulesPackagesRequest.Builder> listRulesPackagesRequest) {
        return listRulesPackagesPaginator(ListRulesPackagesRequest.builder().applyMutation(listRulesPackagesRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with an assessment template.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with an assessment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     * </p>
     *
     * @param previewAgentsRequest
     * @return A Java Future containing the result of the PreviewAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>InvalidCrossAccountRoleException Amazon Inspector cannot assume the cross-account role that it needs
     *         to list your EC2 instances during the assessment run.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.PreviewAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/PreviewAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PreviewAgentsResponse> previewAgents(PreviewAgentsRequest previewAgentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PreviewAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link PreviewAgentsRequest#builder()}
     * </p>
     *
     * @param previewAgentsRequest
     *        A {@link Consumer} that will call methods on {@link PreviewAgentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PreviewAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>InvalidCrossAccountRoleException Amazon Inspector cannot assume the cross-account role that it needs
     *         to list your EC2 instances during the assessment run.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.PreviewAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/PreviewAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PreviewAgentsResponse> previewAgents(Consumer<PreviewAgentsRequest.Builder> previewAgentsRequest) {
        return previewAgents(PreviewAgentsRequest.builder().applyMutation(previewAgentsRequest).build());
    }

    /**
     * <p>
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #previewAgents(software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.PreviewAgentsPublisher publisher = client.previewAgentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.PreviewAgentsPublisher publisher = client.previewAgentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #previewAgents(software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest)} operation.</b>
     * </p>
     *
     * @param previewAgentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>InvalidCrossAccountRoleException Amazon Inspector cannot assume the cross-account role that it needs
     *         to list your EC2 instances during the assessment run.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.PreviewAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/PreviewAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default PreviewAgentsPublisher previewAgentsPaginator(PreviewAgentsRequest previewAgentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #previewAgents(software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.PreviewAgentsPublisher publisher = client.previewAgentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.PreviewAgentsPublisher publisher = client.previewAgentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #previewAgents(software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link PreviewAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link PreviewAgentsRequest#builder()}
     * </p>
     *
     * @param previewAgentsRequest
     *        A {@link Consumer} that will call methods on {@link PreviewAgentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>InvalidCrossAccountRoleException Amazon Inspector cannot assume the cross-account role that it needs
     *         to list your EC2 instances during the assessment run.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.PreviewAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/PreviewAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default PreviewAgentsPublisher previewAgentsPaginator(Consumer<PreviewAgentsRequest.Builder> previewAgentsRequest) {
        return previewAgentsPaginator(PreviewAgentsRequest.builder().applyMutation(previewAgentsRequest).build());
    }

    /**
     * <p>
     * Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security
     * assessments.
     * </p>
     *
     * @param registerCrossAccountAccessRoleRequest
     * @return A Java Future containing the result of the RegisterCrossAccountAccessRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>InvalidCrossAccountRoleException Amazon Inspector cannot assume the cross-account role that it needs
     *         to list your EC2 instances during the assessment run.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.RegisterCrossAccountAccessRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RegisterCrossAccountAccessRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterCrossAccountAccessRoleResponse> registerCrossAccountAccessRole(
            RegisterCrossAccountAccessRoleRequest registerCrossAccountAccessRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security
     * assessments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterCrossAccountAccessRoleRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterCrossAccountAccessRoleRequest#builder()}
     * </p>
     *
     * @param registerCrossAccountAccessRoleRequest
     *        A {@link Consumer} that will call methods on {@link RegisterCrossAccountAccessRoleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RegisterCrossAccountAccessRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>InvalidCrossAccountRoleException Amazon Inspector cannot assume the cross-account role that it needs
     *         to list your EC2 instances during the assessment run.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.RegisterCrossAccountAccessRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RegisterCrossAccountAccessRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterCrossAccountAccessRoleResponse> registerCrossAccountAccessRole(
            Consumer<RegisterCrossAccountAccessRoleRequest.Builder> registerCrossAccountAccessRoleRequest) {
        return registerCrossAccountAccessRole(RegisterCrossAccountAccessRoleRequest.builder()
                .applyMutation(registerCrossAccountAccessRoleRequest).build());
    }

    /**
     * <p>
     * Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings
     * where an attribute with the specified key exists.
     * </p>
     *
     * @param removeAttributesFromFindingsRequest
     * @return A Java Future containing the result of the RemoveAttributesFromFindings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.RemoveAttributesFromFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RemoveAttributesFromFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAttributesFromFindingsResponse> removeAttributesFromFindings(
            RemoveAttributesFromFindingsRequest removeAttributesFromFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings
     * where an attribute with the specified key exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAttributesFromFindingsRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveAttributesFromFindingsRequest#builder()}
     * </p>
     *
     * @param removeAttributesFromFindingsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveAttributesFromFindingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RemoveAttributesFromFindings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.RemoveAttributesFromFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RemoveAttributesFromFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAttributesFromFindingsResponse> removeAttributesFromFindings(
            Consumer<RemoveAttributesFromFindingsRequest.Builder> removeAttributesFromFindingsRequest) {
        return removeAttributesFromFindings(RemoveAttributesFromFindingsRequest.builder()
                .applyMutation(removeAttributesFromFindingsRequest).build());
    }

    /**
     * <p>
     * Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment
     * template.
     * </p>
     *
     * @param setTagsForResourceRequest
     * @return A Java Future containing the result of the SetTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.SetTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SetTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetTagsForResourceResponse> setTagsForResource(SetTagsForResourceRequest setTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment
     * template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link SetTagsForResourceRequest#builder()}
     * </p>
     *
     * @param setTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link SetTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.SetTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SetTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetTagsForResourceResponse> setTagsForResource(
            Consumer<SetTagsForResourceRequest.Builder> setTagsForResourceRequest) {
        return setTagsForResource(SetTagsForResourceRequest.builder().applyMutation(setTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you
     * must not exceed the limit of running up to 500 concurrent agents per AWS account.
     * </p>
     *
     * @param startAssessmentRunRequest
     * @return A Java Future containing the result of the StartAssessmentRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>InvalidCrossAccountRoleException Amazon Inspector cannot assume the cross-account role that it needs
     *         to list your EC2 instances during the assessment run.</li>
     *         <li>AgentsAlreadyRunningAssessmentException You started an assessment run, but one of the instances is
     *         already participating in another assessment run.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.StartAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StartAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartAssessmentRunResponse> startAssessmentRun(StartAssessmentRunRequest startAssessmentRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you
     * must not exceed the limit of running up to 500 concurrent agents per AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAssessmentRunRequest.Builder} avoiding the
     * need to create one manually via {@link StartAssessmentRunRequest#builder()}
     * </p>
     *
     * @param startAssessmentRunRequest
     *        A {@link Consumer} that will call methods on {@link StartAssessmentRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartAssessmentRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>InvalidCrossAccountRoleException Amazon Inspector cannot assume the cross-account role that it needs
     *         to list your EC2 instances during the assessment run.</li>
     *         <li>AgentsAlreadyRunningAssessmentException You started an assessment run, but one of the instances is
     *         already participating in another assessment run.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.StartAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StartAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartAssessmentRunResponse> startAssessmentRun(
            Consumer<StartAssessmentRunRequest.Builder> startAssessmentRunRequest) {
        return startAssessmentRun(StartAssessmentRunRequest.builder().applyMutation(startAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Stops the assessment run that is specified by the ARN of the assessment run.
     * </p>
     *
     * @param stopAssessmentRunRequest
     * @return A Java Future containing the result of the StopAssessmentRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.StopAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StopAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopAssessmentRunResponse> stopAssessmentRun(StopAssessmentRunRequest stopAssessmentRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the assessment run that is specified by the ARN of the assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopAssessmentRunRequest.Builder} avoiding the need
     * to create one manually via {@link StopAssessmentRunRequest#builder()}
     * </p>
     *
     * @param stopAssessmentRunRequest
     *        A {@link Consumer} that will call methods on {@link StopAssessmentRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopAssessmentRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.StopAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StopAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopAssessmentRunResponse> stopAssessmentRun(
            Consumer<StopAssessmentRunRequest.Builder> stopAssessmentRunRequest) {
        return stopAssessmentRun(StopAssessmentRunRequest.builder().applyMutation(stopAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to
     * a specified SNS topic.
     * </p>
     *
     * @param subscribeToEventRequest
     * @return A Java Future containing the result of the SubscribeToEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.SubscribeToEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SubscribeToEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SubscribeToEventResponse> subscribeToEvent(SubscribeToEventRequest subscribeToEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to
     * a specified SNS topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubscribeToEventRequest.Builder} avoiding the need
     * to create one manually via {@link SubscribeToEventRequest#builder()}
     * </p>
     *
     * @param subscribeToEventRequest
     *        A {@link Consumer} that will call methods on {@link SubscribeToEventRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SubscribeToEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.SubscribeToEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SubscribeToEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SubscribeToEventResponse> subscribeToEvent(
            Consumer<SubscribeToEventRequest.Builder> subscribeToEventRequest) {
        return subscribeToEvent(SubscribeToEventRequest.builder().applyMutation(subscribeToEventRequest).build());
    }

    /**
     * <p>
     * Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to
     * a specified SNS topic.
     * </p>
     *
     * @param unsubscribeFromEventRequest
     * @return A Java Future containing the result of the UnsubscribeFromEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.UnsubscribeFromEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UnsubscribeFromEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnsubscribeFromEventResponse> unsubscribeFromEvent(
            UnsubscribeFromEventRequest unsubscribeFromEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to
     * a specified SNS topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnsubscribeFromEventRequest.Builder} avoiding the
     * need to create one manually via {@link UnsubscribeFromEventRequest#builder()}
     * </p>
     *
     * @param unsubscribeFromEventRequest
     *        A {@link Consumer} that will call methods on {@link UnsubscribeFromEventRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UnsubscribeFromEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.UnsubscribeFromEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UnsubscribeFromEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnsubscribeFromEventResponse> unsubscribeFromEvent(
            Consumer<UnsubscribeFromEventRequest.Builder> unsubscribeFromEventRequest) {
        return unsubscribeFromEvent(UnsubscribeFromEventRequest.builder().applyMutation(unsubscribeFromEventRequest).build());
    }

    /**
     * <p>
     * Updates the assessment target that is specified by the ARN of the assessment target.
     * </p>
     * <p>
     * If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the
     * assessment target.
     * </p>
     *
     * @param updateAssessmentTargetRequest
     * @return A Java Future containing the result of the UpdateAssessmentTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.UpdateAssessmentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UpdateAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentTargetResponse> updateAssessmentTarget(
            UpdateAssessmentTargetRequest updateAssessmentTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the assessment target that is specified by the ARN of the assessment target.
     * </p>
     * <p>
     * If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the
     * assessment target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentTargetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAssessmentTargetRequest#builder()}
     * </p>
     *
     * @param updateAssessmentTargetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssessmentTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAssessmentTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced an entity that does not exist.
     *         The error code describes the entity.</li>
     *         <li>ServiceTemporarilyUnavailableException The serice is temporary unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>InspectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample InspectorAsyncClient.UpdateAssessmentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UpdateAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssessmentTargetResponse> updateAssessmentTarget(
            Consumer<UpdateAssessmentTargetRequest.Builder> updateAssessmentTargetRequest) {
        return updateAssessmentTarget(UpdateAssessmentTargetRequest.builder().applyMutation(updateAssessmentTargetRequest)
                .build());
    }

    @Override
    default InspectorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link InspectorAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static InspectorAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link InspectorAsyncClient}.
     */
    static InspectorAsyncClientBuilder builder() {
        return new DefaultInspectorAsyncClientBuilder();
    }
}
