/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScopeType {
    INSTANCE_ID("INSTANCE_ID"),
    RULES_PACKAGE_ARN("RULES_PACKAGE_ARN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScopeType> VALUE_MAP;
    private final String value;

    private ScopeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScopeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScopeType> knownValues() {
        EnumSet<ScopeType> knownValues = EnumSet.allOf(ScopeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScopeType.class, ScopeType::toString);
    }
}

