/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.StreamFile;
import software.amazon.awssdk.services.iot.model.StreamFilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamInfo> {
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamId").getter(StreamInfo.getter(StreamInfo::streamId)).setter(StreamInfo.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamArn").getter(StreamInfo.getter(StreamInfo::streamArn)).setter(StreamInfo.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamArn").build()}).build();
    private static final SdkField<Integer> STREAM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("streamVersion").getter(StreamInfo.getter(StreamInfo::streamVersion)).setter(StreamInfo.setter(Builder::streamVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(StreamInfo.getter(StreamInfo::description)).setter(StreamInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<StreamFile>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("files").getter(StreamInfo.getter(StreamInfo::files)).setter(StreamInfo.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(StreamInfo.getter(StreamInfo::createdAt)).setter(StreamInfo.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(StreamInfo.getter(StreamInfo::lastUpdatedAt)).setter(StreamInfo.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(StreamInfo.getter(StreamInfo::roleArn)).setter(StreamInfo.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ID_FIELD, STREAM_ARN_FIELD, STREAM_VERSION_FIELD, DESCRIPTION_FIELD, FILES_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StreamInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String streamId;
    private final String streamArn;
    private final Integer streamVersion;
    private final String description;
    private final List<StreamFile> files;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String roleArn;

    private StreamInfo(BuilderImpl builder) {
        this.streamId = builder.streamId;
        this.streamArn = builder.streamArn;
        this.streamVersion = builder.streamVersion;
        this.description = builder.description;
        this.files = builder.files;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.roleArn = builder.roleArn;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final Integer streamVersion() {
        return this.streamVersion;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasFiles() {
        return this.files != null && !(this.files instanceof SdkAutoConstructList);
    }

    public final List<StreamFile> files() {
        return this.files;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiles() ? this.files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamInfo)) {
            return false;
        }
        StreamInfo other = (StreamInfo)obj;
        return Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.streamVersion(), other.streamVersion()) && Objects.equals(this.description(), other.description()) && this.hasFiles() == other.hasFiles() && Objects.equals(this.files(), other.files()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"StreamInfo").add("StreamId", (Object)this.streamId()).add("StreamArn", (Object)this.streamArn()).add("StreamVersion", (Object)this.streamVersion()).add("Description", (Object)this.description()).add("Files", this.hasFiles() ? this.files() : null).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "streamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "streamVersion": {
                return Optional.ofNullable(clazz.cast(this.streamVersion()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("streamId", STREAM_ID_FIELD);
        map.put("streamArn", STREAM_ARN_FIELD);
        map.put("streamVersion", STREAM_VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("files", FILES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamInfo, T> g) {
        return obj -> g.apply((StreamInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamId;
        private String streamArn;
        private Integer streamVersion;
        private String description;
        private List<StreamFile> files = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamInfo model) {
            this.streamId(model.streamId);
            this.streamArn(model.streamArn);
            this.streamVersion(model.streamVersion);
            this.description(model.description);
            this.files(model.files);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.roleArn(model.roleArn);
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final Integer getStreamVersion() {
            return this.streamVersion;
        }

        public final void setStreamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
        }

        @Override
        public final Builder streamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<StreamFile.Builder> getFiles() {
            List<StreamFile.Builder> result = StreamFilesCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<StreamFile.BuilderImpl> files) {
            this.files = StreamFilesCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<StreamFile> files) {
            this.files = StreamFilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(StreamFile ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<StreamFile.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (StreamFile)((StreamFile.Builder)StreamFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public StreamInfo build() {
            return new StreamInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamInfo> {
        public Builder streamId(String var1);

        public Builder streamArn(String var1);

        public Builder streamVersion(Integer var1);

        public Builder description(String var1);

        public Builder files(Collection<StreamFile> var1);

        public Builder files(StreamFile ... var1);

        public Builder files(Consumer<StreamFile.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder roleArn(String var1);
    }
}

