/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reference to a data set entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetEntry implements SdkPojo, Serializable, ToCopyableBuilder<DatasetEntry.Builder, DatasetEntry> {
    private static final SdkField<String> ENTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatasetEntry::entryName)).setter(setter(Builder::entryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryName").build()).build();

    private static final SdkField<String> DATA_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatasetEntry::dataURI)).setter(setter(Builder::dataURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataURI").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_NAME_FIELD,
            DATA_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entryName;

    private final String dataURI;

    private DatasetEntry(BuilderImpl builder) {
        this.entryName = builder.entryName;
        this.dataURI = builder.dataURI;
    }

    /**
     * <p>
     * The name of the data set item.
     * </p>
     * 
     * @return The name of the data set item.
     */
    public String entryName() {
        return entryName;
    }

    /**
     * <p>
     * The pre-signed URI of the data set item.
     * </p>
     * 
     * @return The pre-signed URI of the data set item.
     */
    public String dataURI() {
        return dataURI;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryName());
        hashCode = 31 * hashCode + Objects.hashCode(dataURI());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetEntry)) {
            return false;
        }
        DatasetEntry other = (DatasetEntry) obj;
        return Objects.equals(entryName(), other.entryName()) && Objects.equals(dataURI(), other.dataURI());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DatasetEntry").add("EntryName", entryName()).add("DataURI", dataURI()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryName":
            return Optional.ofNullable(clazz.cast(entryName()));
        case "dataURI":
            return Optional.ofNullable(clazz.cast(dataURI()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetEntry, T> g) {
        return obj -> g.apply((DatasetEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetEntry> {
        /**
         * <p>
         * The name of the data set item.
         * </p>
         * 
         * @param entryName
         *        The name of the data set item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryName(String entryName);

        /**
         * <p>
         * The pre-signed URI of the data set item.
         * </p>
         * 
         * @param dataURI
         *        The pre-signed URI of the data set item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataURI(String dataURI);
    }

    static final class BuilderImpl implements Builder {
        private String entryName;

        private String dataURI;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetEntry model) {
            entryName(model.entryName);
            dataURI(model.dataURI);
        }

        public final String getEntryName() {
            return entryName;
        }

        @Override
        public final Builder entryName(String entryName) {
            this.entryName = entryName;
            return this;
        }

        public final void setEntryName(String entryName) {
            this.entryName = entryName;
        }

        public final String getDataURI() {
            return dataURI;
        }

        @Override
        public final Builder dataURI(String dataURI) {
            this.dataURI = dataURI;
            return this;
        }

        public final void setDataURI(String dataURI) {
            this.dataURI = dataURI;
        }

        @Override
        public DatasetEntry build() {
            return new DatasetEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
