/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The "DatasetTrigger" that specifies when the data set is automatically updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetTrigger implements SdkPojo, Serializable, ToCopyableBuilder<DatasetTrigger.Builder, DatasetTrigger> {
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .getter(getter(DatasetTrigger::schedule)).setter(setter(Builder::schedule)).constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<TriggeringDataset> DATASET_FIELD = SdkField
            .<TriggeringDataset> builder(MarshallingType.SDK_POJO).getter(getter(DatasetTrigger::dataset))
            .setter(setter(Builder::dataset)).constructor(TriggeringDataset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SCHEDULE_FIELD, DATASET_FIELD));

    private static final long serialVersionUID = 1L;

    private final Schedule schedule;

    private final TriggeringDataset dataset;

    private DatasetTrigger(BuilderImpl builder) {
        this.schedule = builder.schedule;
        this.dataset = builder.dataset;
    }

    /**
     * <p>
     * The "Schedule" when the trigger is initiated.
     * </p>
     * 
     * @return The "Schedule" when the trigger is initiated.
     */
    public Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The data set whose content creation triggers the creation of this data set's contents.
     * </p>
     * 
     * @return The data set whose content creation triggers the creation of this data set's contents.
     */
    public TriggeringDataset dataset() {
        return dataset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(dataset());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetTrigger)) {
            return false;
        }
        DatasetTrigger other = (DatasetTrigger) obj;
        return Objects.equals(schedule(), other.schedule()) && Objects.equals(dataset(), other.dataset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DatasetTrigger").add("Schedule", schedule()).add("Dataset", dataset()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "dataset":
            return Optional.ofNullable(clazz.cast(dataset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetTrigger, T> g) {
        return obj -> g.apply((DatasetTrigger) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetTrigger> {
        /**
         * <p>
         * The "Schedule" when the trigger is initiated.
         * </p>
         * 
         * @param schedule
         *        The "Schedule" when the trigger is initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The "Schedule" when the trigger is initiated.
         * </p>
         * This is a convenience that creates an instance of the {@link Schedule.Builder} avoiding the need to create
         * one manually via {@link Schedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The data set whose content creation triggers the creation of this data set's contents.
         * </p>
         * 
         * @param dataset
         *        The data set whose content creation triggers the creation of this data set's contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataset(TriggeringDataset dataset);

        /**
         * <p>
         * The data set whose content creation triggers the creation of this data set's contents.
         * </p>
         * This is a convenience that creates an instance of the {@link TriggeringDataset.Builder} avoiding the need to
         * create one manually via {@link TriggeringDataset#builder()}.
         *
         * When the {@link Consumer} completes, {@link TriggeringDataset.Builder#build()} is called immediately and its
         * result is passed to {@link #dataset(TriggeringDataset)}.
         * 
         * @param dataset
         *        a consumer that will call methods on {@link TriggeringDataset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataset(TriggeringDataset)
         */
        default Builder dataset(Consumer<TriggeringDataset.Builder> dataset) {
            return dataset(TriggeringDataset.builder().applyMutation(dataset).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Schedule schedule;

        private TriggeringDataset dataset;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetTrigger model) {
            schedule(model.schedule);
            dataset(model.dataset);
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final TriggeringDataset.Builder getDataset() {
            return dataset != null ? dataset.toBuilder() : null;
        }

        @Override
        public final Builder dataset(TriggeringDataset dataset) {
            this.dataset = dataset;
            return this;
        }

        public final void setDataset(TriggeringDataset.BuilderImpl dataset) {
            this.dataset = dataset != null ? dataset.build() : null;
        }

        @Override
        public DatasetTrigger build() {
            return new DatasetTrigger(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
