/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDatastoreRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<UpdateDatastoreRequest.Builder, UpdateDatastoreRequest> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDatastoreRequest::datastoreName)).setter(setter(Builder::datastoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreName").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDatastoreRequest::retentionPeriod))
            .setter(setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<DatastoreStorage> DATASTORE_STORAGE_FIELD = SdkField
            .<DatastoreStorage> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDatastoreRequest::datastoreStorage))
            .setter(setter(Builder::datastoreStorage)).constructor(DatastoreStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreStorage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD,
            RETENTION_PERIOD_FIELD, DATASTORE_STORAGE_FIELD));

    private final String datastoreName;

    private final RetentionPeriod retentionPeriod;

    private final DatastoreStorage datastoreStorage;

    private UpdateDatastoreRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreName = builder.datastoreName;
        this.retentionPeriod = builder.retentionPeriod;
        this.datastoreStorage = builder.datastoreStorage;
    }

    /**
     * <p>
     * The name of the data store to be updated.
     * </p>
     * 
     * @return The name of the data store to be updated.
     */
    public String datastoreName() {
        return datastoreName;
    }

    /**
     * <p>
     * How long, in days, message data is kept for the data store. The retention period cannot be updated if the data
     * store's S3 storage is customer-managed.
     * </p>
     * 
     * @return How long, in days, message data is kept for the data store. The retention period cannot be updated if the
     *         data store's S3 storage is customer-managed.
     */
    public RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not
     * specified, the default is "serviceManagedS3". This cannot be changed after the data store is created.
     * </p>
     * 
     * @return Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage.
     *         If not specified, the default is "serviceManagedS3". This cannot be changed after the data store is
     *         created.
     */
    public DatastoreStorage datastoreStorage() {
        return datastoreStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreStorage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatastoreRequest)) {
            return false;
        }
        UpdateDatastoreRequest other = (UpdateDatastoreRequest) obj;
        return Objects.equals(datastoreName(), other.datastoreName())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(datastoreStorage(), other.datastoreStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDatastoreRequest").add("DatastoreName", datastoreName())
                .add("RetentionPeriod", retentionPeriod()).add("DatastoreStorage", datastoreStorage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreName":
            return Optional.ofNullable(clazz.cast(datastoreName()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "datastoreStorage":
            return Optional.ofNullable(clazz.cast(datastoreStorage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatastoreRequest, T> g) {
        return obj -> g.apply((UpdateDatastoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDatastoreRequest> {
        /**
         * <p>
         * The name of the data store to be updated.
         * </p>
         * 
         * @param datastoreName
         *        The name of the data store to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreName(String datastoreName);

        /**
         * <p>
         * How long, in days, message data is kept for the data store. The retention period cannot be updated if the
         * data store's S3 storage is customer-managed.
         * </p>
         * 
         * @param retentionPeriod
         *        How long, in days, message data is kept for the data store. The retention period cannot be updated if
         *        the data store's S3 storage is customer-managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * How long, in days, message data is kept for the data store. The retention period cannot be updated if the
         * data store's S3 storage is customer-managed.
         * </p>
         * This is a convenience that creates an instance of the {@link RetentionPeriod.Builder} avoiding the need to
         * create one manually via {@link RetentionPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If
         * not specified, the default is "serviceManagedS3". This cannot be changed after the data store is created.
         * </p>
         * 
         * @param datastoreStorage
         *        Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3"
         *        storage. If not specified, the default is "serviceManagedS3". This cannot be changed after the data
         *        store is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreStorage(DatastoreStorage datastoreStorage);

        /**
         * <p>
         * Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If
         * not specified, the default is "serviceManagedS3". This cannot be changed after the data store is created.
         * </p>
         * This is a convenience that creates an instance of the {@link DatastoreStorage.Builder} avoiding the need to
         * create one manually via {@link DatastoreStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatastoreStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #datastoreStorage(DatastoreStorage)}.
         * 
         * @param datastoreStorage
         *        a consumer that will call methods on {@link DatastoreStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datastoreStorage(DatastoreStorage)
         */
        default Builder datastoreStorage(Consumer<DatastoreStorage.Builder> datastoreStorage) {
            return datastoreStorage(DatastoreStorage.builder().applyMutation(datastoreStorage).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String datastoreName;

        private RetentionPeriod retentionPeriod;

        private DatastoreStorage datastoreStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatastoreRequest model) {
            super(model);
            datastoreName(model.datastoreName);
            retentionPeriod(model.retentionPeriod);
            datastoreStorage(model.datastoreStorage);
        }

        public final String getDatastoreName() {
            return datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        public final DatastoreStorage.Builder getDatastoreStorage() {
            return datastoreStorage != null ? datastoreStorage.toBuilder() : null;
        }

        @Override
        public final Builder datastoreStorage(DatastoreStorage datastoreStorage) {
            this.datastoreStorage = datastoreStorage;
            return this;
        }

        public final void setDatastoreStorage(DatastoreStorage.BuilderImpl datastoreStorage) {
            this.datastoreStorage = datastoreStorage != null ? datastoreStorage.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatastoreRequest build() {
            return new UpdateDatastoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
