/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.iotevents.model.CreateDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.CreateDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.CreateInputRequest;
import software.amazon.awssdk.services.iotevents.model.CreateInputResponse;
import software.amazon.awssdk.services.iotevents.model.DeleteDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.DeleteDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.DeleteInputRequest;
import software.amazon.awssdk.services.iotevents.model.DeleteInputResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeInputRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeInputResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeLoggingOptionsRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeLoggingOptionsResponse;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelVersionsRequest;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelVersionsResponse;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelsRequest;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelsResponse;
import software.amazon.awssdk.services.iotevents.model.ListInputsRequest;
import software.amazon.awssdk.services.iotevents.model.ListInputsResponse;
import software.amazon.awssdk.services.iotevents.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotevents.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotevents.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotevents.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotevents.model.TagResourceRequest;
import software.amazon.awssdk.services.iotevents.model.TagResourceResponse;
import software.amazon.awssdk.services.iotevents.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotevents.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotevents.model.UpdateDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.UpdateDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.UpdateInputRequest;
import software.amazon.awssdk.services.iotevents.model.UpdateInputResponse;

/**
 * Service client for accessing AWS IoT Events asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * AWS IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions
 * when such events occur. AWS IoT Events API commands enable you to create, read, update and delete inputs and detector
 * models, and to list their versions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface IotEventsAsyncClient extends SdkClient {
    String SERVICE_NAME = "iotevents";

    /**
     * Create a {@link IotEventsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotEventsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotEventsAsyncClient}.
     */
    static IotEventsAsyncClientBuilder builder() {
        return new DefaultIotEventsAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a detector model.
     * </p>
     *
     * @param createDetectorModelRequest
     * @return A Java Future containing the result of the CreateDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.CreateDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDetectorModelResponse> createDetectorModel(
            CreateDetectorModelRequest createDetectorModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a detector model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDetectorModelRequest#builder()}
     * </p>
     *
     * @param createDetectorModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateDetectorModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.CreateDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDetectorModelResponse> createDetectorModel(
            Consumer<CreateDetectorModelRequest.Builder> createDetectorModelRequest) {
        return createDetectorModel(CreateDetectorModelRequest.builder().applyMutation(createDetectorModelRequest).build());
    }

    /**
     * <p>
     * Creates an input.
     * </p>
     *
     * @param createInputRequest
     * @return A Java Future containing the result of the CreateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.CreateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInputResponse> createInput(CreateInputRequest createInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInputRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInputRequest#builder()}
     * </p>
     *
     * @param createInputRequest
     *        A {@link Consumer} that will call methods on {@link CreateInputRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.CreateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInputResponse> createInput(Consumer<CreateInputRequest.Builder> createInputRequest) {
        return createInput(CreateInputRequest.builder().applyMutation(createInputRequest).build());
    }

    /**
     * <p>
     * Deletes a detector model. Any active instances of the detector model are also deleted.
     * </p>
     *
     * @param deleteDetectorModelRequest
     * @return A Java Future containing the result of the DeleteDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DeleteDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDetectorModelResponse> deleteDetectorModel(
            DeleteDetectorModelRequest deleteDetectorModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a detector model. Any active instances of the detector model are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDetectorModelRequest#builder()}
     * </p>
     *
     * @param deleteDetectorModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDetectorModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DeleteDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDetectorModelResponse> deleteDetectorModel(
            Consumer<DeleteDetectorModelRequest.Builder> deleteDetectorModelRequest) {
        return deleteDetectorModel(DeleteDetectorModelRequest.builder().applyMutation(deleteDetectorModelRequest).build());
    }

    /**
     * <p>
     * Deletes an input.
     * </p>
     *
     * @param deleteInputRequest
     * @return A Java Future containing the result of the DeleteInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DeleteInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInputResponse> deleteInput(DeleteInputRequest deleteInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInputRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInputRequest#builder()}
     * </p>
     *
     * @param deleteInputRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInputRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DeleteInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInputResponse> deleteInput(Consumer<DeleteInputRequest.Builder> deleteInputRequest) {
        return deleteInput(DeleteInputRequest.builder().applyMutation(deleteInputRequest).build());
    }

    /**
     * <p>
     * Describes a detector model. If the <code>"version"</code> parameter is not specified, information about the
     * latest version is returned.
     * </p>
     *
     * @param describeDetectorModelRequest
     * @return A Java Future containing the result of the DescribeDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeDetectorModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorModelResponse> describeDetectorModel(
            DescribeDetectorModelRequest describeDetectorModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a detector model. If the <code>"version"</code> parameter is not specified, information about the
     * latest version is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDetectorModelRequest#builder()}
     * </p>
     *
     * @param describeDetectorModelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDetectorModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeDetectorModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorModelResponse> describeDetectorModel(
            Consumer<DescribeDetectorModelRequest.Builder> describeDetectorModelRequest) {
        return describeDetectorModel(DescribeDetectorModelRequest.builder().applyMutation(describeDetectorModelRequest).build());
    }

    /**
     * <p>
     * Describes an input.
     * </p>
     *
     * @param describeInputRequest
     * @return A Java Future containing the result of the DescribeInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeInputResponse> describeInput(DescribeInputRequest describeInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeInputRequest#builder()}
     * </p>
     *
     * @param describeInputRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInputRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeInputResponse> describeInput(Consumer<DescribeInputRequest.Builder> describeInputRequest) {
        return describeInput(DescribeInputRequest.builder().applyMutation(describeInputRequest).build());
    }

    /**
     * <p>
     * Retrieves the current settings of the AWS IoT Events logging options.
     * </p>
     *
     * @param describeLoggingOptionsRequest
     * @return A Java Future containing the result of the DescribeLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeLoggingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingOptionsResponse> describeLoggingOptions(
            DescribeLoggingOptionsRequest describeLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current settings of the AWS IoT Events logging options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param describeLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLoggingOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeLoggingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingOptionsResponse> describeLoggingOptions(
            Consumer<DescribeLoggingOptionsRequest.Builder> describeLoggingOptionsRequest) {
        return describeLoggingOptions(DescribeLoggingOptionsRequest.builder().applyMutation(describeLoggingOptionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the versions of a detector model. Only the metadata associated with each detector model version is
     * returned.
     * </p>
     *
     * @param listDetectorModelVersionsRequest
     * @return A Java Future containing the result of the ListDetectorModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListDetectorModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDetectorModelVersionsResponse> listDetectorModelVersions(
            ListDetectorModelVersionsRequest listDetectorModelVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of a detector model. Only the metadata associated with each detector model version is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorModelVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDetectorModelVersionsRequest#builder()}
     * </p>
     *
     * @param listDetectorModelVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDetectorModelVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDetectorModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListDetectorModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDetectorModelVersionsResponse> listDetectorModelVersions(
            Consumer<ListDetectorModelVersionsRequest.Builder> listDetectorModelVersionsRequest) {
        return listDetectorModelVersions(ListDetectorModelVersionsRequest.builder()
                .applyMutation(listDetectorModelVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
     * </p>
     *
     * @param listDetectorModelsRequest
     * @return A Java Future containing the result of the ListDetectorModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListDetectorModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDetectorModelsResponse> listDetectorModels(ListDetectorModelsRequest listDetectorModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDetectorModelsRequest#builder()}
     * </p>
     *
     * @param listDetectorModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListDetectorModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDetectorModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListDetectorModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDetectorModelsResponse> listDetectorModels(
            Consumer<ListDetectorModelsRequest.Builder> listDetectorModelsRequest) {
        return listDetectorModels(ListDetectorModelsRequest.builder().applyMutation(listDetectorModelsRequest).build());
    }

    /**
     * <p>
     * Lists the inputs you have created.
     * </p>
     *
     * @param listInputsRequest
     * @return A Java Future containing the result of the ListInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputsResponse> listInputs(ListInputsRequest listInputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the inputs you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInputsRequest#builder()}
     * </p>
     *
     * @param listInputsRequest
     *        A {@link Consumer} that will call methods on {@link ListInputsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputsResponse> listInputs(Consumer<ListInputsRequest.Builder> listInputsRequest) {
        return listInputs(ListInputsRequest.builder().applyMutation(listInputsRequest).build());
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sets or updates the AWS IoT Events logging options.
     * </p>
     * <p>
     * If you update the value of any <code>"loggingOptions"</code> field, it takes up to one minute for the change to
     * take effect. Also, if you change the policy attached to the role you specified in the <code>"roleArn"</code>
     * field (for example, to correct an invalid policy) it takes up to five minutes for that change to take effect.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.PutLoggingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets or updates the AWS IoT Events logging options.
     * </p>
     * <p>
     * If you update the value of any <code>"loggingOptions"</code> field, it takes up to one minute for the change to
     * take effect. Also, if you change the policy attached to the role you specified in the <code>"roleArn"</code>
     * field (for example, to correct an invalid policy) it takes up to five minutes for that change to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link PutLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param putLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link PutLoggingOptionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.PutLoggingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(
            Consumer<PutLoggingOptionsRequest.Builder> putLoggingOptionsRequest) {
        return putLoggingOptions(PutLoggingOptionsRequest.builder().applyMutation(putLoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created
     * as new inputs arrive.
     * </p>
     *
     * @param updateDetectorModelRequest
     * @return A Java Future containing the result of the UpdateDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UpdateDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorModelResponse> updateDetectorModel(
            UpdateDetectorModelRequest updateDetectorModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created
     * as new inputs arrive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDetectorModelRequest#builder()}
     * </p>
     *
     * @param updateDetectorModelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UpdateDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorModelResponse> updateDetectorModel(
            Consumer<UpdateDetectorModelRequest.Builder> updateDetectorModelRequest) {
        return updateDetectorModel(UpdateDetectorModelRequest.builder().applyMutation(updateDetectorModelRequest).build());
    }

    /**
     * <p>
     * Updates an input.
     * </p>
     *
     * @param updateInputRequest
     * @return A Java Future containing the result of the UpdateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UpdateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInputResponse> updateInput(UpdateInputRequest updateInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInputRequest#builder()}
     * </p>
     *
     * @param updateInputRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInputRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UpdateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInputResponse> updateInput(Consumer<UpdateInputRequest.Builder> updateInputRequest) {
        return updateInput(UpdateInputRequest.builder().applyMutation(updateInputRequest).build());
    }
}
