/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iotevents.model.CreateDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.CreateDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.CreateInputRequest;
import software.amazon.awssdk.services.iotevents.model.CreateInputResponse;
import software.amazon.awssdk.services.iotevents.model.DeleteDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.DeleteDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.DeleteInputRequest;
import software.amazon.awssdk.services.iotevents.model.DeleteInputResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeInputRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeInputResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeLoggingOptionsRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeLoggingOptionsResponse;
import software.amazon.awssdk.services.iotevents.model.InternalFailureException;
import software.amazon.awssdk.services.iotevents.model.InvalidRequestException;
import software.amazon.awssdk.services.iotevents.model.IotEventsException;
import software.amazon.awssdk.services.iotevents.model.LimitExceededException;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelVersionsRequest;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelVersionsResponse;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelsRequest;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelsResponse;
import software.amazon.awssdk.services.iotevents.model.ListInputsRequest;
import software.amazon.awssdk.services.iotevents.model.ListInputsResponse;
import software.amazon.awssdk.services.iotevents.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotevents.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotevents.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotevents.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotevents.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotevents.model.ResourceInUseException;
import software.amazon.awssdk.services.iotevents.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotevents.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iotevents.model.TagResourceRequest;
import software.amazon.awssdk.services.iotevents.model.TagResourceResponse;
import software.amazon.awssdk.services.iotevents.model.ThrottlingException;
import software.amazon.awssdk.services.iotevents.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotevents.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotevents.model.UpdateDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.UpdateDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.UpdateInputRequest;
import software.amazon.awssdk.services.iotevents.model.UpdateInputResponse;

/**
 * Service client for accessing AWS IoT Events. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions
 * when such events occur. AWS IoT Events API commands enable you to create, read, update and delete inputs and detector
 * models, and to list their versions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface IotEventsClient extends SdkClient {
    String SERVICE_NAME = "iotevents";

    /**
     * Create a {@link IotEventsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotEventsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotEventsClient}.
     */
    static IotEventsClientBuilder builder() {
        return new DefaultIotEventsClientBuilder();
    }

    /**
     * <p>
     * Creates a detector model.
     * </p>
     *
     * @param createDetectorModelRequest
     * @return Result of the CreateDetectorModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.CreateDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDetectorModelResponse createDetectorModel(CreateDetectorModelRequest createDetectorModelRequest)
            throws InvalidRequestException, ResourceInUseException, ResourceAlreadyExistsException, LimitExceededException,
            ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a detector model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDetectorModelRequest#builder()}
     * </p>
     *
     * @param createDetectorModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateDetectorModelRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDetectorModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.CreateDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDetectorModelResponse createDetectorModel(
            Consumer<CreateDetectorModelRequest.Builder> createDetectorModelRequest) throws InvalidRequestException,
            ResourceInUseException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException,
            InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        return createDetectorModel(CreateDetectorModelRequest.builder().applyMutation(createDetectorModelRequest).build());
    }

    /**
     * <p>
     * Creates an input.
     * </p>
     *
     * @param createInputRequest
     * @return Result of the CreateInput operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.CreateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInputResponse createInput(CreateInputRequest createInputRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ServiceUnavailableException, ResourceAlreadyExistsException,
            AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInputRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInputRequest#builder()}
     * </p>
     *
     * @param createInputRequest
     *        A {@link Consumer} that will call methods on {@link CreateInputRequest.Builder} to create a request.
     * @return Result of the CreateInput operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.CreateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInputResponse createInput(Consumer<CreateInputRequest.Builder> createInputRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            ResourceAlreadyExistsException, AwsServiceException, SdkClientException, IotEventsException {
        return createInput(CreateInputRequest.builder().applyMutation(createInputRequest).build());
    }

    /**
     * <p>
     * Deletes a detector model. Any active instances of the detector model are also deleted.
     * </p>
     *
     * @param deleteDetectorModelRequest
     * @return Result of the DeleteDetectorModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.DeleteDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDetectorModelResponse deleteDetectorModel(DeleteDetectorModelRequest deleteDetectorModelRequest)
            throws InvalidRequestException, ResourceInUseException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a detector model. Any active instances of the detector model are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDetectorModelRequest#builder()}
     * </p>
     *
     * @param deleteDetectorModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDetectorModelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDetectorModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.DeleteDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDetectorModelResponse deleteDetectorModel(
            Consumer<DeleteDetectorModelRequest.Builder> deleteDetectorModelRequest) throws InvalidRequestException,
            ResourceInUseException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        return deleteDetectorModel(DeleteDetectorModelRequest.builder().applyMutation(deleteDetectorModelRequest).build());
    }

    /**
     * <p>
     * Deletes an input.
     * </p>
     *
     * @param deleteInputRequest
     * @return Result of the DeleteInput operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.DeleteInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInputResponse deleteInput(DeleteInputRequest deleteInputRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            ResourceInUseException, AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInputRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInputRequest#builder()}
     * </p>
     *
     * @param deleteInputRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInputRequest.Builder} to create a request.
     * @return Result of the DeleteInput operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.DeleteInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInputResponse deleteInput(Consumer<DeleteInputRequest.Builder> deleteInputRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, ResourceInUseException, AwsServiceException, SdkClientException, IotEventsException {
        return deleteInput(DeleteInputRequest.builder().applyMutation(deleteInputRequest).build());
    }

    /**
     * <p>
     * Describes a detector model. If the <code>"version"</code> parameter is not specified, information about the
     * latest version is returned.
     * </p>
     *
     * @param describeDetectorModelRequest
     * @return Result of the DescribeDetectorModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.DescribeDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeDetectorModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDetectorModelResponse describeDetectorModel(DescribeDetectorModelRequest describeDetectorModelRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a detector model. If the <code>"version"</code> parameter is not specified, information about the
     * latest version is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDetectorModelRequest#builder()}
     * </p>
     *
     * @param describeDetectorModelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDetectorModelRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDetectorModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.DescribeDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeDetectorModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDetectorModelResponse describeDetectorModel(
            Consumer<DescribeDetectorModelRequest.Builder> describeDetectorModelRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotEventsException {
        return describeDetectorModel(DescribeDetectorModelRequest.builder().applyMutation(describeDetectorModelRequest).build());
    }

    /**
     * <p>
     * Describes an input.
     * </p>
     *
     * @param describeInputRequest
     * @return Result of the DescribeInput operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.DescribeInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeInputResponse describeInput(DescribeInputRequest describeInputRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeInputRequest#builder()}
     * </p>
     *
     * @param describeInputRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInputRequest.Builder} to create a request.
     * @return Result of the DescribeInput operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.DescribeInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeInputResponse describeInput(Consumer<DescribeInputRequest.Builder> describeInputRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        return describeInput(DescribeInputRequest.builder().applyMutation(describeInputRequest).build());
    }

    /**
     * <p>
     * Retrieves the current settings of the AWS IoT Events logging options.
     * </p>
     *
     * @param describeLoggingOptionsRequest
     * @return Result of the DescribeLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws UnsupportedOperationException
     *         The requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.DescribeLoggingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoggingOptionsResponse describeLoggingOptions(DescribeLoggingOptionsRequest describeLoggingOptionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            ServiceUnavailableException, software.amazon.awssdk.services.iotevents.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current settings of the AWS IoT Events logging options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param describeLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLoggingOptionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws UnsupportedOperationException
     *         The requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.DescribeLoggingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoggingOptionsResponse describeLoggingOptions(
            Consumer<DescribeLoggingOptionsRequest.Builder> describeLoggingOptionsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, ServiceUnavailableException,
            software.amazon.awssdk.services.iotevents.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, IotEventsException {
        return describeLoggingOptions(DescribeLoggingOptionsRequest.builder().applyMutation(describeLoggingOptionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the versions of a detector model. Only the metadata associated with each detector model version is
     * returned.
     * </p>
     *
     * @param listDetectorModelVersionsRequest
     * @return Result of the ListDetectorModelVersions operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.ListDetectorModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDetectorModelVersionsResponse listDetectorModelVersions(
            ListDetectorModelVersionsRequest listDetectorModelVersionsRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of a detector model. Only the metadata associated with each detector model version is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorModelVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDetectorModelVersionsRequest#builder()}
     * </p>
     *
     * @param listDetectorModelVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDetectorModelVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDetectorModelVersions operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.ListDetectorModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDetectorModelVersionsResponse listDetectorModelVersions(
            Consumer<ListDetectorModelVersionsRequest.Builder> listDetectorModelVersionsRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotEventsException {
        return listDetectorModelVersions(ListDetectorModelVersionsRequest.builder()
                .applyMutation(listDetectorModelVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
     * </p>
     *
     * @param listDetectorModelsRequest
     * @return Result of the ListDetectorModels operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.ListDetectorModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDetectorModelsResponse listDetectorModels(ListDetectorModelsRequest listDetectorModelsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDetectorModelsRequest#builder()}
     * </p>
     *
     * @param listDetectorModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListDetectorModelsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDetectorModels operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.ListDetectorModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDetectorModelsResponse listDetectorModels(Consumer<ListDetectorModelsRequest.Builder> listDetectorModelsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotEventsException {
        return listDetectorModels(ListDetectorModelsRequest.builder().applyMutation(listDetectorModelsRequest).build());
    }

    /**
     * <p>
     * Lists the inputs you have created.
     * </p>
     *
     * @param listInputsRequest
     * @return Result of the ListInputs operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsResponse listInputs(ListInputsRequest listInputsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the inputs you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInputsRequest#builder()}
     * </p>
     *
     * @param listInputsRequest
     *        A {@link Consumer} that will call methods on {@link ListInputsRequest.Builder} to create a request.
     * @return Result of the ListInputs operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsResponse listInputs(Consumer<ListInputsRequest.Builder> listInputsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotEventsException {
        return listInputs(ListInputsRequest.builder().applyMutation(listInputsRequest).build());
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            ResourceNotFoundException, ResourceInUseException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotEventsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sets or updates the AWS IoT Events logging options.
     * </p>
     * <p>
     * If you update the value of any <code>"loggingOptions"</code> field, it takes up to one minute for the change to
     * take effect. Also, if you change the policy attached to the role you specified in the <code>"roleArn"</code>
     * field (for example, to correct an invalid policy) it takes up to five minutes for that change to take effect.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return Result of the PutLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws UnsupportedOperationException
     *         The requested operation is not supported.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.PutLoggingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default PutLoggingOptionsResponse putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            software.amazon.awssdk.services.iotevents.model.UnsupportedOperationException, ResourceInUseException,
            AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets or updates the AWS IoT Events logging options.
     * </p>
     * <p>
     * If you update the value of any <code>"loggingOptions"</code> field, it takes up to one minute for the change to
     * take effect. Also, if you change the policy attached to the role you specified in the <code>"roleArn"</code>
     * field (for example, to correct an invalid policy) it takes up to five minutes for that change to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link PutLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param putLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link PutLoggingOptionsRequest.Builder} to create a request.
     * @return Result of the PutLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws UnsupportedOperationException
     *         The requested operation is not supported.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.PutLoggingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default PutLoggingOptionsResponse putLoggingOptions(Consumer<PutLoggingOptionsRequest.Builder> putLoggingOptionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            software.amazon.awssdk.services.iotevents.model.UnsupportedOperationException, ResourceInUseException,
            AwsServiceException, SdkClientException, IotEventsException {
        return putLoggingOptions(PutLoggingOptionsRequest.builder().applyMutation(putLoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            ResourceNotFoundException, ResourceInUseException, ThrottlingException, LimitExceededException,
            InternalFailureException, AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, IotEventsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException,
            ResourceNotFoundException, ResourceInUseException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotEventsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created
     * as new inputs arrive.
     * </p>
     *
     * @param updateDetectorModelRequest
     * @return Result of the UpdateDetectorModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.UpdateDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDetectorModelResponse updateDetectorModel(UpdateDetectorModelRequest updateDetectorModelRequest)
            throws InvalidRequestException, ResourceInUseException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created
     * as new inputs arrive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDetectorModelRequest#builder()}
     * </p>
     *
     * @param updateDetectorModelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorModelRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDetectorModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.UpdateDetectorModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDetectorModelResponse updateDetectorModel(
            Consumer<UpdateDetectorModelRequest.Builder> updateDetectorModelRequest) throws InvalidRequestException,
            ResourceInUseException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        return updateDetectorModel(UpdateDetectorModelRequest.builder().applyMutation(updateDetectorModelRequest).build());
    }

    /**
     * <p>
     * Updates an input.
     * </p>
     *
     * @param updateInputRequest
     * @return Result of the UpdateInput operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.UpdateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateInputResponse updateInput(UpdateInputRequest updateInputRequest) throws InvalidRequestException,
            ThrottlingException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException,
            ResourceInUseException, AwsServiceException, SdkClientException, IotEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInputRequest#builder()}
     * </p>
     *
     * @param updateInputRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInputRequest.Builder} to create a request.
     * @return Result of the UpdateInput operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ResourceInUseException
     *         The resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsClient.UpdateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateInputResponse updateInput(Consumer<UpdateInputRequest.Builder> updateInputRequest)
            throws InvalidRequestException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            ServiceUnavailableException, ResourceInUseException, AwsServiceException, SdkClientException, IotEventsException {
        return updateInput(UpdateInputRequest.builder().applyMutation(updateInputRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("iotevents");
    }
}
