/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInputResponse extends IotEventsResponse implements
        ToCopyableBuilder<CreateInputResponse.Builder, CreateInputResponse> {
    private static final SdkField<InputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField
            .<InputConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(CreateInputResponse::inputConfiguration))
            .setter(setter(Builder::inputConfiguration)).constructor(InputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_CONFIGURATION_FIELD));

    private final InputConfiguration inputConfiguration;

    private CreateInputResponse(BuilderImpl builder) {
        super(builder);
        this.inputConfiguration = builder.inputConfiguration;
    }

    /**
     * <p>
     * Information about the configuration of the input.
     * </p>
     * 
     * @return Information about the configuration of the input.
     */
    public InputConfiguration inputConfiguration() {
        return inputConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInputResponse)) {
            return false;
        }
        CreateInputResponse other = (CreateInputResponse) obj;
        return Objects.equals(inputConfiguration(), other.inputConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateInputResponse").add("InputConfiguration", inputConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputConfiguration":
            return Optional.ofNullable(clazz.cast(inputConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInputResponse, T> g) {
        return obj -> g.apply((CreateInputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateInputResponse> {
        /**
         * <p>
         * Information about the configuration of the input.
         * </p>
         * 
         * @param inputConfiguration
         *        Information about the configuration of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfiguration(InputConfiguration inputConfiguration);

        /**
         * <p>
         * Information about the configuration of the input.
         * </p>
         * This is a convenience that creates an instance of the {@link InputConfiguration.Builder} avoiding the need to
         * create one manually via {@link InputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #inputConfiguration(InputConfiguration)}.
         * 
         * @param inputConfiguration
         *        a consumer that will call methods on {@link InputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfiguration(InputConfiguration)
         */
        default Builder inputConfiguration(Consumer<InputConfiguration.Builder> inputConfiguration) {
            return inputConfiguration(InputConfiguration.builder().applyMutation(inputConfiguration).build());
        }
    }

    static final class BuilderImpl extends IotEventsResponse.BuilderImpl implements Builder {
        private InputConfiguration inputConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInputResponse model) {
            super(model);
            inputConfiguration(model.inputConfiguration);
        }

        public final InputConfiguration.Builder getInputConfiguration() {
            return inputConfiguration != null ? inputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputConfiguration(InputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final void setInputConfiguration(InputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        @Override
        public CreateInputResponse build() {
            return new CreateInputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
