/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDetectorModelRequest extends IotEventsRequest implements
        ToCopyableBuilder<DescribeDetectorModelRequest.Builder, DescribeDetectorModelRequest> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDetectorModelRequest::detectorModelName)).setter(setter(Builder::detectorModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorModelName").build()).build();

    private static final SdkField<String> DETECTOR_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDetectorModelRequest::detectorModelVersion)).setter(setter(Builder::detectorModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD,
            DETECTOR_MODEL_VERSION_FIELD));

    private final String detectorModelName;

    private final String detectorModelVersion;

    private DescribeDetectorModelRequest(BuilderImpl builder) {
        super(builder);
        this.detectorModelName = builder.detectorModelName;
        this.detectorModelVersion = builder.detectorModelVersion;
    }

    /**
     * <p>
     * The name of the detector model.
     * </p>
     * 
     * @return The name of the detector model.
     */
    public String detectorModelName() {
        return detectorModelName;
    }

    /**
     * <p>
     * The version of the detector model.
     * </p>
     * 
     * @return The version of the detector model.
     */
    public String detectorModelVersion() {
        return detectorModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDetectorModelRequest)) {
            return false;
        }
        DescribeDetectorModelRequest other = (DescribeDetectorModelRequest) obj;
        return Objects.equals(detectorModelName(), other.detectorModelName())
                && Objects.equals(detectorModelVersion(), other.detectorModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDetectorModelRequest").add("DetectorModelName", detectorModelName())
                .add("DetectorModelVersion", detectorModelVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModelName":
            return Optional.ofNullable(clazz.cast(detectorModelName()));
        case "detectorModelVersion":
            return Optional.ofNullable(clazz.cast(detectorModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDetectorModelRequest, T> g) {
        return obj -> g.apply((DescribeDetectorModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDetectorModelRequest> {
        /**
         * <p>
         * The name of the detector model.
         * </p>
         * 
         * @param detectorModelName
         *        The name of the detector model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelName(String detectorModelName);

        /**
         * <p>
         * The version of the detector model.
         * </p>
         * 
         * @param detectorModelVersion
         *        The version of the detector model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelVersion(String detectorModelVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsRequest.BuilderImpl implements Builder {
        private String detectorModelName;

        private String detectorModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDetectorModelRequest model) {
            super(model);
            detectorModelName(model.detectorModelName);
            detectorModelVersion(model.detectorModelVersion);
        }

        public final String getDetectorModelName() {
            return detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        public final String getDetectorModelVersion() {
            return detectorModelVersion;
        }

        @Override
        public final Builder detectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
            return this;
        }

        public final void setDetectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDetectorModelRequest build() {
            return new DescribeDetectorModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
