/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detector model and the specific detectors (instances) for which the logging level is given.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectorDebugOption implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectorDebugOption.Builder, DetectorDebugOption> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DetectorDebugOption::detectorModelName)).setter(setter(Builder::detectorModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()).build();

    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DetectorDebugOption::keyValue)).setter(setter(Builder::keyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD,
            KEY_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detectorModelName;

    private final String keyValue;

    private DetectorDebugOption(BuilderImpl builder) {
        this.detectorModelName = builder.detectorModelName;
        this.keyValue = builder.keyValue;
    }

    /**
     * <p>
     * The name of the detector model.
     * </p>
     * 
     * @return The name of the detector model.
     */
    public String detectorModelName() {
        return detectorModelName;
    }

    /**
     * <p>
     * The value of the input attribute key used to create the detector (the instance of the detector model).
     * </p>
     * 
     * @return The value of the input attribute key used to create the detector (the instance of the detector model).
     */
    public String keyValue() {
        return keyValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(keyValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorDebugOption)) {
            return false;
        }
        DetectorDebugOption other = (DetectorDebugOption) obj;
        return Objects.equals(detectorModelName(), other.detectorModelName()) && Objects.equals(keyValue(), other.keyValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectorDebugOption").add("DetectorModelName", detectorModelName()).add("KeyValue", keyValue())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModelName":
            return Optional.ofNullable(clazz.cast(detectorModelName()));
        case "keyValue":
            return Optional.ofNullable(clazz.cast(keyValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorDebugOption, T> g) {
        return obj -> g.apply((DetectorDebugOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectorDebugOption> {
        /**
         * <p>
         * The name of the detector model.
         * </p>
         * 
         * @param detectorModelName
         *        The name of the detector model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelName(String detectorModelName);

        /**
         * <p>
         * The value of the input attribute key used to create the detector (the instance of the detector model).
         * </p>
         * 
         * @param keyValue
         *        The value of the input attribute key used to create the detector (the instance of the detector model).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValue(String keyValue);
    }

    static final class BuilderImpl implements Builder {
        private String detectorModelName;

        private String keyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorDebugOption model) {
            detectorModelName(model.detectorModelName);
            keyValue(model.keyValue);
        }

        public final String getDetectorModelName() {
            return detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        public final String getKeyValue() {
            return keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public DetectorDebugOption build() {
            return new DetectorDebugOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
