/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information that defines how a detector operates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectorModelDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectorModelDefinition.Builder, DetectorModelDefinition> {
    private static final SdkField<List<State>> STATES_FIELD = SdkField
            .<List<State>> builder(MarshallingType.LIST)
            .getter(getter(DetectorModelDefinition::states))
            .setter(setter(Builder::states))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("states").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<State> builder(MarshallingType.SDK_POJO)
                                            .constructor(State::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INITIAL_STATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DetectorModelDefinition::initialStateName)).setter(setter(Builder::initialStateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialStateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATES_FIELD,
            INITIAL_STATE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<State> states;

    private final String initialStateName;

    private DetectorModelDefinition(BuilderImpl builder) {
        this.states = builder.states;
        this.initialStateName = builder.initialStateName;
    }

    /**
     * Returns true if the States property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStates() {
        return states != null && !(states instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the states of the detector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the states of the detector.
     */
    public List<State> states() {
        return states;
    }

    /**
     * <p>
     * The state that is entered at the creation of each detector (instance).
     * </p>
     * 
     * @return The state that is entered at the creation of each detector (instance).
     */
    public String initialStateName() {
        return initialStateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(states());
        hashCode = 31 * hashCode + Objects.hashCode(initialStateName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorModelDefinition)) {
            return false;
        }
        DetectorModelDefinition other = (DetectorModelDefinition) obj;
        return Objects.equals(states(), other.states()) && Objects.equals(initialStateName(), other.initialStateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectorModelDefinition").add("States", states()).add("InitialStateName", initialStateName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "states":
            return Optional.ofNullable(clazz.cast(states()));
        case "initialStateName":
            return Optional.ofNullable(clazz.cast(initialStateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorModelDefinition, T> g) {
        return obj -> g.apply((DetectorModelDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectorModelDefinition> {
        /**
         * <p>
         * Information about the states of the detector.
         * </p>
         * 
         * @param states
         *        Information about the states of the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<State> states);

        /**
         * <p>
         * Information about the states of the detector.
         * </p>
         * 
         * @param states
         *        Information about the states of the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(State... states);

        /**
         * <p>
         * Information about the states of the detector.
         * </p>
         * This is a convenience that creates an instance of the {@link List<State>.Builder} avoiding the need to create
         * one manually via {@link List<State>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<State>.Builder#build()} is called immediately and its result
         * is passed to {@link #states(List<State>)}.
         * 
         * @param states
         *        a consumer that will call methods on {@link List<State>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #states(List<State>)
         */
        Builder states(Consumer<State.Builder>... states);

        /**
         * <p>
         * The state that is entered at the creation of each detector (instance).
         * </p>
         * 
         * @param initialStateName
         *        The state that is entered at the creation of each detector (instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialStateName(String initialStateName);
    }

    static final class BuilderImpl implements Builder {
        private List<State> states = DefaultSdkAutoConstructList.getInstance();

        private String initialStateName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorModelDefinition model) {
            states(model.states);
            initialStateName(model.initialStateName);
        }

        public final Collection<State.Builder> getStates() {
            return states != null ? states.stream().map(State::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder states(Collection<State> states) {
            this.states = StatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(State... states) {
            states(Arrays.asList(states));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(Consumer<State.Builder>... states) {
            states(Stream.of(states).map(c -> State.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStates(Collection<State.BuilderImpl> states) {
            this.states = StatesCopier.copyFromBuilder(states);
        }

        public final String getInitialStateName() {
            return initialStateName;
        }

        @Override
        public final Builder initialStateName(String initialStateName) {
            this.initialStateName = initialStateName;
            return this;
        }

        public final void setInitialStateName(String initialStateName) {
            this.initialStateName = initialStateName;
        }

        @Override
        public DetectorModelDefinition build() {
            return new DetectorModelDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
