/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the <code>"actions"</code> to be performed when the <code>"condition"</code> evaluates to TRUE.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Event implements SdkPojo, Serializable, ToCopyableBuilder<Event.Builder, Event> {
    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Event::eventName)).setter(setter(Builder::eventName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventName").build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Event::condition)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .getter(getter(Event::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_NAME_FIELD,
            CONDITION_FIELD, ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventName;

    private final String condition;

    private final List<Action> actions;

    private Event(BuilderImpl builder) {
        this.eventName = builder.eventName;
        this.condition = builder.condition;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The name of the event.
     * </p>
     * 
     * @return The name of the event.
     */
    public String eventName() {
        return eventName;
    }

    /**
     * <p>
     * [Optional] The Boolean expression that when TRUE causes the <code>"actions"</code> to be performed. If not
     * present, the actions are performed (=TRUE); if the expression result is not a Boolean value, the actions are NOT
     * performed (=FALSE).
     * </p>
     * 
     * @return [Optional] The Boolean expression that when TRUE causes the <code>"actions"</code> to be performed. If
     *         not present, the actions are performed (=TRUE); if the expression result is not a Boolean value, the
     *         actions are NOT performed (=FALSE).
     */
    public String condition() {
        return condition;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to be performed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions to be performed.
     */
    public List<Action> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventName());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event) obj;
        return Objects.equals(eventName(), other.eventName()) && Objects.equals(condition(), other.condition())
                && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Event").add("EventName", eventName()).add("Condition", condition()).add("Actions", actions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventName":
            return Optional.ofNullable(clazz.cast(eventName()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Event> {
        /**
         * <p>
         * The name of the event.
         * </p>
         * 
         * @param eventName
         *        The name of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventName(String eventName);

        /**
         * <p>
         * [Optional] The Boolean expression that when TRUE causes the <code>"actions"</code> to be performed. If not
         * present, the actions are performed (=TRUE); if the expression result is not a Boolean value, the actions are
         * NOT performed (=FALSE).
         * </p>
         * 
         * @param condition
         *        [Optional] The Boolean expression that when TRUE causes the <code>"actions"</code> to be performed. If
         *        not present, the actions are performed (=TRUE); if the expression result is not a Boolean value, the
         *        actions are NOT performed (=FALSE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(String condition);

        /**
         * <p>
         * The actions to be performed.
         * </p>
         * 
         * @param actions
         *        The actions to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions to be performed.
         * </p>
         * 
         * @param actions
         *        The actions to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions to be performed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Action>.Builder} avoiding the need to
         * create one manually via {@link List<Action>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Action>.Builder#build()} is called immediately and its
         * result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<Action>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);
    }

    static final class BuilderImpl implements Builder {
        private String eventName;

        private String condition;

        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            eventName(model.eventName);
            condition(model.condition);
            actions(model.actions);
        }

        public final String getEventName() {
            return eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public final String getCondition() {
            return condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        public final Collection<Action.Builder> getActions() {
            return actions != null ? actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsCopier.copyFromBuilder(actions);
        }

        @Override
        public Event build() {
            return new Event(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
