/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sends information about the detector model instance and the event which triggered the action to a Kinesis Data
 * Firehose delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirehoseAction implements SdkPojo, Serializable, ToCopyableBuilder<FirehoseAction.Builder, FirehoseAction> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FirehoseAction::deliveryStreamName)).setter(setter(Builder::deliveryStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryStreamName").build())
            .build();

    private static final SdkField<String> SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FirehoseAction::separator)).setter(setter(Builder::separator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("separator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD,
            SEPARATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deliveryStreamName;

    private final String separator;

    private FirehoseAction(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.separator = builder.separator;
    }

    /**
     * <p>
     * The name of the Kinesis Data Firehose delivery stream where the data is written.
     * </p>
     * 
     * @return The name of the Kinesis Data Firehose delivery stream where the data is written.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream.
     * Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     * </p>
     * 
     * @return A character separator that is used to separate records written to the Kinesis Data Firehose delivery
     *         stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     */
    public String separator() {
        return separator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(separator());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirehoseAction)) {
            return false;
        }
        FirehoseAction other = (FirehoseAction) obj;
        return Objects.equals(deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(separator(), other.separator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FirehoseAction").add("DeliveryStreamName", deliveryStreamName()).add("Separator", separator())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deliveryStreamName":
            return Optional.ofNullable(clazz.cast(deliveryStreamName()));
        case "separator":
            return Optional.ofNullable(clazz.cast(separator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirehoseAction, T> g) {
        return obj -> g.apply((FirehoseAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirehoseAction> {
        /**
         * <p>
         * The name of the Kinesis Data Firehose delivery stream where the data is written.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the Kinesis Data Firehose delivery stream where the data is written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream.
         * Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         * </p>
         * 
         * @param separator
         *        A character separator that is used to separate records written to the Kinesis Data Firehose delivery
         *        stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder separator(String separator);
    }

    static final class BuilderImpl implements Builder {
        private String deliveryStreamName;

        private String separator;

        private BuilderImpl() {
        }

        private BuilderImpl(FirehoseAction model) {
            deliveryStreamName(model.deliveryStreamName);
            separator(model.separator);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getSeparator() {
            return separator;
        }

        @Override
        public final Builder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public final void setSeparator(String separator) {
            this.separator = separator;
        }

        @Override
        public FirehoseAction build() {
            return new FirehoseAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
