/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information required to publish the MQTT message via the AWS IoT message broker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotTopicPublishAction implements SdkPojo, Serializable,
        ToCopyableBuilder<IotTopicPublishAction.Builder, IotTopicPublishAction> {
    private static final SdkField<String> MQTT_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IotTopicPublishAction::mqttTopic)).setter(setter(Builder::mqttTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mqttTopic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MQTT_TOPIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mqttTopic;

    private IotTopicPublishAction(BuilderImpl builder) {
        this.mqttTopic = builder.mqttTopic;
    }

    /**
     * <p>
     * The MQTT topic of the message.
     * </p>
     * 
     * @return The MQTT topic of the message.
     */
    public String mqttTopic() {
        return mqttTopic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mqttTopic());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotTopicPublishAction)) {
            return false;
        }
        IotTopicPublishAction other = (IotTopicPublishAction) obj;
        return Objects.equals(mqttTopic(), other.mqttTopic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IotTopicPublishAction").add("MqttTopic", mqttTopic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mqttTopic":
            return Optional.ofNullable(clazz.cast(mqttTopic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotTopicPublishAction, T> g) {
        return obj -> g.apply((IotTopicPublishAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotTopicPublishAction> {
        /**
         * <p>
         * The MQTT topic of the message.
         * </p>
         * 
         * @param mqttTopic
         *        The MQTT topic of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mqttTopic(String mqttTopic);
    }

    static final class BuilderImpl implements Builder {
        private String mqttTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(IotTopicPublishAction model) {
            mqttTopic(model.mqttTopic);
        }

        public final String getMqttTopic() {
            return mqttTopic;
        }

        @Override
        public final Builder mqttTopic(String mqttTopic) {
            this.mqttTopic = mqttTopic;
            return this;
        }

        public final void setMqttTopic(String mqttTopic) {
            this.mqttTopic = mqttTopic;
        }

        @Override
        public IotTopicPublishAction build() {
            return new IotTopicPublishAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
