/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDetectorModelVersionsResponse extends IotEventsResponse implements
        ToCopyableBuilder<ListDetectorModelVersionsResponse.Builder, ListDetectorModelVersionsResponse> {
    private static final SdkField<List<DetectorModelVersionSummary>> DETECTOR_MODEL_VERSION_SUMMARIES_FIELD = SdkField
            .<List<DetectorModelVersionSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListDetectorModelVersionsResponse::detectorModelVersionSummaries))
            .setter(setter(Builder::detectorModelVersionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelVersionSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetectorModelVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetectorModelVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDetectorModelVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DETECTOR_MODEL_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<DetectorModelVersionSummary> detectorModelVersionSummaries;

    private final String nextToken;

    private ListDetectorModelVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.detectorModelVersionSummaries = builder.detectorModelVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DetectorModelVersionSummaries property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasDetectorModelVersionSummaries() {
        return detectorModelVersionSummaries != null && !(detectorModelVersionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the detector model versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetectorModelVersionSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summary information about the detector model versions.
     */
    public List<DetectorModelVersionSummary> detectorModelVersionSummaries() {
        return detectorModelVersionSummaries;
    }

    /**
     * <p>
     * A token to retrieve the next set of results, or <code>null</code> if there are no additional results.
     * </p>
     * 
     * @return A token to retrieve the next set of results, or <code>null</code> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelVersionSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDetectorModelVersionsResponse)) {
            return false;
        }
        ListDetectorModelVersionsResponse other = (ListDetectorModelVersionsResponse) obj;
        return Objects.equals(detectorModelVersionSummaries(), other.detectorModelVersionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDetectorModelVersionsResponse")
                .add("DetectorModelVersionSummaries", detectorModelVersionSummaries()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModelVersionSummaries":
            return Optional.ofNullable(clazz.cast(detectorModelVersionSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDetectorModelVersionsResponse, T> g) {
        return obj -> g.apply((ListDetectorModelVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDetectorModelVersionsResponse> {
        /**
         * <p>
         * Summary information about the detector model versions.
         * </p>
         * 
         * @param detectorModelVersionSummaries
         *        Summary information about the detector model versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelVersionSummaries(Collection<DetectorModelVersionSummary> detectorModelVersionSummaries);

        /**
         * <p>
         * Summary information about the detector model versions.
         * </p>
         * 
         * @param detectorModelVersionSummaries
         *        Summary information about the detector model versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelVersionSummaries(DetectorModelVersionSummary... detectorModelVersionSummaries);

        /**
         * <p>
         * Summary information about the detector model versions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DetectorModelVersionSummary>.Builder}
         * avoiding the need to create one manually via {@link List<DetectorModelVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DetectorModelVersionSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #detectorModelVersionSummaries(List<DetectorModelVersionSummary>)}.
         * 
         * @param detectorModelVersionSummaries
         *        a consumer that will call methods on {@link List<DetectorModelVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectorModelVersionSummaries(List<DetectorModelVersionSummary>)
         */
        Builder detectorModelVersionSummaries(Consumer<DetectorModelVersionSummary.Builder>... detectorModelVersionSummaries);

        /**
         * <p>
         * A token to retrieve the next set of results, or <code>null</code> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        A token to retrieve the next set of results, or <code>null</code> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotEventsResponse.BuilderImpl implements Builder {
        private List<DetectorModelVersionSummary> detectorModelVersionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDetectorModelVersionsResponse model) {
            super(model);
            detectorModelVersionSummaries(model.detectorModelVersionSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<DetectorModelVersionSummary.Builder> getDetectorModelVersionSummaries() {
            return detectorModelVersionSummaries != null ? detectorModelVersionSummaries.stream()
                    .map(DetectorModelVersionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder detectorModelVersionSummaries(Collection<DetectorModelVersionSummary> detectorModelVersionSummaries) {
            this.detectorModelVersionSummaries = DetectorModelVersionSummariesCopier.copy(detectorModelVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorModelVersionSummaries(DetectorModelVersionSummary... detectorModelVersionSummaries) {
            detectorModelVersionSummaries(Arrays.asList(detectorModelVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorModelVersionSummaries(
                Consumer<DetectorModelVersionSummary.Builder>... detectorModelVersionSummaries) {
            detectorModelVersionSummaries(Stream.of(detectorModelVersionSummaries)
                    .map(c -> DetectorModelVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetectorModelVersionSummaries(
                Collection<DetectorModelVersionSummary.BuilderImpl> detectorModelVersionSummaries) {
            this.detectorModelVersionSummaries = DetectorModelVersionSummariesCopier
                    .copyFromBuilder(detectorModelVersionSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDetectorModelVersionsResponse build() {
            return new ListDetectorModelVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
