/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDetectorModelsResponse extends IotEventsResponse implements
        ToCopyableBuilder<ListDetectorModelsResponse.Builder, ListDetectorModelsResponse> {
    private static final SdkField<List<DetectorModelSummary>> DETECTOR_MODEL_SUMMARIES_FIELD = SdkField
            .<List<DetectorModelSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListDetectorModelsResponse::detectorModelSummaries))
            .setter(setter(Builder::detectorModelSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetectorModelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetectorModelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDetectorModelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DETECTOR_MODEL_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<DetectorModelSummary> detectorModelSummaries;

    private final String nextToken;

    private ListDetectorModelsResponse(BuilderImpl builder) {
        super(builder);
        this.detectorModelSummaries = builder.detectorModelSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DetectorModelSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDetectorModelSummaries() {
        return detectorModelSummaries != null && !(detectorModelSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the detector models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetectorModelSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summary information about the detector models.
     */
    public List<DetectorModelSummary> detectorModelSummaries() {
        return detectorModelSummaries;
    }

    /**
     * <p>
     * A token to retrieve the next set of results, or <code>null</code> if there are no additional results.
     * </p>
     * 
     * @return A token to retrieve the next set of results, or <code>null</code> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDetectorModelsResponse)) {
            return false;
        }
        ListDetectorModelsResponse other = (ListDetectorModelsResponse) obj;
        return Objects.equals(detectorModelSummaries(), other.detectorModelSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDetectorModelsResponse").add("DetectorModelSummaries", detectorModelSummaries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModelSummaries":
            return Optional.ofNullable(clazz.cast(detectorModelSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDetectorModelsResponse, T> g) {
        return obj -> g.apply((ListDetectorModelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDetectorModelsResponse> {
        /**
         * <p>
         * Summary information about the detector models.
         * </p>
         * 
         * @param detectorModelSummaries
         *        Summary information about the detector models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelSummaries(Collection<DetectorModelSummary> detectorModelSummaries);

        /**
         * <p>
         * Summary information about the detector models.
         * </p>
         * 
         * @param detectorModelSummaries
         *        Summary information about the detector models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelSummaries(DetectorModelSummary... detectorModelSummaries);

        /**
         * <p>
         * Summary information about the detector models.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DetectorModelSummary>.Builder} avoiding the
         * need to create one manually via {@link List<DetectorModelSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DetectorModelSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #detectorModelSummaries(List<DetectorModelSummary>)}.
         * 
         * @param detectorModelSummaries
         *        a consumer that will call methods on {@link List<DetectorModelSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectorModelSummaries(List<DetectorModelSummary>)
         */
        Builder detectorModelSummaries(Consumer<DetectorModelSummary.Builder>... detectorModelSummaries);

        /**
         * <p>
         * A token to retrieve the next set of results, or <code>null</code> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        A token to retrieve the next set of results, or <code>null</code> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotEventsResponse.BuilderImpl implements Builder {
        private List<DetectorModelSummary> detectorModelSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDetectorModelsResponse model) {
            super(model);
            detectorModelSummaries(model.detectorModelSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<DetectorModelSummary.Builder> getDetectorModelSummaries() {
            return detectorModelSummaries != null ? detectorModelSummaries.stream().map(DetectorModelSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder detectorModelSummaries(Collection<DetectorModelSummary> detectorModelSummaries) {
            this.detectorModelSummaries = DetectorModelSummariesCopier.copy(detectorModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorModelSummaries(DetectorModelSummary... detectorModelSummaries) {
            detectorModelSummaries(Arrays.asList(detectorModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorModelSummaries(Consumer<DetectorModelSummary.Builder>... detectorModelSummaries) {
            detectorModelSummaries(Stream.of(detectorModelSummaries)
                    .map(c -> DetectorModelSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetectorModelSummaries(Collection<DetectorModelSummary.BuilderImpl> detectorModelSummaries) {
            this.detectorModelSummaries = DetectorModelSummariesCopier.copyFromBuilder(detectorModelSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDetectorModelsResponse build() {
            return new ListDetectorModelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
