/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The values of the AWS IoT Events logging options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingOptions implements SdkPojo, Serializable, ToCopyableBuilder<LoggingOptions.Builder, LoggingOptions> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoggingOptions::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoggingOptions::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(LoggingOptions::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<List<DetectorDebugOption>> DETECTOR_DEBUG_OPTIONS_FIELD = SdkField
            .<List<DetectorDebugOption>> builder(MarshallingType.LIST)
            .getter(getter(LoggingOptions::detectorDebugOptions))
            .setter(setter(Builder::detectorDebugOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorDebugOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetectorDebugOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetectorDebugOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, LEVEL_FIELD,
            ENABLED_FIELD, DETECTOR_DEBUG_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String level;

    private final Boolean enabled;

    private final List<DetectorDebugOption> detectorDebugOptions;

    private LoggingOptions(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.level = builder.level;
        this.enabled = builder.enabled;
        this.detectorDebugOptions = builder.detectorDebugOptions;
    }

    /**
     * <p>
     * The ARN of the role that grants permission to AWS IoT Events to perform logging.
     * </p>
     * 
     * @return The ARN of the role that grants permission to AWS IoT Events to perform logging.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The logging level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link LoggingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The logging level.
     * @see LoggingLevel
     */
    public LoggingLevel level() {
        return LoggingLevel.fromValue(level);
    }

    /**
     * <p>
     * The logging level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link LoggingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The logging level.
     * @see LoggingLevel
     */
    public String levelAsString() {
        return level;
    }

    /**
     * <p>
     * If TRUE, logging is enabled for AWS IoT Events.
     * </p>
     * 
     * @return If TRUE, logging is enabled for AWS IoT Events.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * Returns true if the DetectorDebugOptions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDetectorDebugOptions() {
        return detectorDebugOptions != null && !(detectorDebugOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information that identifies those detector models and their detectors (instances) for which the logging level is
     * given.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetectorDebugOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information that identifies those detector models and their detectors (instances) for which the logging
     *         level is given.
     */
    public List<DetectorDebugOption> detectorDebugOptions() {
        return detectorDebugOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(detectorDebugOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingOptions)) {
            return false;
        }
        LoggingOptions other = (LoggingOptions) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(levelAsString(), other.levelAsString())
                && Objects.equals(enabled(), other.enabled())
                && Objects.equals(detectorDebugOptions(), other.detectorDebugOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LoggingOptions").add("RoleArn", roleArn()).add("Level", levelAsString())
                .add("Enabled", enabled()).add("DetectorDebugOptions", detectorDebugOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "detectorDebugOptions":
            return Optional.ofNullable(clazz.cast(detectorDebugOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingOptions, T> g) {
        return obj -> g.apply((LoggingOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingOptions> {
        /**
         * <p>
         * The ARN of the role that grants permission to AWS IoT Events to perform logging.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants permission to AWS IoT Events to perform logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The logging level.
         * </p>
         * 
         * @param level
         *        The logging level.
         * @see LoggingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggingLevel
         */
        Builder level(String level);

        /**
         * <p>
         * The logging level.
         * </p>
         * 
         * @param level
         *        The logging level.
         * @see LoggingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggingLevel
         */
        Builder level(LoggingLevel level);

        /**
         * <p>
         * If TRUE, logging is enabled for AWS IoT Events.
         * </p>
         * 
         * @param enabled
         *        If TRUE, logging is enabled for AWS IoT Events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Information that identifies those detector models and their detectors (instances) for which the logging level
         * is given.
         * </p>
         * 
         * @param detectorDebugOptions
         *        Information that identifies those detector models and their detectors (instances) for which the
         *        logging level is given.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorDebugOptions(Collection<DetectorDebugOption> detectorDebugOptions);

        /**
         * <p>
         * Information that identifies those detector models and their detectors (instances) for which the logging level
         * is given.
         * </p>
         * 
         * @param detectorDebugOptions
         *        Information that identifies those detector models and their detectors (instances) for which the
         *        logging level is given.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorDebugOptions(DetectorDebugOption... detectorDebugOptions);

        /**
         * <p>
         * Information that identifies those detector models and their detectors (instances) for which the logging level
         * is given.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DetectorDebugOption>.Builder} avoiding the
         * need to create one manually via {@link List<DetectorDebugOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DetectorDebugOption>.Builder#build()} is called immediately
         * and its result is passed to {@link #detectorDebugOptions(List<DetectorDebugOption>)}.
         * 
         * @param detectorDebugOptions
         *        a consumer that will call methods on {@link List<DetectorDebugOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectorDebugOptions(List<DetectorDebugOption>)
         */
        Builder detectorDebugOptions(Consumer<DetectorDebugOption.Builder>... detectorDebugOptions);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String level;

        private Boolean enabled;

        private List<DetectorDebugOption> detectorDebugOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingOptions model) {
            roleArn(model.roleArn);
            level(model.level);
            enabled(model.enabled);
            detectorDebugOptions(model.detectorDebugOptions);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLevelAsString() {
            return level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(LoggingLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<DetectorDebugOption.Builder> getDetectorDebugOptions() {
            return detectorDebugOptions != null ? detectorDebugOptions.stream().map(DetectorDebugOption::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder detectorDebugOptions(Collection<DetectorDebugOption> detectorDebugOptions) {
            this.detectorDebugOptions = DetectorDebugOptionsCopier.copy(detectorDebugOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorDebugOptions(DetectorDebugOption... detectorDebugOptions) {
            detectorDebugOptions(Arrays.asList(detectorDebugOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorDebugOptions(Consumer<DetectorDebugOption.Builder>... detectorDebugOptions) {
            detectorDebugOptions(Stream.of(detectorDebugOptions).map(c -> DetectorDebugOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDetectorDebugOptions(Collection<DetectorDebugOption.BuilderImpl> detectorDebugOptions) {
            this.detectorDebugOptions = DetectorDebugOptionsCopier.copyFromBuilder(detectorDebugOptions);
        }

        @Override
        public LoggingOptions build() {
            return new LoggingOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
