/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the actions performed when the <code>"condition"</code> evaluates to TRUE.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnInputLifecycle implements SdkPojo, Serializable,
        ToCopyableBuilder<OnInputLifecycle.Builder, OnInputLifecycle> {
    private static final SdkField<List<Event>> EVENTS_FIELD = SdkField
            .<List<Event>> builder(MarshallingType.LIST)
            .getter(getter(OnInputLifecycle::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Event> builder(MarshallingType.SDK_POJO)
                                            .constructor(Event::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TransitionEvent>> TRANSITION_EVENTS_FIELD = SdkField
            .<List<TransitionEvent>> builder(MarshallingType.LIST)
            .getter(getter(OnInputLifecycle::transitionEvents))
            .setter(setter(Builder::transitionEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitionEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransitionEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransitionEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD,
            TRANSITION_EVENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Event> events;

    private final List<TransitionEvent> transitionEvents;

    private OnInputLifecycle(BuilderImpl builder) {
        this.events = builder.events;
        this.transitionEvents = builder.transitionEvents;
    }

    /**
     * Returns true if the Events property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the actions performed when the <code>"condition"</code> evaluates to TRUE.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the actions performed when the <code>"condition"</code> evaluates to TRUE.
     */
    public List<Event> events() {
        return events;
    }

    /**
     * Returns true if the TransitionEvents property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTransitionEvents() {
        return transitionEvents != null && !(transitionEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the actions performed, and the next state entered, when a <code>"condition"</code> evaluates to TRUE.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTransitionEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the actions performed, and the next state entered, when a <code>"condition"</code> evaluates to
     *         TRUE.
     */
    public List<TransitionEvent> transitionEvents() {
        return transitionEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(events());
        hashCode = 31 * hashCode + Objects.hashCode(transitionEvents());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnInputLifecycle)) {
            return false;
        }
        OnInputLifecycle other = (OnInputLifecycle) obj;
        return Objects.equals(events(), other.events()) && Objects.equals(transitionEvents(), other.transitionEvents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OnInputLifecycle").add("Events", events()).add("TransitionEvents", transitionEvents()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "transitionEvents":
            return Optional.ofNullable(clazz.cast(transitionEvents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnInputLifecycle, T> g) {
        return obj -> g.apply((OnInputLifecycle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnInputLifecycle> {
        /**
         * <p>
         * Specifies the actions performed when the <code>"condition"</code> evaluates to TRUE.
         * </p>
         * 
         * @param events
         *        Specifies the actions performed when the <code>"condition"</code> evaluates to TRUE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<Event> events);

        /**
         * <p>
         * Specifies the actions performed when the <code>"condition"</code> evaluates to TRUE.
         * </p>
         * 
         * @param events
         *        Specifies the actions performed when the <code>"condition"</code> evaluates to TRUE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Event... events);

        /**
         * <p>
         * Specifies the actions performed when the <code>"condition"</code> evaluates to TRUE.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Event>.Builder} avoiding the need to create
         * one manually via {@link List<Event>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Event>.Builder#build()} is called immediately and its result
         * is passed to {@link #events(List<Event>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<Event>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<Event>)
         */
        Builder events(Consumer<Event.Builder>... events);

        /**
         * <p>
         * Specifies the actions performed, and the next state entered, when a <code>"condition"</code> evaluates to
         * TRUE.
         * </p>
         * 
         * @param transitionEvents
         *        Specifies the actions performed, and the next state entered, when a <code>"condition"</code> evaluates
         *        to TRUE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitionEvents(Collection<TransitionEvent> transitionEvents);

        /**
         * <p>
         * Specifies the actions performed, and the next state entered, when a <code>"condition"</code> evaluates to
         * TRUE.
         * </p>
         * 
         * @param transitionEvents
         *        Specifies the actions performed, and the next state entered, when a <code>"condition"</code> evaluates
         *        to TRUE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitionEvents(TransitionEvent... transitionEvents);

        /**
         * <p>
         * Specifies the actions performed, and the next state entered, when a <code>"condition"</code> evaluates to
         * TRUE.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TransitionEvent>.Builder} avoiding the need
         * to create one manually via {@link List<TransitionEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TransitionEvent>.Builder#build()} is called immediately and
         * its result is passed to {@link #transitionEvents(List<TransitionEvent>)}.
         * 
         * @param transitionEvents
         *        a consumer that will call methods on {@link List<TransitionEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitionEvents(List<TransitionEvent>)
         */
        Builder transitionEvents(Consumer<TransitionEvent.Builder>... transitionEvents);
    }

    static final class BuilderImpl implements Builder {
        private List<Event> events = DefaultSdkAutoConstructList.getInstance();

        private List<TransitionEvent> transitionEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OnInputLifecycle model) {
            events(model.events);
            transitionEvents(model.transitionEvents);
        }

        public final Collection<Event.Builder> getEvents() {
            return events != null ? events.stream().map(Event::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<Event.Builder>... events) {
            events(Stream.of(events).map(c -> Event.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<Event.BuilderImpl> events) {
            this.events = EventsCopier.copyFromBuilder(events);
        }

        public final Collection<TransitionEvent.Builder> getTransitionEvents() {
            return transitionEvents != null ? transitionEvents.stream().map(TransitionEvent::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transitionEvents(Collection<TransitionEvent> transitionEvents) {
            this.transitionEvents = TransitionEventsCopier.copy(transitionEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitionEvents(TransitionEvent... transitionEvents) {
            transitionEvents(Arrays.asList(transitionEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitionEvents(Consumer<TransitionEvent.Builder>... transitionEvents) {
            transitionEvents(Stream.of(transitionEvents).map(c -> TransitionEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTransitionEvents(Collection<TransitionEvent.BuilderImpl> transitionEvents) {
            this.transitionEvents = TransitionEventsCopier.copyFromBuilder(transitionEvents);
        }

        @Override
        public OnInputLifecycle build() {
            return new OnInputLifecycle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
