/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information needed to set the timer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetTimerAction implements SdkPojo, Serializable, ToCopyableBuilder<SetTimerAction.Builder, SetTimerAction> {
    private static final SdkField<String> TIMER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetTimerAction::timerName)).setter(setter(Builder::timerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timerName").build()).build();

    private static final SdkField<Integer> SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SetTimerAction::seconds)).setter(setter(Builder::seconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMER_NAME_FIELD,
            SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timerName;

    private final Integer seconds;

    private SetTimerAction(BuilderImpl builder) {
        this.timerName = builder.timerName;
        this.seconds = builder.seconds;
    }

    /**
     * <p>
     * The name of the timer.
     * </p>
     * 
     * @return The name of the timer.
     */
    public String timerName() {
        return timerName;
    }

    /**
     * <p>
     * The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy.
     * </p>
     * 
     * @return The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy.
     */
    public Integer seconds() {
        return seconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timerName());
        hashCode = 31 * hashCode + Objects.hashCode(seconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTimerAction)) {
            return false;
        }
        SetTimerAction other = (SetTimerAction) obj;
        return Objects.equals(timerName(), other.timerName()) && Objects.equals(seconds(), other.seconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetTimerAction").add("TimerName", timerName()).add("Seconds", seconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timerName":
            return Optional.ofNullable(clazz.cast(timerName()));
        case "seconds":
            return Optional.ofNullable(clazz.cast(seconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetTimerAction, T> g) {
        return obj -> g.apply((SetTimerAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SetTimerAction> {
        /**
         * <p>
         * The name of the timer.
         * </p>
         * 
         * @param timerName
         *        The name of the timer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerName(String timerName);

        /**
         * <p>
         * The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy.
         * </p>
         * 
         * @param seconds
         *        The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seconds(Integer seconds);
    }

    static final class BuilderImpl implements Builder {
        private String timerName;

        private Integer seconds;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTimerAction model) {
            timerName(model.timerName);
            seconds(model.seconds);
        }

        public final String getTimerName() {
            return timerName;
        }

        @Override
        public final Builder timerName(String timerName) {
            this.timerName = timerName;
            return this;
        }

        public final void setTimerName(String timerName) {
            this.timerName = timerName;
        }

        public final Integer getSeconds() {
            return seconds;
        }

        @Override
        public final Builder seconds(Integer seconds) {
            this.seconds = seconds;
            return this;
        }

        public final void setSeconds(Integer seconds) {
            this.seconds = seconds;
        }

        @Override
        public SetTimerAction build() {
            return new SetTimerAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
