/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the variable and its new value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetVariableAction implements SdkPojo, Serializable,
        ToCopyableBuilder<SetVariableAction.Builder, SetVariableAction> {
    private static final SdkField<String> VARIABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetVariableAction::variableName)).setter(setter(Builder::variableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableName").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetVariableAction::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLE_NAME_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String variableName;

    private final String value;

    private SetVariableAction(BuilderImpl builder) {
        this.variableName = builder.variableName;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the variable.
     * </p>
     * 
     * @return The name of the variable.
     */
    public String variableName() {
        return variableName;
    }

    /**
     * <p>
     * The new value of the variable.
     * </p>
     * 
     * @return The new value of the variable.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(variableName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetVariableAction)) {
            return false;
        }
        SetVariableAction other = (SetVariableAction) obj;
        return Objects.equals(variableName(), other.variableName()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetVariableAction").add("VariableName", variableName()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "variableName":
            return Optional.ofNullable(clazz.cast(variableName()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetVariableAction, T> g) {
        return obj -> g.apply((SetVariableAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SetVariableAction> {
        /**
         * <p>
         * The name of the variable.
         * </p>
         * 
         * @param variableName
         *        The name of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableName(String variableName);

        /**
         * <p>
         * The new value of the variable.
         * </p>
         * 
         * @param value
         *        The new value of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String variableName;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(SetVariableAction model) {
            variableName(model.variableName);
            value(model.value);
        }

        public final String getVariableName() {
            return variableName;
        }

        @Override
        public final Builder variableName(String variableName) {
            this.variableName = variableName;
            return this;
        }

        public final void setVariableName(String variableName) {
            this.variableName = variableName;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public SetVariableAction build() {
            return new SetVariableAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
