/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDetectorModelRequest extends IotEventsRequest implements
        ToCopyableBuilder<UpdateDetectorModelRequest.Builder, UpdateDetectorModelRequest> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDetectorModelRequest::detectorModelName)).setter(setter(Builder::detectorModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorModelName").build()).build();

    private static final SdkField<DetectorModelDefinition> DETECTOR_MODEL_DEFINITION_FIELD = SdkField
            .<DetectorModelDefinition> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDetectorModelRequest::detectorModelDefinition)).setter(setter(Builder::detectorModelDefinition))
            .constructor(DetectorModelDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelDefinition").build())
            .build();

    private static final SdkField<String> DETECTOR_MODEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDetectorModelRequest::detectorModelDescription))
            .setter(setter(Builder::detectorModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelDescription").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDetectorModelRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> EVALUATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDetectorModelRequest::evaluationMethodAsString)).setter(setter(Builder::evaluationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD,
            DETECTOR_MODEL_DEFINITION_FIELD, DETECTOR_MODEL_DESCRIPTION_FIELD, ROLE_ARN_FIELD, EVALUATION_METHOD_FIELD));

    private final String detectorModelName;

    private final DetectorModelDefinition detectorModelDefinition;

    private final String detectorModelDescription;

    private final String roleArn;

    private final String evaluationMethod;

    private UpdateDetectorModelRequest(BuilderImpl builder) {
        super(builder);
        this.detectorModelName = builder.detectorModelName;
        this.detectorModelDefinition = builder.detectorModelDefinition;
        this.detectorModelDescription = builder.detectorModelDescription;
        this.roleArn = builder.roleArn;
        this.evaluationMethod = builder.evaluationMethod;
    }

    /**
     * <p>
     * The name of the detector model that is updated.
     * </p>
     * 
     * @return The name of the detector model that is updated.
     */
    public String detectorModelName() {
        return detectorModelName;
    }

    /**
     * <p>
     * Information that defines how a detector operates.
     * </p>
     * 
     * @return Information that defines how a detector operates.
     */
    public DetectorModelDefinition detectorModelDefinition() {
        return detectorModelDefinition;
    }

    /**
     * <p>
     * A brief description of the detector model.
     * </p>
     * 
     * @return A brief description of the detector model.
     */
    public String detectorModelDescription() {
        return detectorModelDescription;
    }

    /**
     * <p>
     * The ARN of the role that grants permission to AWS IoT Events to perform its operations.
     * </p>
     * 
     * @return The ARN of the role that grants permission to AWS IoT Events to perform its operations.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * When set to <code>SERIAL</code>, variables are updated and event conditions evaluated in the order that the
     * events are defined. When set to <code>BATCH</code>, variables are updated and events performed only after all
     * event conditions are evaluated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMethod}
     * will return {@link EvaluationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationMethodAsString}.
     * </p>
     * 
     * @return When set to <code>SERIAL</code>, variables are updated and event conditions evaluated in the order that
     *         the events are defined. When set to <code>BATCH</code>, variables are updated and events performed only
     *         after all event conditions are evaluated.
     * @see EvaluationMethod
     */
    public EvaluationMethod evaluationMethod() {
        return EvaluationMethod.fromValue(evaluationMethod);
    }

    /**
     * <p>
     * When set to <code>SERIAL</code>, variables are updated and event conditions evaluated in the order that the
     * events are defined. When set to <code>BATCH</code>, variables are updated and events performed only after all
     * event conditions are evaluated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMethod}
     * will return {@link EvaluationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationMethodAsString}.
     * </p>
     * 
     * @return When set to <code>SERIAL</code>, variables are updated and event conditions evaluated in the order that
     *         the events are defined. When set to <code>BATCH</code>, variables are updated and events performed only
     *         after all event conditions are evaluated.
     * @see EvaluationMethod
     */
    public String evaluationMethodAsString() {
        return evaluationMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationMethodAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDetectorModelRequest)) {
            return false;
        }
        UpdateDetectorModelRequest other = (UpdateDetectorModelRequest) obj;
        return Objects.equals(detectorModelName(), other.detectorModelName())
                && Objects.equals(detectorModelDefinition(), other.detectorModelDefinition())
                && Objects.equals(detectorModelDescription(), other.detectorModelDescription())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(evaluationMethodAsString(), other.evaluationMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDetectorModelRequest").add("DetectorModelName", detectorModelName())
                .add("DetectorModelDefinition", detectorModelDefinition())
                .add("DetectorModelDescription", detectorModelDescription()).add("RoleArn", roleArn())
                .add("EvaluationMethod", evaluationMethodAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModelName":
            return Optional.ofNullable(clazz.cast(detectorModelName()));
        case "detectorModelDefinition":
            return Optional.ofNullable(clazz.cast(detectorModelDefinition()));
        case "detectorModelDescription":
            return Optional.ofNullable(clazz.cast(detectorModelDescription()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "evaluationMethod":
            return Optional.ofNullable(clazz.cast(evaluationMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDetectorModelRequest, T> g) {
        return obj -> g.apply((UpdateDetectorModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDetectorModelRequest> {
        /**
         * <p>
         * The name of the detector model that is updated.
         * </p>
         * 
         * @param detectorModelName
         *        The name of the detector model that is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelName(String detectorModelName);

        /**
         * <p>
         * Information that defines how a detector operates.
         * </p>
         * 
         * @param detectorModelDefinition
         *        Information that defines how a detector operates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelDefinition(DetectorModelDefinition detectorModelDefinition);

        /**
         * <p>
         * Information that defines how a detector operates.
         * </p>
         * This is a convenience that creates an instance of the {@link DetectorModelDefinition.Builder} avoiding the
         * need to create one manually via {@link DetectorModelDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetectorModelDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #detectorModelDefinition(DetectorModelDefinition)}.
         * 
         * @param detectorModelDefinition
         *        a consumer that will call methods on {@link DetectorModelDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectorModelDefinition(DetectorModelDefinition)
         */
        default Builder detectorModelDefinition(Consumer<DetectorModelDefinition.Builder> detectorModelDefinition) {
            return detectorModelDefinition(DetectorModelDefinition.builder().applyMutation(detectorModelDefinition).build());
        }

        /**
         * <p>
         * A brief description of the detector model.
         * </p>
         * 
         * @param detectorModelDescription
         *        A brief description of the detector model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelDescription(String detectorModelDescription);

        /**
         * <p>
         * The ARN of the role that grants permission to AWS IoT Events to perform its operations.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants permission to AWS IoT Events to perform its operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * When set to <code>SERIAL</code>, variables are updated and event conditions evaluated in the order that the
         * events are defined. When set to <code>BATCH</code>, variables are updated and events performed only after all
         * event conditions are evaluated.
         * </p>
         * 
         * @param evaluationMethod
         *        When set to <code>SERIAL</code>, variables are updated and event conditions evaluated in the order
         *        that the events are defined. When set to <code>BATCH</code>, variables are updated and events
         *        performed only after all event conditions are evaluated.
         * @see EvaluationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMethod
         */
        Builder evaluationMethod(String evaluationMethod);

        /**
         * <p>
         * When set to <code>SERIAL</code>, variables are updated and event conditions evaluated in the order that the
         * events are defined. When set to <code>BATCH</code>, variables are updated and events performed only after all
         * event conditions are evaluated.
         * </p>
         * 
         * @param evaluationMethod
         *        When set to <code>SERIAL</code>, variables are updated and event conditions evaluated in the order
         *        that the events are defined. When set to <code>BATCH</code>, variables are updated and events
         *        performed only after all event conditions are evaluated.
         * @see EvaluationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMethod
         */
        Builder evaluationMethod(EvaluationMethod evaluationMethod);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsRequest.BuilderImpl implements Builder {
        private String detectorModelName;

        private DetectorModelDefinition detectorModelDefinition;

        private String detectorModelDescription;

        private String roleArn;

        private String evaluationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDetectorModelRequest model) {
            super(model);
            detectorModelName(model.detectorModelName);
            detectorModelDefinition(model.detectorModelDefinition);
            detectorModelDescription(model.detectorModelDescription);
            roleArn(model.roleArn);
            evaluationMethod(model.evaluationMethod);
        }

        public final String getDetectorModelName() {
            return detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        public final DetectorModelDefinition.Builder getDetectorModelDefinition() {
            return detectorModelDefinition != null ? detectorModelDefinition.toBuilder() : null;
        }

        @Override
        public final Builder detectorModelDefinition(DetectorModelDefinition detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition;
            return this;
        }

        public final void setDetectorModelDefinition(DetectorModelDefinition.BuilderImpl detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition != null ? detectorModelDefinition.build() : null;
        }

        public final String getDetectorModelDescription() {
            return detectorModelDescription;
        }

        @Override
        public final Builder detectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
            return this;
        }

        public final void setDetectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getEvaluationMethodAsString() {
            return evaluationMethod;
        }

        @Override
        public final Builder evaluationMethod(String evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
            return this;
        }

        @Override
        public final Builder evaluationMethod(EvaluationMethod evaluationMethod) {
            this.evaluationMethod(evaluationMethod == null ? null : evaluationMethod.toString());
            return this;
        }

        public final void setEvaluationMethod(String evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDetectorModelRequest build() {
            return new UpdateDetectorModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
