/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Includes all client authentication information.
 * </p>
 * */
@Generated("software.amazon.awssdk:codegen")
public final class ClientAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientAuthentication.Builder, ClientAuthentication> {
    private static final SdkField<Tls> TLS_FIELD = SdkField.<Tls> builder(MarshallingType.SDK_POJO)
            .getter(getter(ClientAuthentication::tls)).setter(setter(Builder::tls)).constructor(Tls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Tls tls;

    private ClientAuthentication(BuilderImpl builder) {
        this.tls = builder.tls;
    }

    /**
     *
     * <p>
     * Details for ClientAuthentication using TLS.
     * </p>
     * 
     * @return <p>
     *         Details for ClientAuthentication using TLS.
     *         </p>
     */
    public Tls tls() {
        return tls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tls());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientAuthentication)) {
            return false;
        }
        ClientAuthentication other = (ClientAuthentication) obj;
        return Objects.equals(tls(), other.tls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClientAuthentication").add("Tls", tls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tls":
            return Optional.ofNullable(clazz.cast(tls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientAuthentication, T> g) {
        return obj -> g.apply((ClientAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientAuthentication> {
        /**
         *
         * <p>
         * Details for ClientAuthentication using TLS.
         * </p>
         * 
         * @param tls
         *        <p>
         *        Details for ClientAuthentication using TLS.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tls(Tls tls);

        /**
         *
         * <p>
         * Details for ClientAuthentication using TLS.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link Tls.Builder} avoiding the need to create one
         * manually via {@link Tls#builder()}.
         *
         * When the {@link Consumer} completes, {@link Tls.Builder#build()} is called immediately and its result is
         * passed to {@link #tls(Tls)}.
         * 
         * @param tls
         *        a consumer that will call methods on {@link Tls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tls(Tls)
         */
        default Builder tls(Consumer<Tls.Builder> tls) {
            return tls(Tls.builder().applyMutation(tls).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Tls tls;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientAuthentication model) {
            tls(model.tls);
        }

        public final Tls.Builder getTls() {
            return tls != null ? tls.toBuilder() : null;
        }

        @Override
        public final Builder tls(Tls tls) {
            this.tls = tls;
            return this;
        }

        public final void setTls(Tls.BuilderImpl tls) {
            this.tls = tls != null ? tls.build() : null;
        }

        @Override
        public ClientAuthentication build() {
            return new ClientAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
