/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Returns information about a cluster.
 * </p>
 * */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterInfo implements SdkPojo, Serializable, ToCopyableBuilder<ClusterInfo.Builder, ClusterInfo> {
    private static final SdkField<String> ACTIVE_OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterInfo::activeOperationArn)).setter(setter(Builder::activeOperationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeOperationArn").build())
            .build();

    private static final SdkField<BrokerNodeGroupInfo> BROKER_NODE_GROUP_INFO_FIELD = SdkField
            .<BrokerNodeGroupInfo> builder(MarshallingType.SDK_POJO).getter(getter(ClusterInfo::brokerNodeGroupInfo))
            .setter(setter(Builder::brokerNodeGroupInfo)).constructor(BrokerNodeGroupInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeGroupInfo").build())
            .build();

    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField
            .<ClientAuthentication> builder(MarshallingType.SDK_POJO).getter(getter(ClusterInfo::clientAuthentication))
            .setter(setter(Builder::clientAuthentication)).constructor(ClientAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build())
            .build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterInfo::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterInfo::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ClusterInfo::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<BrokerSoftwareInfo> CURRENT_BROKER_SOFTWARE_INFO_FIELD = SdkField
            .<BrokerSoftwareInfo> builder(MarshallingType.SDK_POJO).getter(getter(ClusterInfo::currentBrokerSoftwareInfo))
            .setter(setter(Builder::currentBrokerSoftwareInfo)).constructor(BrokerSoftwareInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBrokerSoftwareInfo").build())
            .build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterInfo::currentVersion)).setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField
            .<EncryptionInfo> builder(MarshallingType.SDK_POJO).getter(getter(ClusterInfo::encryptionInfo))
            .setter(setter(Builder::encryptionInfo)).constructor(EncryptionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()).build();

    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterInfo::enhancedMonitoringAsString)).setter(setter(Builder::enhancedMonitoring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build())
            .build();

    private static final SdkField<OpenMonitoring> OPEN_MONITORING_FIELD = SdkField
            .<OpenMonitoring> builder(MarshallingType.SDK_POJO).getter(getter(ClusterInfo::openMonitoring))
            .setter(setter(Builder::openMonitoring)).constructor(OpenMonitoring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()).build();

    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ClusterInfo::numberOfBrokerNodes)).setter(setter(Builder::numberOfBrokerNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterInfo::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ClusterInfo::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterInfo::zookeeperConnectString)).setter(setter(Builder::zookeeperConnectString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectString").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_OPERATION_ARN_FIELD,
            BROKER_NODE_GROUP_INFO_FIELD, CLIENT_AUTHENTICATION_FIELD, CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD,
            CREATION_TIME_FIELD, CURRENT_BROKER_SOFTWARE_INFO_FIELD, CURRENT_VERSION_FIELD, ENCRYPTION_INFO_FIELD,
            ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD, NUMBER_OF_BROKER_NODES_FIELD, STATE_FIELD, TAGS_FIELD,
            ZOOKEEPER_CONNECT_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activeOperationArn;

    private final BrokerNodeGroupInfo brokerNodeGroupInfo;

    private final ClientAuthentication clientAuthentication;

    private final String clusterArn;

    private final String clusterName;

    private final Instant creationTime;

    private final BrokerSoftwareInfo currentBrokerSoftwareInfo;

    private final String currentVersion;

    private final EncryptionInfo encryptionInfo;

    private final String enhancedMonitoring;

    private final OpenMonitoring openMonitoring;

    private final Integer numberOfBrokerNodes;

    private final String state;

    private final Map<String, String> tags;

    private final String zookeeperConnectString;

    private ClusterInfo(BuilderImpl builder) {
        this.activeOperationArn = builder.activeOperationArn;
        this.brokerNodeGroupInfo = builder.brokerNodeGroupInfo;
        this.clientAuthentication = builder.clientAuthentication;
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.creationTime = builder.creationTime;
        this.currentBrokerSoftwareInfo = builder.currentBrokerSoftwareInfo;
        this.currentVersion = builder.currentVersion;
        this.encryptionInfo = builder.encryptionInfo;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.state = builder.state;
        this.tags = builder.tags;
        this.zookeeperConnectString = builder.zookeeperConnectString;
    }

    /**
     *
     * <p>
     * Arn of active cluster operation.
     * </p>
     * 
     * @return <p>
     *         Arn of active cluster operation.
     *         </p>
     */
    public String activeOperationArn() {
        return activeOperationArn;
    }

    /**
     *
     * <p>
     * Information about the broker nodes.
     * </p>
     * 
     * @return <p>
     *         Information about the broker nodes.
     *         </p>
     */
    public BrokerNodeGroupInfo brokerNodeGroupInfo() {
        return brokerNodeGroupInfo;
    }

    /**
     *
     * <p>
     * Includes all client authentication information.
     * </p>
     * 
     * @return <p>
     *         Includes all client authentication information.
     *         </p>
     */
    public ClientAuthentication clientAuthentication() {
        return clientAuthentication;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     *         </p>
     */
    public String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return <p>
     *         The name of the cluster.
     *         </p>
     */
    public String clusterName() {
        return clusterName;
    }

    /**
     *
     * <p>
     * The time when the cluster was created.
     * </p>
     * 
     * @return <p>
     *         The time when the cluster was created.
     *         </p>
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     *
     * <p>
     * Information about the version of software currently deployed on the Kafka brokers in the cluster.
     * </p>
     * 
     * @return <p>
     *         Information about the version of software currently deployed on the Kafka brokers in the cluster.
     *         </p>
     */
    public BrokerSoftwareInfo currentBrokerSoftwareInfo() {
        return currentBrokerSoftwareInfo;
    }

    /**
     *
     * <p>
     * The current version of the MSK cluster.
     * </p>
     * 
     * @return <p>
     *         The current version of the MSK cluster.
     *         </p>
     */
    public String currentVersion() {
        return currentVersion;
    }

    /**
     *
     * <p>
     * Includes all encryption-related information.
     * </p>
     * 
     * @return <p>
     *         Includes all encryption-related information.
     *         </p>
     */
    public EncryptionInfo encryptionInfo() {
        return encryptionInfo;
    }

    /**
     *
     * <p>
     * Specifies which metrics are gathered for the MSK cluster. This property has three possible values: DEFAULT,
     * PER_BROKER, and PER_TOPIC_PER_BROKER. For a list of the metrics associated with each of these three levels of
     * monitoring, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies which metrics are gathered for the MSK cluster. This property has three possible values:
     *         DEFAULT, PER_BROKER, and PER_TOPIC_PER_BROKER. For a list of the metrics associated with each of these
     *         three levels of monitoring, see <a
     *         href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
     *         </p>
     * @see EnhancedMonitoring
     */
    public EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(enhancedMonitoring);
    }

    /**
     *
     * <p>
     * Specifies which metrics are gathered for the MSK cluster. This property has three possible values: DEFAULT,
     * PER_BROKER, and PER_TOPIC_PER_BROKER. For a list of the metrics associated with each of these three levels of
     * monitoring, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies which metrics are gathered for the MSK cluster. This property has three possible values:
     *         DEFAULT, PER_BROKER, and PER_TOPIC_PER_BROKER. For a list of the metrics associated with each of these
     *         three levels of monitoring, see <a
     *         href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
     *         </p>
     * @see EnhancedMonitoring
     */
    public String enhancedMonitoringAsString() {
        return enhancedMonitoring;
    }

    /**
     *
     * <p>
     * Settings for open monitoring using Prometheus.
     * </p>
     * 
     * @return <p>
     *         Settings for open monitoring using Prometheus.
     *         </p>
     */
    public OpenMonitoring openMonitoring() {
        return openMonitoring;
    }

    /**
     *
     * <p>
     * The number of broker nodes in the cluster.
     * </p>
     * 
     * @return <p>
     *         The number of broker nodes in the cluster.
     *         </p>
     */
    public Integer numberOfBrokerNodes() {
        return numberOfBrokerNodes;
    }

    /**
     *
     * <p>
     * The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
     *         </p>
     * @see ClusterState
     */
    public ClusterState state() {
        return ClusterState.fromValue(state);
    }

    /**
     *
     * <p>
     * The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
     *         </p>
     * @see ClusterState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     *
     * <p>
     * Tags attached to the cluster.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         Tags attached to the cluster.
     *         </p>
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     *
     * <p>
     * The connection string to use to connect to the Apache ZooKeeper cluster.
     * </p>
     * 
     * @return <p>
     *         The connection string to use to connect to the Apache ZooKeeper cluster.
     *         </p>
     */
    public String zookeeperConnectString() {
        return zookeeperConnectString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(brokerNodeGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(currentBrokerSoftwareInfo());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(zookeeperConnectString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInfo)) {
            return false;
        }
        ClusterInfo other = (ClusterInfo) obj;
        return Objects.equals(activeOperationArn(), other.activeOperationArn())
                && Objects.equals(brokerNodeGroupInfo(), other.brokerNodeGroupInfo())
                && Objects.equals(clientAuthentication(), other.clientAuthentication())
                && Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(currentBrokerSoftwareInfo(), other.currentBrokerSoftwareInfo())
                && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(encryptionInfo(), other.encryptionInfo())
                && Objects.equals(enhancedMonitoringAsString(), other.enhancedMonitoringAsString())
                && Objects.equals(openMonitoring(), other.openMonitoring())
                && Objects.equals(numberOfBrokerNodes(), other.numberOfBrokerNodes())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(tags(), other.tags())
                && Objects.equals(zookeeperConnectString(), other.zookeeperConnectString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClusterInfo").add("ActiveOperationArn", activeOperationArn())
                .add("BrokerNodeGroupInfo", brokerNodeGroupInfo()).add("ClientAuthentication", clientAuthentication())
                .add("ClusterArn", clusterArn()).add("ClusterName", clusterName()).add("CreationTime", creationTime())
                .add("CurrentBrokerSoftwareInfo", currentBrokerSoftwareInfo()).add("CurrentVersion", currentVersion())
                .add("EncryptionInfo", encryptionInfo()).add("EnhancedMonitoring", enhancedMonitoringAsString())
                .add("OpenMonitoring", openMonitoring()).add("NumberOfBrokerNodes", numberOfBrokerNodes())
                .add("State", stateAsString()).add("Tags", tags()).add("ZookeeperConnectString", zookeeperConnectString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveOperationArn":
            return Optional.ofNullable(clazz.cast(activeOperationArn()));
        case "BrokerNodeGroupInfo":
            return Optional.ofNullable(clazz.cast(brokerNodeGroupInfo()));
        case "ClientAuthentication":
            return Optional.ofNullable(clazz.cast(clientAuthentication()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CurrentBrokerSoftwareInfo":
            return Optional.ofNullable(clazz.cast(currentBrokerSoftwareInfo()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "EncryptionInfo":
            return Optional.ofNullable(clazz.cast(encryptionInfo()));
        case "EnhancedMonitoring":
            return Optional.ofNullable(clazz.cast(enhancedMonitoringAsString()));
        case "OpenMonitoring":
            return Optional.ofNullable(clazz.cast(openMonitoring()));
        case "NumberOfBrokerNodes":
            return Optional.ofNullable(clazz.cast(numberOfBrokerNodes()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ZookeeperConnectString":
            return Optional.ofNullable(clazz.cast(zookeeperConnectString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterInfo, T> g) {
        return obj -> g.apply((ClusterInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterInfo> {
        /**
         *
         * <p>
         * Arn of active cluster operation.
         * </p>
         * 
         * @param activeOperationArn
         *        <p>
         *        Arn of active cluster operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeOperationArn(String activeOperationArn);

        /**
         *
         * <p>
         * Information about the broker nodes.
         * </p>
         * 
         * @param brokerNodeGroupInfo
         *        <p>
         *        Information about the broker nodes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo);

        /**
         *
         * <p>
         * Information about the broker nodes.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link BrokerNodeGroupInfo.Builder} avoiding the need
         * to create one manually via {@link BrokerNodeGroupInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link BrokerNodeGroupInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #brokerNodeGroupInfo(BrokerNodeGroupInfo)}.
         * 
         * @param brokerNodeGroupInfo
         *        a consumer that will call methods on {@link BrokerNodeGroupInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerNodeGroupInfo(BrokerNodeGroupInfo)
         */
        default Builder brokerNodeGroupInfo(Consumer<BrokerNodeGroupInfo.Builder> brokerNodeGroupInfo) {
            return brokerNodeGroupInfo(BrokerNodeGroupInfo.builder().applyMutation(brokerNodeGroupInfo).build());
        }

        /**
         *
         * <p>
         * Includes all client authentication information.
         * </p>
         * 
         * @param clientAuthentication
         *        <p>
         *        Includes all client authentication information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAuthentication(ClientAuthentication clientAuthentication);

        /**
         *
         * <p>
         * Includes all client authentication information.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link ClientAuthentication.Builder} avoiding the need
         * to create one manually via {@link ClientAuthentication#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientAuthentication.Builder#build()} is called immediately and
         * its result is passed to {@link #clientAuthentication(ClientAuthentication)}.
         * 
         * @param clientAuthentication
         *        a consumer that will call methods on {@link ClientAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientAuthentication(ClientAuthentication)
         */
        default Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return clientAuthentication(ClientAuthentication.builder().applyMutation(clientAuthentication).build());
        }

        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param clusterName
         *        <p>
         *        The name of the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         *
         * <p>
         * The time when the cluster was created.
         * </p>
         * 
         * @param creationTime
         *        <p>
         *        The time when the cluster was created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         *
         * <p>
         * Information about the version of software currently deployed on the Kafka brokers in the cluster.
         * </p>
         * 
         * @param currentBrokerSoftwareInfo
         *        <p>
         *        Information about the version of software currently deployed on the Kafka brokers in the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo);

        /**
         *
         * <p>
         * Information about the version of software currently deployed on the Kafka brokers in the cluster.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link BrokerSoftwareInfo.Builder} avoiding the need to
         * create one manually via {@link BrokerSoftwareInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link BrokerSoftwareInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #currentBrokerSoftwareInfo(BrokerSoftwareInfo)}.
         * 
         * @param currentBrokerSoftwareInfo
         *        a consumer that will call methods on {@link BrokerSoftwareInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentBrokerSoftwareInfo(BrokerSoftwareInfo)
         */
        default Builder currentBrokerSoftwareInfo(Consumer<BrokerSoftwareInfo.Builder> currentBrokerSoftwareInfo) {
            return currentBrokerSoftwareInfo(BrokerSoftwareInfo.builder().applyMutation(currentBrokerSoftwareInfo).build());
        }

        /**
         *
         * <p>
         * The current version of the MSK cluster.
         * </p>
         * 
         * @param currentVersion
         *        <p>
         *        The current version of the MSK cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * @param encryptionInfo
         *        <p>
         *        Includes all encryption-related information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionInfo(EncryptionInfo encryptionInfo);

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link EncryptionInfo.Builder} avoiding the need to
         * create one manually via {@link EncryptionInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionInfo(EncryptionInfo)}.
         * 
         * @param encryptionInfo
         *        a consumer that will call methods on {@link EncryptionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionInfo(EncryptionInfo)
         */
        default Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return encryptionInfo(EncryptionInfo.builder().applyMutation(encryptionInfo).build());
        }

        /**
         *
         * <p>
         * Specifies which metrics are gathered for the MSK cluster. This property has three possible values: DEFAULT,
         * PER_BROKER, and PER_TOPIC_PER_BROKER. For a list of the metrics associated with each of these three levels of
         * monitoring, see <a
         * href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies which metrics are gathered for the MSK cluster. This property has three possible values:
         *        DEFAULT, PER_BROKER, and PER_TOPIC_PER_BROKER. For a list of the metrics associated with each of these
         *        three levels of monitoring, see <a
         *        href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(String enhancedMonitoring);

        /**
         *
         * <p>
         * Specifies which metrics are gathered for the MSK cluster. This property has three possible values: DEFAULT,
         * PER_BROKER, and PER_TOPIC_PER_BROKER. For a list of the metrics associated with each of these three levels of
         * monitoring, see <a
         * href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies which metrics are gathered for the MSK cluster. This property has three possible values:
         *        DEFAULT, PER_BROKER, and PER_TOPIC_PER_BROKER. For a list of the metrics associated with each of these
         *        three levels of monitoring, see <a
         *        href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring);

        /**
         *
         * <p>
         * Settings for open monitoring using Prometheus.
         * </p>
         * 
         * @param openMonitoring
         *        <p>
         *        Settings for open monitoring using Prometheus.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openMonitoring(OpenMonitoring openMonitoring);

        /**
         *
         * <p>
         * Settings for open monitoring using Prometheus.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link OpenMonitoring.Builder} avoiding the need to
         * create one manually via {@link OpenMonitoring#builder()}.
         *
         * When the {@link Consumer} completes, {@link OpenMonitoring.Builder#build()} is called immediately and its
         * result is passed to {@link #openMonitoring(OpenMonitoring)}.
         * 
         * @param openMonitoring
         *        a consumer that will call methods on {@link OpenMonitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openMonitoring(OpenMonitoring)
         */
        default Builder openMonitoring(Consumer<OpenMonitoring.Builder> openMonitoring) {
            return openMonitoring(OpenMonitoring.builder().applyMutation(openMonitoring).build());
        }

        /**
         *
         * <p>
         * The number of broker nodes in the cluster.
         * </p>
         * 
         * @param numberOfBrokerNodes
         *        <p>
         *        The number of broker nodes in the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBrokerNodes(Integer numberOfBrokerNodes);

        /**
         *
         * <p>
         * The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
         *        </p>
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(String state);

        /**
         *
         * <p>
         * The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
         *        </p>
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(ClusterState state);

        /**
         *
         * <p>
         * Tags attached to the cluster.
         * </p>
         * 
         * @param tags
         *        <p>
         *        Tags attached to the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         *
         * <p>
         * The connection string to use to connect to the Apache ZooKeeper cluster.
         * </p>
         * 
         * @param zookeeperConnectString
         *        <p>
         *        The connection string to use to connect to the Apache ZooKeeper cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zookeeperConnectString(String zookeeperConnectString);
    }

    static final class BuilderImpl implements Builder {
        private String activeOperationArn;

        private BrokerNodeGroupInfo brokerNodeGroupInfo;

        private ClientAuthentication clientAuthentication;

        private String clusterArn;

        private String clusterName;

        private Instant creationTime;

        private BrokerSoftwareInfo currentBrokerSoftwareInfo;

        private String currentVersion;

        private EncryptionInfo encryptionInfo;

        private String enhancedMonitoring;

        private OpenMonitoring openMonitoring;

        private Integer numberOfBrokerNodes;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String zookeeperConnectString;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInfo model) {
            activeOperationArn(model.activeOperationArn);
            brokerNodeGroupInfo(model.brokerNodeGroupInfo);
            clientAuthentication(model.clientAuthentication);
            clusterArn(model.clusterArn);
            clusterName(model.clusterName);
            creationTime(model.creationTime);
            currentBrokerSoftwareInfo(model.currentBrokerSoftwareInfo);
            currentVersion(model.currentVersion);
            encryptionInfo(model.encryptionInfo);
            enhancedMonitoring(model.enhancedMonitoring);
            openMonitoring(model.openMonitoring);
            numberOfBrokerNodes(model.numberOfBrokerNodes);
            state(model.state);
            tags(model.tags);
            zookeeperConnectString(model.zookeeperConnectString);
        }

        public final String getActiveOperationArn() {
            return activeOperationArn;
        }

        @Override
        public final Builder activeOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
            return this;
        }

        public final void setActiveOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
        }

        public final BrokerNodeGroupInfo.Builder getBrokerNodeGroupInfo() {
            return brokerNodeGroupInfo != null ? brokerNodeGroupInfo.toBuilder() : null;
        }

        @Override
        public final Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        public final void setBrokerNodeGroupInfo(BrokerNodeGroupInfo.BuilderImpl brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo != null ? brokerNodeGroupInfo.build() : null;
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return clientAuthentication != null ? clientAuthentication.toBuilder() : null;
        }

        @Override
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getClusterName() {
            return clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final BrokerSoftwareInfo.Builder getCurrentBrokerSoftwareInfo() {
            return currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.toBuilder() : null;
        }

        @Override
        public final Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
            return this;
        }

        public final void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo.BuilderImpl currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.build() : null;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return encryptionInfo != null ? encryptionInfo.toBuilder() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        public final String getEnhancedMonitoringAsString() {
            return enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        public final OpenMonitoring.Builder getOpenMonitoring() {
            return openMonitoring != null ? openMonitoring.toBuilder() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoring openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final void setOpenMonitoring(OpenMonitoring.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        public final Integer getNumberOfBrokerNodes() {
            return numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        public final String getZookeeperConnectString() {
            return zookeeperConnectString;
        }

        @Override
        public final Builder zookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
            return this;
        }

        public final void setZookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
        }

        @Override
        public ClusterInfo build() {
            return new ClusterInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
