/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Returns information about a cluster operation.
 * </p>
 * */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterOperationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterOperationInfo.Builder, ClusterOperationInfo> {
    private static final SdkField<String> CLIENT_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterOperationInfo::clientRequestId)).setter(setter(Builder::clientRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestId").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterOperationInfo::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ClusterOperationInfo::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ClusterOperationInfo::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(ClusterOperationInfo::errorInfo)).setter(setter(Builder::errorInfo)).constructor(ErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()).build();

    private static final SdkField<String> OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterOperationInfo::operationArn)).setter(setter(Builder::operationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationArn").build()).build();

    private static final SdkField<String> OPERATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterOperationInfo::operationState)).setter(setter(Builder::operationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationState").build()).build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterOperationInfo::operationType)).setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()).build();

    private static final SdkField<MutableClusterInfo> SOURCE_CLUSTER_INFO_FIELD = SdkField
            .<MutableClusterInfo> builder(MarshallingType.SDK_POJO).getter(getter(ClusterOperationInfo::sourceClusterInfo))
            .setter(setter(Builder::sourceClusterInfo)).constructor(MutableClusterInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceClusterInfo").build()).build();

    private static final SdkField<MutableClusterInfo> TARGET_CLUSTER_INFO_FIELD = SdkField
            .<MutableClusterInfo> builder(MarshallingType.SDK_POJO).getter(getter(ClusterOperationInfo::targetClusterInfo))
            .setter(setter(Builder::targetClusterInfo)).constructor(MutableClusterInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetClusterInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_ID_FIELD,
            CLUSTER_ARN_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, ERROR_INFO_FIELD, OPERATION_ARN_FIELD, OPERATION_STATE_FIELD,
            OPERATION_TYPE_FIELD, SOURCE_CLUSTER_INFO_FIELD, TARGET_CLUSTER_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientRequestId;

    private final String clusterArn;

    private final Instant creationTime;

    private final Instant endTime;

    private final ErrorInfo errorInfo;

    private final String operationArn;

    private final String operationState;

    private final String operationType;

    private final MutableClusterInfo sourceClusterInfo;

    private final MutableClusterInfo targetClusterInfo;

    private ClusterOperationInfo(BuilderImpl builder) {
        this.clientRequestId = builder.clientRequestId;
        this.clusterArn = builder.clusterArn;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.errorInfo = builder.errorInfo;
        this.operationArn = builder.operationArn;
        this.operationState = builder.operationState;
        this.operationType = builder.operationType;
        this.sourceClusterInfo = builder.sourceClusterInfo;
        this.targetClusterInfo = builder.targetClusterInfo;
    }

    /**
     *
     * <p>
     * The ID of the API request that triggered this operation.
     * </p>
     * 
     * @return <p>
     *         The ID of the API request that triggered this operation.
     *         </p>
     */
    public String clientRequestId() {
        return clientRequestId;
    }

    /**
     *
     * <p>
     * ARN of the cluster.
     * </p>
     * 
     * @return <p>
     *         ARN of the cluster.
     *         </p>
     */
    public String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * The time that the operation was created.
     * </p>
     * 
     * @return <p>
     *         The time that the operation was created.
     *         </p>
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     *
     * <p>
     * The time at which the operation finished.
     * </p>
     * 
     * @return <p>
     *         The time at which the operation finished.
     *         </p>
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     *
     * <p>
     * Describes the error if the operation fails.
     * </p>
     * 
     * @return <p>
     *         Describes the error if the operation fails.
     *         </p>
     */
    public ErrorInfo errorInfo() {
        return errorInfo;
    }

    /**
     *
     * <p>
     * ARN of the cluster operation.
     * </p>
     * 
     * @return <p>
     *         ARN of the cluster operation.
     *         </p>
     */
    public String operationArn() {
        return operationArn;
    }

    /**
     *
     * <p>
     * State of the cluster operation.
     * </p>
     * 
     * @return <p>
     *         State of the cluster operation.
     *         </p>
     */
    public String operationState() {
        return operationState;
    }

    /**
     *
     * <p>
     * Type of the cluster operation.
     * </p>
     * 
     * @return <p>
     *         Type of the cluster operation.
     *         </p>
     */
    public String operationType() {
        return operationType;
    }

    /**
     *
     * <p>
     * Information about cluster attributes before a cluster is updated.
     * </p>
     * 
     * @return <p>
     *         Information about cluster attributes before a cluster is updated.
     *         </p>
     */
    public MutableClusterInfo sourceClusterInfo() {
        return sourceClusterInfo;
    }

    /**
     *
     * <p>
     * Information about cluster attributes after a cluster is updated.
     * </p>
     * 
     * @return <p>
     *         Information about cluster attributes after a cluster is updated.
     *         </p>
     */
    public MutableClusterInfo targetClusterInfo() {
        return targetClusterInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(operationArn());
        hashCode = 31 * hashCode + Objects.hashCode(operationState());
        hashCode = 31 * hashCode + Objects.hashCode(operationType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceClusterInfo());
        hashCode = 31 * hashCode + Objects.hashCode(targetClusterInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationInfo)) {
            return false;
        }
        ClusterOperationInfo other = (ClusterOperationInfo) obj;
        return Objects.equals(clientRequestId(), other.clientRequestId()) && Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(errorInfo(), other.errorInfo()) && Objects.equals(operationArn(), other.operationArn())
                && Objects.equals(operationState(), other.operationState())
                && Objects.equals(operationType(), other.operationType())
                && Objects.equals(sourceClusterInfo(), other.sourceClusterInfo())
                && Objects.equals(targetClusterInfo(), other.targetClusterInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClusterOperationInfo").add("ClientRequestId", clientRequestId()).add("ClusterArn", clusterArn())
                .add("CreationTime", creationTime()).add("EndTime", endTime()).add("ErrorInfo", errorInfo())
                .add("OperationArn", operationArn()).add("OperationState", operationState())
                .add("OperationType", operationType()).add("SourceClusterInfo", sourceClusterInfo())
                .add("TargetClusterInfo", targetClusterInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestId":
            return Optional.ofNullable(clazz.cast(clientRequestId()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ErrorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        case "OperationArn":
            return Optional.ofNullable(clazz.cast(operationArn()));
        case "OperationState":
            return Optional.ofNullable(clazz.cast(operationState()));
        case "OperationType":
            return Optional.ofNullable(clazz.cast(operationType()));
        case "SourceClusterInfo":
            return Optional.ofNullable(clazz.cast(sourceClusterInfo()));
        case "TargetClusterInfo":
            return Optional.ofNullable(clazz.cast(targetClusterInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterOperationInfo, T> g) {
        return obj -> g.apply((ClusterOperationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterOperationInfo> {
        /**
         *
         * <p>
         * The ID of the API request that triggered this operation.
         * </p>
         * 
         * @param clientRequestId
         *        <p>
         *        The ID of the API request that triggered this operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestId(String clientRequestId);

        /**
         *
         * <p>
         * ARN of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        ARN of the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * The time that the operation was created.
         * </p>
         * 
         * @param creationTime
         *        <p>
         *        The time that the operation was created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         *
         * <p>
         * The time at which the operation finished.
         * </p>
         * 
         * @param endTime
         *        <p>
         *        The time at which the operation finished.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         *
         * <p>
         * Describes the error if the operation fails.
         * </p>
         * 
         * @param errorInfo
         *        <p>
         *        Describes the error if the operation fails.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(ErrorInfo errorInfo);

        /**
         *
         * <p>
         * Describes the error if the operation fails.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link ErrorInfo.Builder} avoiding the need to create
         * one manually via {@link ErrorInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #errorInfo(ErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(ErrorInfo)
         */
        default Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return errorInfo(ErrorInfo.builder().applyMutation(errorInfo).build());
        }

        /**
         *
         * <p>
         * ARN of the cluster operation.
         * </p>
         * 
         * @param operationArn
         *        <p>
         *        ARN of the cluster operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationArn(String operationArn);

        /**
         *
         * <p>
         * State of the cluster operation.
         * </p>
         * 
         * @param operationState
         *        <p>
         *        State of the cluster operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationState(String operationState);

        /**
         *
         * <p>
         * Type of the cluster operation.
         * </p>
         * 
         * @param operationType
         *        <p>
         *        Type of the cluster operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationType(String operationType);

        /**
         *
         * <p>
         * Information about cluster attributes before a cluster is updated.
         * </p>
         * 
         * @param sourceClusterInfo
         *        <p>
         *        Information about cluster attributes before a cluster is updated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceClusterInfo(MutableClusterInfo sourceClusterInfo);

        /**
         *
         * <p>
         * Information about cluster attributes before a cluster is updated.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link MutableClusterInfo.Builder} avoiding the need to
         * create one manually via {@link MutableClusterInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link MutableClusterInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceClusterInfo(MutableClusterInfo)}.
         * 
         * @param sourceClusterInfo
         *        a consumer that will call methods on {@link MutableClusterInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceClusterInfo(MutableClusterInfo)
         */
        default Builder sourceClusterInfo(Consumer<MutableClusterInfo.Builder> sourceClusterInfo) {
            return sourceClusterInfo(MutableClusterInfo.builder().applyMutation(sourceClusterInfo).build());
        }

        /**
         *
         * <p>
         * Information about cluster attributes after a cluster is updated.
         * </p>
         * 
         * @param targetClusterInfo
         *        <p>
         *        Information about cluster attributes after a cluster is updated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetClusterInfo(MutableClusterInfo targetClusterInfo);

        /**
         *
         * <p>
         * Information about cluster attributes after a cluster is updated.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link MutableClusterInfo.Builder} avoiding the need to
         * create one manually via {@link MutableClusterInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link MutableClusterInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #targetClusterInfo(MutableClusterInfo)}.
         * 
         * @param targetClusterInfo
         *        a consumer that will call methods on {@link MutableClusterInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetClusterInfo(MutableClusterInfo)
         */
        default Builder targetClusterInfo(Consumer<MutableClusterInfo.Builder> targetClusterInfo) {
            return targetClusterInfo(MutableClusterInfo.builder().applyMutation(targetClusterInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String clientRequestId;

        private String clusterArn;

        private Instant creationTime;

        private Instant endTime;

        private ErrorInfo errorInfo;

        private String operationArn;

        private String operationState;

        private String operationType;

        private MutableClusterInfo sourceClusterInfo;

        private MutableClusterInfo targetClusterInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOperationInfo model) {
            clientRequestId(model.clientRequestId);
            clusterArn(model.clusterArn);
            creationTime(model.creationTime);
            endTime(model.endTime);
            errorInfo(model.errorInfo);
            operationArn(model.operationArn);
            operationState(model.operationState);
            operationType(model.operationType);
            sourceClusterInfo(model.sourceClusterInfo);
            targetClusterInfo(model.targetClusterInfo);
        }

        public final String getClientRequestId() {
            return clientRequestId;
        }

        @Override
        public final Builder clientRequestId(String clientRequestId) {
            this.clientRequestId = clientRequestId;
            return this;
        }

        public final void setClientRequestId(String clientRequestId) {
            this.clientRequestId = clientRequestId;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        public final String getOperationArn() {
            return operationArn;
        }

        @Override
        public final Builder operationArn(String operationArn) {
            this.operationArn = operationArn;
            return this;
        }

        public final void setOperationArn(String operationArn) {
            this.operationArn = operationArn;
        }

        public final String getOperationState() {
            return operationState;
        }

        @Override
        public final Builder operationState(String operationState) {
            this.operationState = operationState;
            return this;
        }

        public final void setOperationState(String operationState) {
            this.operationState = operationState;
        }

        public final String getOperationType() {
            return operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final MutableClusterInfo.Builder getSourceClusterInfo() {
            return sourceClusterInfo != null ? sourceClusterInfo.toBuilder() : null;
        }

        @Override
        public final Builder sourceClusterInfo(MutableClusterInfo sourceClusterInfo) {
            this.sourceClusterInfo = sourceClusterInfo;
            return this;
        }

        public final void setSourceClusterInfo(MutableClusterInfo.BuilderImpl sourceClusterInfo) {
            this.sourceClusterInfo = sourceClusterInfo != null ? sourceClusterInfo.build() : null;
        }

        public final MutableClusterInfo.Builder getTargetClusterInfo() {
            return targetClusterInfo != null ? targetClusterInfo.toBuilder() : null;
        }

        @Override
        public final Builder targetClusterInfo(MutableClusterInfo targetClusterInfo) {
            this.targetClusterInfo = targetClusterInfo;
            return this;
        }

        public final void setTargetClusterInfo(MutableClusterInfo.BuilderImpl targetClusterInfo) {
            this.targetClusterInfo = targetClusterInfo != null ? targetClusterInfo.build() : null;
        }

        @Override
        public ClusterOperationInfo build() {
            return new ClusterOperationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
